/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class StackIngredient
extends Ingredient {
    public static final StackIngredient EMPTY = new StackIngredient(Collections.emptySet(), 0);
    public static final Codec<StackIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodec((Codec)BuiltInRegistries.ITEM.byNameCodec(), (String)"item").forGetter(StackIngredient::getContainedItems), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(StackIngredient::getCount)).apply((Applicative)builder, StackIngredient::new));
    public static final Codec<StackIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodecNotEmpty((Codec)BuiltInRegistries.ITEM.byNameCodec(), (String)"item").forGetter(StackIngredient::getContainedItems), (App)Codec.INT.optionalFieldOf("strict", (Object)11).forGetter(StackIngredient::getCount)).apply((Applicative)builder, StackIngredient::new));
    private final int count;

    private StackIngredient(Set<Item> items, int count) {
        this((Stream<? extends Ingredient.Value>)items.stream().map(item -> new Ingredient.ItemValue(new ItemStack((ItemLike)item, count))), count, (Supplier<? extends IngredientType<?>>)DEContent.NBT_INGREDIENT_TYPE);
    }

    protected StackIngredient(Stream<? extends Ingredient.Value> itemLists, int count, Supplier<? extends IngredientType<?>> type) {
        super(itemLists, type);
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.getItems().length == 0) {
            return stack.isEmpty();
        }
        for (ItemStack itemstack : this.getItems()) {
            if (itemstack.getItem() != stack.getItem() || stack.getCount() < this.count) continue;
            return true;
        }
        return false;
    }

    public boolean itemTest(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.getItems().length == 0) {
            return stack.isEmpty();
        }
        for (ItemStack itemstack : this.getItems()) {
            if (itemstack.getItem() != stack.getItem()) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(itemList -> itemList.getItems().stream()).peek(stack -> stack.setCount(this.count)).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    public Set<Item> getContainedItems() {
        return Arrays.stream(this.getItems()).map(ItemStack::getItem).collect(Collectors.toSet());
    }

    public static StackIngredient fromItemListStream(Stream<? extends Ingredient.Value> stream, int count) {
        StackIngredient ingredient = new StackIngredient(stream, count, (Supplier<? extends IngredientType<?>>)DEContent.NBT_INGREDIENT_TYPE);
        return ingredient.values.length == 0 ? EMPTY : ingredient;
    }

    public static StackIngredient fromItems(int count, ItemLike ... itemsIn) {
        return StackIngredient.fromStacks(Arrays.stream(itemsIn).map(ItemStack::new), count);
    }

    public static StackIngredient fromStacks(int count, ItemStack ... stacks) {
        return StackIngredient.fromStacks(Arrays.stream(stacks), count);
    }

    public static StackIngredient fromStacks(Stream<ItemStack> stacks, int count) {
        return StackIngredient.fromItemListStream(stacks.filter(stack -> !stack.isEmpty()).map(Ingredient.ItemValue::new), count);
    }

    public static StackIngredient fromTag(TagKey<Item> tagIn, int count) {
        return StackIngredient.fromItemListStream(Stream.of(new Ingredient.TagValue(tagIn)), count);
    }
}

