/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules;

import codechicken.lib.gui.modular.sprite.Material;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.data.ModuleProperties;
import com.brandon3055.draconicevolution.api.modules.lib.EntityOverridesItemUse;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.client.ModuleTextures;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public interface Module<T extends ModuleData<T>> {
    public ModuleType<T> getType();

    public ModuleProperties<T> getProperties();

    default public T getData() {
        return this.getProperties().getData();
    }

    default public TechLevel getModuleTechLevel() {
        return this.getProperties().getTechLevel();
    }

    public Item getItem();

    default public Collection<ModuleCategory> getCategories() {
        return this.getType().getCategories();
    }

    default public ModuleEntity<?> createEntity() {
        return this.getType().createEntity(this);
    }

    default public InstallResult areModulesCompatible(Module<?> otherModule) {
        if (this.createEntity() instanceof EntityOverridesItemUse && otherModule.createEntity() instanceof EntityOverridesItemUse) {
            return new InstallResult(InstallResult.InstallResultType.NO, this, otherModule, List.of(Component.translatable((String)"modular_item.draconicevolution.error.only_one_use_override_module").withStyle(ChatFormatting.RED), Component.translatable((String)"modular_item.draconicevolution.error.not_compatible_with").withStyle(ChatFormatting.GRAY).append(": ").append((Component)Component.translatable((String)otherModule.getItem().getDescriptionId()))));
        }
        return this.getType().areModulesCompatible(this, otherModule);
    }

    default public int maxInstallable() {
        return this.getType().maxInstallable();
    }

    default public void addInformation(List<Component> toolTip, ModuleContext context) {
        this.getProperties().addStats(toolTip, this, context);
        if (this.maxInstallable() != -1) {
            toolTip.add((Component)Component.translatable((String)"module.draconicevolution.max_installable").withStyle(ChatFormatting.GRAY).append(": ").append((Component)Component.literal((String)String.valueOf(this.maxInstallable())).withStyle(ChatFormatting.DARK_GREEN)));
        }
    }

    default public InstallResult doInstallationCheck(Stream<Module<?>> moduleStream) {
        List<Module<?>> view = moduleStream.toList();
        Optional<InstallResult> opt = view.stream().map(other -> this.areModulesCompatible((Module<?>)other).getBlockingResult(other.areModulesCompatible(this))).filter(e -> e.resultType == InstallResult.InstallResultType.NO || e.resultType == InstallResult.InstallResultType.ONLY_WHEN_OVERRIDEN).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        Iterable newModules = Iterables.concat(view, Collections.singleton(this));
        opt = ((Stream)Streams.stream((Iterable)newModules).parallel()).map(module -> {
            int max = module.maxInstallable();
            if (max == -1) {
                return null;
            }
            int installed = (int)Streams.stream((Iterable)newModules).filter(e -> e.getType() == module.getType() && e.getModuleTechLevel().index <= module.getModuleTechLevel().index).count();
            if (installed > max) {
                return new InstallResult(InstallResult.InstallResultType.NO, (Module<?>)module, null, (Component)Component.translatable((String)"modular_item.draconicevolution.error.module_install_limit").withStyle(ChatFormatting.RED));
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        return opt.orElseGet(() -> new InstallResult(InstallResult.InstallResultType.YES, this, null, (List<Component>)null));
    }

    default public Material getTexture() {
        return ModuleTextures.get(this);
    }
}

