/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ModuleProperties<T extends ModuleData<T>> {
    private final TechLevel techLevel;
    private int width;
    private int height;
    private T data;
    private Function<Module<T>, T> dataGenerator;

    public ModuleProperties(TechLevel techLevel, Function<Module<T>, T> dataGenerator) {
        this(techLevel, -1, -1, dataGenerator);
    }

    public ModuleProperties(TechLevel techLevel, int width, int height, Function<Module<T>, T> dataGenerator) {
        this.techLevel = techLevel;
        this.width = width;
        this.height = height;
        this.dataGenerator = dataGenerator;
    }

    public void reloadData(Module<T> module) {
        this.data = (ModuleData)this.dataGenerator.apply(module);
    }

    public T getData() {
        return this.data;
    }

    public int getWidth() {
        if (this.width == -1) {
            throw new IllegalStateException("Module dimensions have not been set! " + this.getData());
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            throw new IllegalStateException("Module dimensions have not been set! " + this.getData());
        }
        return this.height;
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    public void loadDefaults(ModuleType<T> moduleType) {
        if (this.width == -1 && moduleType.getDefaultWidth() != -1) {
            this.width = moduleType.getDefaultWidth();
        }
        if (this.height == -1 && moduleType.getDefaultHeight() != -1) {
            this.height = moduleType.getDefaultHeight();
        }
    }

    public void addStats(List<Component> toolTip, Module<?> module, ModuleContext context) {
        toolTip.add((Component)Component.translatable((String)"module.draconicevolution.module_type").withStyle(ChatFormatting.GRAY).append(": ").append((Component)module.getType().getDisplayName().copy().withStyle(this.techLevel.getTextColour())));
        toolTip.add((Component)Component.translatable((String)"module.draconicevolution.grid_size").withStyle(ChatFormatting.GRAY).append(": ").append((Component)Component.literal((String)(this.getWidth() + "x" + this.getHeight())).withStyle(ChatFormatting.DARK_GREEN)));
        HashMap<Component, Component> map = new HashMap<Component, Component>();
        this.getData().addInformation(map, context);
        map.forEach((name, value) -> {
            if (value == null) {
                toolTip.add((Component)name.plainCopy().withStyle(ChatFormatting.GRAY));
            } else {
                toolTip.add((Component)name.plainCopy().withStyle(ChatFormatting.GRAY).append(": ").append(ChatFormatting.DARK_GREEN + value.plainCopy().getString().replace("\n", " ")));
            }
        });
    }
}

