/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.entities.FilteredModuleEntity;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.integration.ModHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EnderCollectionEntity
extends FilteredModuleEntity<NoData> {
    private CompoundTag frequencyTag = new CompoundTag();

    public EnderCollectionEntity(Module<NoData> module) {
        super(module, module.getProperties().getTechLevel() == TechLevel.DRACONIC ? 9 : 0);
        this.addEnabledProperty("ender_collection_mod", false);
    }

    @Override
    protected List<FilteredModuleEntity.Slot> layoutSlots(int x, int y, int width, int height) {
        ArrayList<FilteredModuleEntity.Slot> slots = new ArrayList<FilteredModuleEntity.Slot>();
        double slotXSize = (double)width / 3.0;
        double slotYSize = (double)height / 3.0;
        for (int i = 0; i < this.slotsCount; ++i) {
            double xPos = (double)x + (double)(i % 3) * slotXSize;
            double yPos = (double)y + (double)(i / 3) * slotYSize;
            slots.add(new FilteredModuleEntity.Slot(i, xPos, yPos, slotXSize));
        }
        return slots;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Material getSlotOverlay() {
        return BCGuiTextures.get((String)"slots/filter");
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        super.readExtraData(nbt);
        this.frequencyTag = nbt.getCompound("frequency");
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        nbt.put("frequency", (Tag)this.frequencyTag);
        return super.writeExtraData(nbt);
    }

    public List<ItemStack> insertStacks(Player player, Collection<ItemStack> stacks, IOPStorage opStorage) {
        if (opStorage == null) {
            return new ArrayList<ItemStack>(stacks);
        }
        Object container = ModHelper.ENDERSTORAGE.isPresent() ? this.getEnderStorage(player) : player.getEnderChestInventory();
        Predicate<ItemStack> filter = null;
        if (!this.filterTags.isEmpty() || !this.filterStacks.isEmpty()) {
            filter = this.createFilterTest();
        }
        ArrayList<ItemStack> notInserted = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            long cost = (long)EquipCfg.enderModulePerItemEnergy * (long)stack.getCount();
            if (opStorage.getOPStored() < cost || filter != null && !filter.test(stack)) {
                notInserted.add(stack);
                continue;
            }
            opStorage.modifyEnergyStored(-cost);
            int remainder = InventoryUtils.insertItem((Container)container, (ItemStack)stack, (boolean)false);
            if (remainder <= 0) continue;
            stack.setCount(remainder);
            notInserted.add(stack);
        }
        return notInserted;
    }

    public int insertStack(Player player, ItemStack stack, IOPStorage opStorage) {
        Object container = ModHelper.ENDERSTORAGE.isPresent() ? this.getEnderStorage(player) : player.getEnderChestInventory();
        Predicate<ItemStack> filter = null;
        if (!this.filterTags.isEmpty() || !this.filterStacks.isEmpty()) {
            filter = this.createFilterTest();
        }
        long cost = (long)EquipCfg.enderModulePerItemEnergy * (long)stack.getCount();
        if (opStorage.getOPStored() < cost || filter != null && !filter.test(stack)) {
            return stack.getCount();
        }
        opStorage.modifyEnergyStored(-cost);
        return InventoryUtils.insertItem((Container)container, (ItemStack)stack, (boolean)false);
    }

    private Container getEnderStorage(Player player) {
        if (this.frequencyTag.isEmpty()) {
            return player.getEnderChestInventory();
        }
        Frequency frequency = new Frequency(this.frequencyTag);
        return (Container)EnderStorageManager.instance((boolean)false).getStorage(frequency, EnderItemStorage.TYPE);
    }

    private EnumColour[] getColours() {
        Frequency frequency = new Frequency(this.frequencyTag);
        return new EnumColour[]{frequency.getLeft(), frequency.getMiddle(), frequency.getRight()};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        float alpha;
        super.renderModule(parent, render, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
        if (this.frequencyTag.isEmpty() || !ModHelper.ENDERSTORAGE.isPresent()) {
            return;
        }
        float dist = (float)Utils.distToRect((double)x, (double)y, (double)width, (double)height, (double)mouseX, (double)mouseY);
        float f = alpha = dist <= 10.0f ? dist / 10.0f : 1.0f;
        if (alpha == 0.0f) {
            return;
        }
        if (alpha != 1.0f) {
            render.pose().translate(0.0f, 0.0f, 201.0f);
        }
        float p = (float)width / 16.0f;
        float w = p * 2.0f;
        float h = p * 4.0f;
        float mid = (float)x + (float)width / 2.0f;
        float py = (float)y + (float)height / 2.0f - h / 2.0f;
        EnumColour[] colours = this.getColours();
        Material mat = DEGuiTextures.get("misc/es_buttons");
        float hp = 0.03125f;
        for (int i = 0; i < 3; ++i) {
            float px = mid - w / 2.0f - p * 3.0f + (float)i * (p * 3.0f);
            float u = hp * 3.0f + hp * 8.0f * (float)(colours[i].getWoolMeta() % 4);
            float v = hp * 2.0f + hp * 8.0f * (float)(colours[i].getWoolMeta() / 4);
            render.partialSprite(mat.renderType(GuiRender::texColType), (double)px, (double)py, (double)(px + w), (double)(py + h), mat.sprite(), u, v, u + hp * 2.0f, v + hp * 4.0f, 1.0f, 1.0f, 1.0f, alpha);
        }
        if (alpha != 1.0f) {
            render.pose().translate(0.0f, 0.0f, -201.0f);
        }
    }
}

