/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities.logic;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.modules.entities.logic.IHarvestHandler;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeHarvestHandler
implements IHarvestHandler {
    private final int speed;
    private Direction direction;
    private final boolean harvestLeaves;
    private LinkedList<Long> scanQue = new LinkedList();
    private IntObjectMap<LinkedList<Long>> leavesWait = new IntObjectHashMap();
    private BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
    private Set<Long> processedBlocks = new HashSet<Long>();
    private int leavesWaitIndex = 0;
    private boolean complete = false;

    public TreeHarvestHandler(int speed, @Nullable Direction direction, boolean leaves) {
        this.speed = speed;
        this.direction = direction;
        this.harvestLeaves = leaves;
    }

    @Override
    public boolean start(BlockPos origin, Level level, ServerPlayer player) {
        this.complete = false;
        BlockState state = level.getBlockState(origin);
        if (state.is(BlockTags.LOGS)) {
            this.queLogAndSearchLeaves(level, origin);
        } else {
            state = level.getBlockState(origin = origin.relative(this.direction == null ? player.getDirection() : this.direction.getOpposite()));
            if (state.is(BlockTags.LOGS)) {
                this.queLogAndSearchLeaves(level, origin);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void tick(Level level, ServerPlayer player, ItemStack stack, IOPStorage storage, InventoryDynamic stackCollector) {
        if (this.complete) {
            return;
        }
        if (!this.scanQue.isEmpty()) {
            for (int i = 0; i < this.speed && !this.scanQue.isEmpty(); ++i) {
                this.updateTreeHarvest(player.level(), (Player)player, stack, storage, stackCollector);
            }
            return;
        }
        if (this.leavesWaitIndex <= 7) {
            if (this.leavesWaitIndex < 0) {
                ++this.leavesWaitIndex;
            } else {
                LinkedList que = (LinkedList)this.leavesWait.get(this.leavesWaitIndex);
                for (int i = 0; i < this.speed && que != null && !que.isEmpty(); ++i) {
                    this.updateLeavesHarvest(player.level(), que, (Player)player, stack, storage, stackCollector);
                }
                if (que == null || que.isEmpty()) {
                    ++this.leavesWaitIndex;
                }
            }
            return;
        }
        this.harvestComplete();
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * ((player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.7f + 1.8f));
    }

    private void updateTreeHarvest(Level level, Player player, ItemStack stack, IOPStorage storage, InventoryDynamic stackCollector) {
        this.mPos.set(this.scanQue.removeFirst().longValue());
        this.doHarvest(stack, player, level, this.mPos.immutable(), storage, stackCollector);
        Utils.betweenClosed((BlockPos)this.mPos.offset(-1, -1, -1), (BlockPos)this.mPos.offset(1, 1, 1), pos -> {
            long longPos = pos.asLong();
            if (this.processedBlocks.contains(longPos)) {
                return;
            }
            this.processedBlocks.add(longPos);
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) {
                return;
            }
            if (state.is(BlockTags.LOGS)) {
                this.queLogAndSearchLeaves(level, (BlockPos)pos);
            }
        });
    }

    private void queLogAndSearchLeaves(Level level, BlockPos pos) {
        this.scanQue.add(pos.asLong());
        if (!this.harvestLeaves) {
            return;
        }
        int r = 7;
        if (this.leavesWaitIndex >= 0) {
            this.leavesWaitIndex = -4;
            BlockPos.betweenClosed((BlockPos)pos.offset(-r, -r, -r), (BlockPos)pos.offset(r, r, r)).forEach(e -> this.scanLeaves(level, (BlockPos)e));
        } else {
            Utils.hollowCube((BlockPos)pos.offset(-r, -r, -r), (BlockPos)pos.offset(r, r, r), e -> this.scanLeaves(level, (BlockPos)e));
        }
    }

    private void scanLeaves(Level level, BlockPos pos) {
        long longPos = pos.asLong();
        if (this.processedBlocks.contains(longPos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (state.is(BlockTags.LOGS)) {
            return;
        }
        this.processedBlocks.add(longPos);
        if (state.is(BlockTags.LEAVES)) {
            if (state.getBlock() instanceof LeavesBlock) {
                int distance = MathHelper.clip((int)((Integer)state.getValue((Property)LeavesBlock.DISTANCE)), (int)0, (int)7);
                if (distance == 7) {
                    ((LinkedList)this.leavesWait.computeIfAbsent((Object)7, e -> new LinkedList())).add(longPos);
                } else {
                    ((LinkedList)this.leavesWait.computeIfAbsent((Object)distance, e -> new LinkedList())).add(longPos);
                }
            } else {
                ((LinkedList)this.leavesWait.computeIfAbsent((Object)7, e -> new LinkedList())).add(longPos);
            }
        }
    }

    private void updateLeavesHarvest(Level level, LinkedList<Long> que, Player player, ItemStack stack, IOPStorage storage, InventoryDynamic stackCollector) {
        this.mPos.set(que.removeFirst().longValue());
        BlockState state = level.getBlockState((BlockPos)this.mPos);
        if (state.getBlock() instanceof LeavesBlock && (Integer)state.getValue((Property)LeavesBlock.DISTANCE) < 7) {
            return;
        }
        this.doHarvest(stack, player, level, this.mPos.immutable(), storage, stackCollector);
    }

    private void harvestComplete() {
        this.scanQue.clear();
        this.processedBlocks.clear();
        this.leavesWait.clear();
        this.complete = true;
    }

    @Override
    public boolean isDone() {
        return this.complete;
    }

    @Override
    public void stop(Level level, ServerPlayer player) {
        this.harvestComplete();
    }
}

