/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.items;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleProvider;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.LimitedModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ModuleItem<P extends ModuleData<P>>
extends Item
implements ModuleProvider<P> {
    private Module<P> moduleCache = null;
    private Supplier<Module<P>> moduleSupplier;

    public ModuleItem(Item.Properties properties, Supplier<Module<?>> moduleSupplier) {
        super(properties);
        this.moduleSupplier = (Supplier)SneakyUtils.unsafeCast(moduleSupplier);
    }

    public ModuleItem(Supplier<Module<?>> moduleSupplier) {
        super(new Item.Properties());
        this.moduleSupplier = (Supplier)SneakyUtils.unsafeCast(moduleSupplier);
    }

    public static Module<?> getModule(ItemStack stack) {
        ModuleProvider cap = (ModuleProvider)stack.getCapability(DECapabilities.Module.ITEM);
        if (!stack.isEmpty() && cap != null) {
            return cap.getModule();
        }
        return null;
    }

    @Override
    public Module<P> getModule() {
        if (this.moduleCache == null) {
            this.moduleCache = this.moduleSupplier.get();
        }
        return this.moduleCache;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        this.getModule().addInformation(tooltip, new LimitedModuleContext(stack, null, worldIn, null));
        ModuleEntity<?> entity = this.getModule().createEntity();
        entity.readFromItemStack(stack, new StackModuleContext(stack, null, null));
        entity.addToolTip(tooltip);
    }

    public Rarity getRarity(ItemStack stack) {
        return this.getModule().getProperties().getTechLevel().getRarity();
    }
}

