/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class EnergyCore
extends EntityBlockBCore {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public EnergyCore(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.dontSpawnOnMe();
        this.setBlockEntity(() -> DEContent.TILE_STORAGE_CORE.get(), true);
        this.setLightTransparent();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEnergyCore) {
            TileEnergyCore tile = (TileEnergyCore)blockEntity;
            if (!state.is(newState.getBlock()) || !newState.hasBlockEntity()) {
                tile.onRemoved();
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

