/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.inventory.DisenchanterMenu;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.commons.lang3.StringUtils;

public class TileDisenchanter
extends TileBCore
implements MenuProvider,
IInteractTile {
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, 3).setSlotValidator(0, stack -> stack.isEnchanted() && ModHelper.canRemoveEnchants(stack)).setSlotValidator(1, itemStack -> itemStack.is(Items.BOOK));

    public TileDisenchanter(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_DISENCHANTER.get(), pos, state);
        this.capManager.setManaged("inventory", Capabilities.ItemHandler.BLOCK, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth();
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileDisenchanter.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_DISENCHANTER, (BlockCapability)Capabilities.ItemHandler.BLOCK);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int pid) {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack books = this.itemHandler.getStackInSlot(1);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        if (input.isEmpty() || !input.isEnchanted() || books.isEmpty() || books.getCount() <= 0 || !output.isEmpty()) {
            return;
        }
        ListTag list = input.getEnchantmentTags();
        if (list.isEmpty()) {
            return;
        }
        String targetId = data.readString();
        if (StringUtils.isEmpty((CharSequence)targetId)) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackCompound;
            CompoundTag compound = list.getCompound(i);
            String id = compound.getString("id");
            short lvl = compound.getShort("lvl");
            Enchantment e = this.getEnchantmentFromTag(compound);
            if (e == null || !id.equals(targetId)) continue;
            int cost = this.getCostInLevels(e, lvl);
            if (!client.getAbilities().instabuild && cost > client.experienceLevel) {
                client.sendSystemMessage((Component)Component.translatable((String)"disenchanter.draconicevolution.not_enough_levels", (Object[])new Object[]{cost}).withStyle(ChatFormatting.RED));
                return;
            }
            if (!client.getAbilities().instabuild) {
                client.giveExperienceLevels(-cost);
            }
            if ((stackCompound = input.getTag()) == null) {
                return;
            }
            books.shrink(1);
            if (books.getCount() <= 0) {
                this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
            }
            int repairCost = stackCompound.getInt("RepairCost");
            repairCost = (int)((double)repairCost - (double)repairCost * (1.0 / (double)list.size()));
            stackCompound.putInt("RepairCost", repairCost);
            ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantedBookItem.addEnchantment((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(e, (int)lvl));
            this.itemHandler.setStackInSlot(2, book);
            list.remove(i);
            if (list.size() <= 0) {
                stackCompound.remove("ench");
            }
            return;
        }
    }

    public int getCostInLevels(Enchantment e, int level) {
        int max = e.getMaxLevel();
        return (int)((double)(20 - (max == 1 ? 0 : (max == 2 ? 7 : 10))) * ((double)(e.getRarity().ordinal() + 1) * 0.35) * DEOldConfig.disenchnaterCostMultiplyer) * level;
    }

    @Nullable
    public Enchantment getEnchantmentFromTag(CompoundTag c) {
        if (c != null && c.getString("id") != null) {
            return (Enchantment)BuiltInRegistries.ENCHANTMENT.get(new ResourceLocation(c.getString("id")));
        }
        return null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new DisenchanterMenu(currentWindowIndex, player.getInventory(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, this.worldPosition);
        }
        return true;
    }
}

