/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.api.DislocatorEndPoint;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.TileTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class TileDislocatorPedestal
extends TileBCore
implements DislocatorEndPoint,
IInteractTile {
    public final ManagedInt rotation = (ManagedInt)this.register((IManagedData)new ManagedInt("rotation", 0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, 1);

    public TileDislocatorPedestal(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_DISLOCATOR_PEDESTAL.get(), pos, state);
        this.capManager.setManaged("inventory", Capabilities.ItemHandler.BLOCK, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth().syncTile();
        this.itemHandler.setSlotValidator(0, stack -> stack.getItem() instanceof Dislocator);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileDislocatorPedestal.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_DISLOCATOR_PEDESTAL, (BlockCapability)Capabilities.ItemHandler.BLOCK);
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!player.isShiftKeyDown() && !stack.isEmpty()) {
            if (stack.getItem() instanceof Dislocator) {
                TargetPos location = ((Dislocator)stack.getItem()).getTargetPos(stack, this.level);
                if (location == null) {
                    if (BoundDislocator.isValid(stack)) {
                        if (BoundDislocator.isPlayer(stack)) {
                            player.sendSystemMessage((Component)Component.translatable((String)"dislocate.draconicevolution.bound.cant_find_player").withStyle(ChatFormatting.RED));
                        } else {
                            player.sendSystemMessage((Component)Component.translatable((String)"dislocate.draconicevolution.bound.cant_find_target").withStyle(ChatFormatting.RED));
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                boolean silenced = this.level.getBlockState(this.worldPosition.below()).is(BlockTags.WOOL);
                if (!silenced) {
                    BCoreNetwork.sendSound((Level)player.level(), (BlockPos)player.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false);
                }
                BoundDislocator.notifyArriving(stack, player.level(), (Entity)player);
                location.teleport((Entity)player);
                if (!silenced) {
                    DelayedTask.run((int)1, () -> BCoreNetwork.sendSound((Level)player.level(), (BlockPos)player.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false));
                }
            }
            return InteractionResult.SUCCESS;
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IItemHandlerModifiable)this.itemHandler, (Player)player);
        this.detectAndSendChanges(false);
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack) && this.itemHandler.getStackInSlot(0).isEmpty()) {
            DislocatorSaveData.updateLinkTarget(this.level, stack, new PlayerTarget(player));
        }
        this.checkIn();
        this.setChanged();
        this.updateBlock();
        return InteractionResult.SUCCESS;
    }

    public void onLoad() {
        super.onLoad();
        if (this.level instanceof ServerLevel) {
            this.checkIn();
        }
    }

    @Override
    @Nullable
    public Vec3 getArrivalPos(UUID linkID) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!BoundDislocator.isValid(stack) || !linkID.equals(BoundDislocator.getLinkId(stack))) {
            return null;
        }
        BlockPos pos = this.getBlockPos();
        return new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
    }

    public void checkIn() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack)) {
            DislocatorSaveData.updateLinkTarget(this.level, stack, new TileTarget(this));
        }
    }
}

