/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.DislocatorEndPoint;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.DislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClient;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServer;
import com.brandon3055.draconicevolution.blocks.tileentity.PortalHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.TileTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class TileDislocatorReceptacle
extends TileBCore
implements IInteractTile,
IHudBlock,
IRSSwitchable,
DislocatorEndPoint,
ICrystalLink,
IENetEffectTile {
    private static final Random rand = new Random();
    public final ManagedPos arrivalPos = (ManagedPos)this.register((IManagedData)new ManagedPos("arrival_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte ignitionStage = (ManagedByte)this.register((IManagedData)new ManagedByte("ignition_stage", 0, new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedEnum<Direction.Axis> activeAxis = (ManagedEnum)this.register((IManagedData)new ManagedEnum("active_axis", (Enum)Direction.Axis.X, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedPos linkedCrystal = (ManagedPos)this.register((IManagedData)new ManagedPos("crystal_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte remoteCrystalTier = (ManagedByte)this.register((IManagedData)new ManagedByte("crystal_pos_tier", 0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte linkedFlowRate = (ManagedByte)this.register((IManagedData)new ManagedByte("linked_flow_rate", 0, new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedPos crystalLinkPos = (ManagedPos)this.register((IManagedData)new ManagedPos("crystal_link_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, 1);
    private PortalHelper portalHelper = new PortalHelper(this);
    private List<Entity> teleportQ = new ArrayList<Entity>();
    private BlockPos remotePosCache = null;
    private ResourceKey<Level> remoteWorldCache = null;
    private int invalidLinkTime = 0;
    protected ENetFXHandler fxHandler;
    boolean hashCached = false;
    int hashID = 0;

    public TileDislocatorReceptacle(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_DISLOCATOR_RECEPTACLE.get(), pos, state);
        this.capManager.setManaged("inventory", Capabilities.ItemHandler.BLOCK, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth().syncTile();
        this.itemHandler.setContentsChangeListener(e -> this.onInventoryChange());
        this.itemHandler.setSlotValidator(0, stack -> stack.getItem() instanceof Dislocator);
        this.fxHandler = DraconicEvolution.proxy.createENetFXHandler(this);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileDislocatorReceptacle.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_DISLOCATOR_RECEPTACLE, (BlockCapability)CapabilityOP.BLOCK);
        TileDislocatorReceptacle.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_DISLOCATOR_RECEPTACLE, (BlockCapability)Capabilities.ItemHandler.BLOCK);
    }

    public void onSignalChange(boolean newSignal) {
        if (newSignal) {
            this.attemptActivation();
        } else {
            this.deactivate();
        }
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.hasRSSignal()) {
            return InteractionResult.PASS;
        }
        if (stack.getItem() == ((BlockBCore)DEContent.INFUSED_OBSIDIAN.get()).asItem()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)DislocatorReceptacle.CAMO) == false)));
            return InteractionResult.SUCCESS;
        }
        if (!this.level.isClientSide) {
            ItemStack previousInstalled = this.itemHandler.getStackInSlot(0);
            InventoryUtils.handleHeldStackTransfer((int)0, (IItemHandlerModifiable)this.itemHandler, (Player)player);
            if (BoundDislocator.isValid(previousInstalled) && BoundDislocator.isP2P(previousInstalled) && this.itemHandler.getStackInSlot(0).isEmpty()) {
                DislocatorSaveData.updateLinkTarget(this.level, previousInstalled, new PlayerTarget(player));
            }
            this.checkIn();
        }
        return InteractionResult.SUCCESS;
    }

    private void onInventoryChange() {
        ItemStack stack;
        if (this.level.isClientSide) {
            return;
        }
        if (this.portalHelper.isRunning()) {
            this.portalHelper.abort();
        }
        if ((stack = this.itemHandler.getStackInSlot(0)).isEmpty() && this.isActive()) {
            this.deactivate();
        } else if (!stack.isEmpty()) {
            this.attemptActivation();
        }
    }

    public void attemptActivation() {
        if (this.level.isClientSide || this.isActive() || this.portalHelper.isRunning()) {
            return;
        }
        TargetPos target = this.getTargetPos();
        if (target != null) {
            this.portalHelper.startScan();
            this.ignitionStage.set(1);
        }
    }

    public void deactivate() {
        this.setActive(false);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getBlockPos().offset(-1, -1, -1), (BlockPos)this.getBlockPos().offset(1, 1, 1))) {
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (!(tile instanceof TilePortal) || !((TilePortal)tile).getControllerPos().equals((Object)this.getBlockPos())) continue;
            this.level.removeBlock(pos, false);
        }
    }

    public void handleEntityTeleport(Entity entity) {
        if (this.level.isClientSide || this.teleportQ.contains(entity)) {
            return;
        }
        if (entity.isOnPortalCooldown()) {
            entity.setPortalCooldown();
            return;
        }
        this.teleportQ.add(entity);
    }

    public void tick() {
        this.updateCrystalLogic();
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.portalHelper.isRunning()) {
            int maxSpeed = this.portalHelper.isBuilding() ? 125 : 384;
            int cycles = Utils.scaleToTPS((Level)this.level, (int)(maxSpeed / 8), (int)maxSpeed);
            for (int i = 0; i < cycles && this.portalHelper.isRunning(); ++i) {
                this.portalHelper.updateTick();
            }
        } else if (!this.teleportQ.isEmpty()) {
            for (Entity entity : this.teleportQ) {
                TargetPos target = this.getTargetPos();
                if (target == null) {
                    this.deactivate();
                    this.teleportQ.clear();
                    return;
                }
                BCoreNetwork.sendSound((Level)entity.level(), (BlockPos)entity.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(rand.nextFloat() * 0.1f + 0.9f), (boolean)false);
                entity.setPortalCooldown();
                target.teleport(entity);
                if (entity instanceof ServerPlayer) {
                    DelayedTask.run((int)10, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayer)entity));
                    DelayedTask.run((int)20, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayer)entity));
                    DelayedTask.run((int)60, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayer)entity));
                }
                entity.setPortalCooldown();
                DelayedTask.run((int)1, () -> BCoreNetwork.sendSound((Level)entity.level(), (BlockPos)entity.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(rand.nextFloat() * 0.1f + 0.9f), (boolean)false));
            }
            this.teleportQ.clear();
        }
    }

    public void onScanBlock(BlockPos pos) {
    }

    public void onScanComplete(@Nullable Set<BlockPos> result, @Nullable Direction.Axis resultAxis) {
        if (result == null || resultAxis == null) {
            this.ignitionStage.set(0);
        } else {
            this.ignitionStage.set(2);
            this.portalHelper.buildPortal(result, resultAxis);
            this.activeAxis.set((Enum)resultAxis);
        }
    }

    public void onBuildSuccess(List<BlockPos> builtList) {
        this.setActive(true);
        this.ignitionStage.set(0);
        HashMap levelMap = new HashMap();
        builtList.forEach(block -> levelMap.computeIfAbsent(block.getY(), integer -> new ArrayList()).add(block));
        LinkedList levels = new LinkedList(levelMap.keySet());
        levels.sort(Comparator.naturalOrder());
        ArrayList<BlockPos> foundValid = new ArrayList<BlockPos>();
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            List blocks = (List)levelMap.get(level);
            Iterator iterator2 = blocks.iterator();
            while (iterator2.hasNext()) {
                BlockPos pos = (BlockPos)iterator2.next();
                if (!this.level.isEmptyBlock(pos.above()) && !this.level.getBlockState(pos.above()).is((Block)DEContent.PORTAL.get())) continue;
                foundValid.add(pos);
            }
            if (foundValid.isEmpty()) continue;
            break;
        }
        if (foundValid.isEmpty()) {
            this.arrivalPos.set(null);
            return;
        }
        Vector3 min = new Vector3().set(6.0E7);
        Vector3 max = new Vector3().set(-6.0E7);
        for (BlockPos pos : foundValid) {
            if ((double)pos.getX() < min.x) {
                min.x = pos.getX();
            }
            if ((double)pos.getY() < min.y) {
                min.y = pos.getY();
            }
            if ((double)pos.getZ() < min.z) {
                min.z = pos.getZ();
            }
            if ((double)pos.getX() > max.x) {
                max.x = pos.getX();
            }
            if ((double)pos.getY() > max.y) {
                max.y = pos.getY();
            }
            if (!((double)pos.getZ() > max.z)) continue;
            max.z = pos.getZ();
        }
        Vector3 mid = min.copy().add(max.subtract(min).divide(2.0));
        BlockPos closestPos = (BlockPos)foundValid.get(0);
        double closest = 2.147483647E9;
        for (BlockPos pos : foundValid) {
            double dist = Utils.getDistanceSq((double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)mid.x, (double)mid.y, (double)mid.z);
            if (!(dist < closest)) continue;
            closest = dist;
            closestPos = pos;
        }
        this.arrivalPos.set(closestPos);
        this.setLinkPos(this.getMidPos(builtList));
    }

    private BlockPos getMidPos(List<BlockPos> blocks) {
        Vector3 min = new Vector3(6.0E7, 6.0E7, 6.0E7);
        Vector3 max = new Vector3(-6.0E7, -6.0E7, -6.0E7);
        for (BlockPos pos2 : blocks) {
            if ((double)pos2.getX() + 0.5 < min.x) {
                min.x = (double)pos2.getX() + 0.5;
            }
            if ((double)pos2.getY() + 0.5 < min.y) {
                min.y = (double)pos2.getY() + 0.5;
            }
            if ((double)pos2.getZ() + 0.5 < min.z) {
                min.z = (double)pos2.getZ() + 0.5;
            }
            if ((double)pos2.getX() + 0.5 > max.x) {
                max.x = (double)pos2.getX() + 0.5;
            }
            if ((double)pos2.getY() + 0.5 > max.y) {
                max.y = (double)pos2.getY() + 0.5;
            }
            if (!((double)pos2.getZ() + 0.5 > max.z)) continue;
            max.z = (double)pos2.getZ() + 0.5;
        }
        Vector3 mid = min.copy().add(max.subtract(min).divide(2.0));
        return blocks.stream().min(Comparator.comparingDouble(pos -> MathUtils.distanceSq((Vector3)mid, (Vector3)Vector3.fromBlockPosCenter((BlockPos)pos)))).orElse(null);
    }

    public void onBuildFail() {
        this.setActive(false);
        this.ignitionStage.set(0);
    }

    public boolean isActive() {
        return (Boolean)this.getBlockState().getValue((Property)DislocatorReceptacle.ACTIVE);
    }

    public void setActive(boolean active) {
        if (this.level.getBlockState(this.getBlockPos()).is((Block)DEContent.DISLOCATOR_RECEPTACLE.get())) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    private TargetPos getTargetPos() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!(stack.getItem() instanceof Dislocator)) {
            return null;
        }
        return ((Dislocator)stack.getItem()).getTargetPos(stack, this.level);
    }

    public void generateHudText(Level world, BlockPos pos, Player player, List<Component> displayList) {
        displayList.add((Component)Component.literal((String)(this.ignitionStage.get() == 1 ? "Scanning..." : "Activating...")));
    }

    public boolean shouldDisplayHudText(Level world, BlockPos pos, Player player) {
        return this.ignitionStage.get() > 0;
    }

    public void checkIn() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack)) {
            DislocatorSaveData.updateLinkTarget(this.level, stack, new TileTarget(this));
        }
    }

    private boolean isBound() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level instanceof ServerLevel) {
            this.checkIn();
        }
    }

    @Override
    @Nullable
    public Vec3 getArrivalPos(UUID linkID) {
        BlockPos ap = this.arrivalPos.get();
        return this.isActive() && ap != null ? new Vec3((double)ap.getX() + 0.5, (double)ap.getY() + 0.25, (double)ap.getZ()) : null;
    }

    @Override
    public void entityArriving(Entity entity) {
        entity.setPortalCooldown();
        if (entity instanceof ServerPlayer) {
            DelayedTask.run((int)10, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayer)entity));
            DelayedTask.run((int)20, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayer)entity));
            DelayedTask.run((int)60, () -> DraconicNetwork.sendDislocatorTeleported((ServerPlayer)entity));
        }
    }

    private void updateCrystalLogic() {
        boolean boundCrystals;
        this.fxHandler.update();
        boolean bl = boundCrystals = this.isActive() && this.isBound() && this.linkedCrystal.get() != null;
        if (this.level.isClientSide && boundCrystals && this.remoteCrystalTier.isDirty(false)) {
            this.fxHandler.reloadConnections();
        }
        if (!this.level.isClientSide && boundCrystals) {
            if (DEEventHandler.serverTicks % 10 == 0) {
                TileDislocatorReceptacle remoteTile = this.getRemoteReceptacle();
                ICrystalLink remote = this.getRemoteCrystal();
                if (remoteTile != null && remote instanceof IENetEffectTile) {
                    int i = remote.getLinks().indexOf(remoteTile.getBlockPos());
                    LinkedList<Byte> rates = ((IENetEffectTile)remote).getFlowRates();
                    if (i >= 0 && i < rates.size()) {
                        this.linkedFlowRate.set((int)((Byte)rates.get(i)).byteValue());
                    } else {
                        this.linkedFlowRate.set(0);
                    }
                } else {
                    this.linkedFlowRate.set(0);
                }
            }
            if (this.linkedFlowRate.get() != 0 && DEEventHandler.serverTicks % 100 == 0) {
                this.dataManager.forceSync((IManagedData)this.linkedFlowRate);
            }
        } else if (!this.level.isClientSide) {
            this.linkedFlowRate.set(0);
        }
    }

    public void setLinkPos(BlockPos spawnPos) {
        this.crystalLinkPos.set(this.getBlockPos().subtract((Vec3i)spawnPos));
    }

    protected BlockPos getLinkPos() {
        if (this.crystalLinkPos.get() != null) {
            return this.getBlockPos().subtract((Vec3i)Objects.requireNonNull(this.crystalLinkPos.get()));
        }
        return BlockPos.ZERO;
    }

    protected void setCrystalPos(BlockPos crystalPos) {
        this.linkedCrystal.set(this.getBlockPos().subtract((Vec3i)crystalPos));
    }

    protected BlockPos getCrystalPos() {
        if (this.linkedCrystal.get() != null) {
            return this.getBlockPos().subtract((Vec3i)Objects.requireNonNull(this.linkedCrystal.get()));
        }
        return BlockPos.ZERO;
    }

    private TileDislocatorReceptacle getRemoteReceptacle() {
        return this.getRemoteReceptacle(false);
    }

    private TileDislocatorReceptacle getRemoteReceptacle(boolean skipRemoteCheck) {
        MinecraftServer server;
        if (!this.isActive() || !this.isBound()) {
            return null;
        }
        if (this.invalidLinkTime > 0) {
            --this.invalidLinkTime;
            return null;
        }
        if (this.remotePosCache == null) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            DislocatorTarget target = DislocatorSaveData.getLinkTarget(this.level, stack);
            if (target instanceof TileTarget) {
                TileTarget tileTarget = (TileTarget)target;
                this.remotePosCache = tileTarget.getTilePos();
                this.remoteWorldCache = tileTarget.getWorldKey();
            } else {
                this.invalidLinkTime = 100;
                return null;
            }
        }
        if ((server = this.level.getServer()) != null) {
            BlockEntity tile;
            ServerLevel remoteWorld = server.getLevel(this.remoteWorldCache);
            if (remoteWorld != null && (tile = remoteWorld.getBlockEntity(this.remotePosCache)) instanceof TileDislocatorReceptacle) {
                if (skipRemoteCheck) {
                    return (TileDislocatorReceptacle)tile;
                }
                if (((TileDislocatorReceptacle)tile).isActive() && ((TileDislocatorReceptacle)tile).getRemoteReceptacle(true) == this) {
                    return (TileDislocatorReceptacle)tile;
                }
            }
            this.remotePosCache = null;
            return null;
        }
        return null;
    }

    private ICrystalLink getRemoteCrystal() {
        MinecraftServer server;
        TileDislocatorReceptacle tile = this.getRemoteReceptacle();
        if (tile != null && (server = this.level.getServer()) != null && tile.linkedCrystal.get() != null) {
            BlockEntity crystal;
            ServerLevel remoteWorld = server.getLevel(this.remoteWorldCache);
            if (remoteWorld != null && (crystal = remoteWorld.getBlockEntity(tile.getCrystalPos())) instanceof IENetEffectTile) {
                this.remoteCrystalTier.set(((IENetEffectTile)crystal).getTier());
                return (ICrystalLink)crystal;
            }
            return null;
        }
        return null;
    }

    @Override
    @Nonnull
    public List<BlockPos> getLinks() {
        if (this.linkedCrystal.get() != null) {
            return Collections.singletonList(this.getCrystalPos());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean binderUsed(Player player, BlockPos linkTarget, Direction sideClicked) {
        return false;
    }

    @Override
    public boolean createLink(ICrystalLink otherCrystal) {
        this.setCrystalPos(((BlockEntity)otherCrystal).getBlockPos());
        return true;
    }

    @Override
    public void breakLink(BlockPos otherCrystal) {
        this.linkedCrystal.set(null);
    }

    @Override
    public int balanceMode() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.balanceMode() : 1;
    }

    @Override
    public int maxLinks() {
        return 1;
    }

    @Override
    public int maxLinkRange() {
        return 32;
    }

    @Override
    public long getEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getEnergyStored() : 0L;
    }

    @Override
    public long getMaxEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getMaxEnergyStored() : 0L;
    }

    @Override
    public void modifyEnergyStored(long energy) {
        ICrystalLink remote = this.getRemoteCrystal();
        if (remote != null) {
            remote.modifyEnergyStored(energy);
        }
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        double dist = FacingUtils.distanceInDirection((BlockPos)this.getBlockPos(), (BlockPos)linkTo, (Direction)FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[0]);
        Vec3D vec = Vec3D.getCenter((BlockPos)this.getLinkPos());
        Direction facing = dist > 0.0 ? FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[0] : FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[1];
        vec.add((double)facing.getStepX() * 0.35, (double)facing.getStepY() * 0.35, (double)facing.getStepZ() * 0.35);
        return vec;
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServer<TileDislocatorReceptacle>(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClient<TileDislocatorReceptacle>(this);
    }

    @Override
    public boolean hasStaticFX() {
        return false;
    }

    @Override
    public CrystalFXBase<?> createStaticFX() {
        return null;
    }

    @Override
    public LinkedList<Byte> getFlowRates() {
        return new LinkedList<Byte>(Collections.singletonList((byte)this.linkedFlowRate.get()));
    }

    @Override
    public int getTier() {
        return this.remoteCrystalTier.get();
    }

    @Override
    public int getIDHash() {
        if (!this.hashCached) {
            this.hashID = this.getBlockPos().hashCode();
            this.hashCached = true;
        }
        return this.hashID;
    }
}

