/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.datamanager.ManagedStack;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.tileentity.StabilizedSpawnerLogic;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.ItemCore;
import com.brandon3055.draconicevolution.items.MobSoul;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class TileStabilizedSpawner
extends TileBCore
implements IInteractTile,
IChangeListener {
    public ManagedEnum<SpawnerTier> spawnerTier = (ManagedEnum)this.register((IManagedData)new ManagedEnum("spawner_tier", (Enum)SpawnerTier.BASIC, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public ManagedStack mobSoul = (ManagedStack)this.register((IManagedData)new ManagedStack("mob_soul", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public ManagedBool isPowered = (ManagedBool)this.register((IManagedData)new ManagedBool("is_powered", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public ManagedShort spawnDelay = (ManagedShort)this.register((IManagedData)new ManagedShort("spawn_delay", 100, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public ManagedInt startSpawnDelay = (ManagedInt)this.register((IManagedData)new ManagedInt("start_spawn_delay", 100, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public StabilizedSpawnerLogic spawnerLogic = new StabilizedSpawnerLogic(this);
    private int activatingRangeFromPlayer = 24;

    public TileStabilizedSpawner(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_STABILIZED_SPAWNER.get(), pos, state);
    }

    public void tick() {
        super.tick();
        if (this.level instanceof ServerLevel) {
            this.spawnerLogic.serverTick((ServerLevel)this.level, this.worldPosition);
        } else {
            this.spawnerLogic.clientTick(this.level, this.worldPosition);
        }
    }

    public boolean isActive() {
        if (this.isPowered.get() || this.mobSoul.get().isEmpty()) {
            return false;
        }
        return !((SpawnerTier)this.spawnerTier.get()).requiresPlayer || this.level.hasNearbyAlivePlayer((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    public void onNeighborChange(BlockPos changePos) {
        this.isPowered.set(this.level.hasNeighborSignal(this.worldPosition));
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is((Item)DEContent.MOB_SOUL.get())) {
            if (!this.level.isClientSide) {
                this.mobSoul.set(stack.copy()).setCount(1);
                if (!player.isCreative()) {
                    InventoryUtils.consumeHeldItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
                }
            }
            return true;
        }
        if (stack.getItem() instanceof SpawnEggItem) {
            EntityType type = ((SpawnEggItem)stack.getItem()).getType(stack.getTag());
            ItemStack soul = new ItemStack((ItemLike)DEContent.MOB_SOUL.get());
            ((MobSoul)((Object)DEContent.MOB_SOUL.get())).setEntity(BuiltInRegistries.ENTITY_TYPE.getKey((Object)type), soul);
            this.mobSoul.set(soul);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return true;
        }
        if (!stack.isEmpty()) {
            ItemStack dropStack;
            SpawnerTier prevTier = (SpawnerTier)this.spawnerTier.get();
            if (stack.is((Item)DEContent.CORE_DRACONIUM.get())) {
                if (this.spawnerTier.get() == SpawnerTier.BASIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.BASIC);
            } else if (stack.is((Item)DEContent.CORE_WYVERN.get())) {
                if (this.spawnerTier.get() == SpawnerTier.WYVERN) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.WYVERN);
            } else if (stack.is((Item)DEContent.CORE_AWAKENED.get())) {
                if (this.spawnerTier.get() == SpawnerTier.DRACONIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.DRACONIC);
            } else if (stack.is((Item)DEContent.CORE_CHAOTIC.get())) {
                if (this.spawnerTier.get() == SpawnerTier.CHAOTIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.CHAOTIC);
            } else {
                return false;
            }
            switch (prevTier) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BASIC: {
                    ItemStack itemStack = new ItemStack((ItemLike)DEContent.CORE_DRACONIUM.get());
                    break;
                }
                case WYVERN: {
                    ItemStack itemStack = new ItemStack((ItemLike)DEContent.CORE_WYVERN.get());
                    break;
                }
                case DRACONIC: {
                    ItemStack itemStack = new ItemStack((ItemLike)DEContent.CORE_AWAKENED.get());
                    break;
                }
                case CHAOTIC: {
                    ItemStack itemStack = dropStack = new ItemStack((ItemLike)DEContent.CORE_CHAOTIC.get());
                }
            }
            if (!this.level.isClientSide && !player.getAbilities().instabuild) {
                ItemEntity entityItem = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5, dropStack);
                entityItem.setDeltaMovement(entityItem.getDeltaMovement().x, 0.2, entityItem.getDeltaMovement().z);
                this.level.addFreshEntity((Entity)entityItem);
                InventoryUtils.consumeHeldItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
            }
        }
        return false;
    }

    public void writeToItemStack(CompoundTag compound, boolean willHarvest) {
        if (willHarvest) {
            this.mobSoul.set(ItemStack.EMPTY);
        }
        super.writeToItemStack(compound, willHarvest);
    }

    protected Entity getRenderEntity() {
        if (this.mobSoul.get().isEmpty()) {
            return null;
        }
        return ((MobSoul)((Object)DEContent.MOB_SOUL.get())).getRenderEntity(this.mobSoul.get());
    }

    public static enum SpawnerTier {
        BASIC(4, true, false, TechLevel.DRACONIUM),
        WYVERN(6, false, false, TechLevel.WYVERN),
        DRACONIC(8, false, true, TechLevel.DRACONIC),
        CHAOTIC(12, false, true, TechLevel.CHAOTIC);

        private final int spawnCount;
        private final boolean requiresPlayer;
        private final boolean ignoreSpawnReq;
        private final TechLevel techLevel;

        private SpawnerTier(int spawnCount, boolean requiresPlayer, boolean ignoreSpawnReq, TechLevel techLevel) {
            this.spawnCount = spawnCount;
            this.requiresPlayer = requiresPlayer;
            this.ignoreSpawnReq = ignoreSpawnReq;
            this.techLevel = techLevel;
        }

        public int getRandomSpawnDelay(Random random) {
            int min = this.getMinDelay();
            int max = this.getMaxDelay();
            return min + random.nextInt(max - min);
        }

        public int getMinDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2];
        }

        public int getMaxDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2 + 1];
        }

        public int getSpawnCount() {
            return this.spawnCount;
        }

        public boolean ignoreSpawnReq() {
            return this.ignoreSpawnReq;
        }

        public boolean requiresPlayer() {
            return this.requiresPlayer;
        }

        public int getMaxCluster() {
            return (int)((double)this.spawnCount * 3.0);
        }

        public static SpawnerTier getTierFromCore(ItemCore core) {
            return core == DEContent.CORE_CHAOTIC.get() ? CHAOTIC : (core == DEContent.CORE_WYVERN.get() ? WYVERN : (core == DEContent.CORE_AWAKENED.get() ? DRACONIC : BASIC));
        }

        public TechLevel getTechLevel() {
            return this.techLevel;
        }
    }
}

