/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFlowGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.FlowGateMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class TileFluidGate
extends TileFlowGate {
    private FlowHandler inputHandler = new FlowHandler(this, true);
    private FlowHandler outputHandler = new FlowHandler(this, false);

    public TileFluidGate(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_FLUID_GATE.get(), pos, state);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)DEContent.TILE_FLUID_GATE.get(), (tile, side) -> {
            if (side != null && side.getAxis() == tile.getDirection().getAxis()) {
                return side == tile.getDirection() ? tile.outputHandler : tile.inputHandler;
            }
            return null;
        });
    }

    @Override
    public String getUnits() {
        return "MB/t";
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new FlowGateMenu(id, player.getInventory(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, this.worldPosition);
        }
        return true;
    }

    private class FlowHandler
    implements IFluidHandler {
        private final TileFluidGate gate;
        private final boolean isInput;

        public FlowHandler(TileFluidGate gate, boolean isInput) {
            this.gate = gate;
            this.isInput = isInput;
        }

        public int getTanks() {
            IFluidHandler fluidHandler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), tile, (Object)TileFluidGate.this.getDirection().getOpposite())) != null) {
                return fluidHandler.getTanks();
            }
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            IFluidHandler fluidHandler;
            BlockEntity tile;
            if (!this.isInput && (tile = TileFluidGate.this.getSource()) != null && (fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), tile, (Object)TileFluidGate.this.getDirection().getOpposite())) != null) {
                return fluidHandler.getFluidInTank(tank);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            IFluidHandler fluidHandler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), tile, (Object)TileFluidGate.this.getDirection().getOpposite())) != null) {
                return fluidHandler.getTankCapacity(tank);
            }
            return 0;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            IFluidHandler fluidHandler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), tile, (Object)TileFluidGate.this.getDirection().getOpposite())) != null) {
                return fluidHandler.isFluidValid(tank, stack);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            IFluidHandler handler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (handler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), tile, (Object)TileFluidGate.this.getDirection().getOpposite())) != null) {
                int transfer = (int)Math.min(TileFluidGate.this.getFlow(), (long)handler.fill(resource, IFluidHandler.FluidAction.SIMULATE));
                if (transfer < resource.getAmount()) {
                    FluidStack newStack = resource.copy();
                    newStack.setAmount(transfer);
                    return handler.fill(newStack, action);
                }
                return handler.fill(resource, action);
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isInput) {
                IFluidHandler fluidHandler;
                BlockEntity tile;
                if ((long)resource.getAmount() > TileFluidGate.this.getFlow()) {
                    resource.setAmount((int)TileFluidGate.this.getFlow());
                }
                if ((tile = TileFluidGate.this.getSource()) != null && (fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), tile, (Object)TileFluidGate.this.getDirection().getOpposite())) != null) {
                    return fluidHandler.drain(resource, action);
                }
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            BlockEntity tile;
            if (!this.isInput && (tile = TileFluidGate.this.getSource()) != null) {
                IFluidHandler fluidHandler;
                if ((long)maxDrain > TileFluidGate.this.getFlow()) {
                    maxDrain = (int)TileFluidGate.this.getFlow();
                }
                if ((fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), tile, (Object)TileFluidGate.this.getDirection().getOpposite())) != null) {
                    return fluidHandler.drain(maxDrain, action);
                }
            }
            return FluidStack.EMPTY;
        }
    }
}

