/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Quaternionf;

public class CustomBossInfoHandler {
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    private static final Map<UUID, BossShieldInfo> events = Maps.newLinkedHashMap();
    private static final ResourceLocation ENDER_CRYSTAL_TEXTURES = new ResourceLocation("draconicevolution", "textures/entity/guardian_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)ENDER_CRYSTAL_TEXTURES);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final ModelPart glass;
    private static final ModelPart cube;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(CustomBossInfoHandler::onClientDisconnect);
        NeoForge.EVENT_BUS.addListener(CustomBossInfoHandler::preDrawBossInfo);
    }

    public static void preDrawBossInfo(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent info = event.getBossEvent();
        if (!events.containsKey(info.getId())) {
            return;
        }
        event.setCanceled(true);
        BossShieldInfo shieldInfo = events.get(info.getId());
        Minecraft mc = Minecraft.getInstance();
        GuiRender render = GuiRender.convert((GuiGraphics)event.getGuiGraphics());
        PoseStack poseStack = render.pose();
        int width = event.getWindow().getGuiScaledWidth();
        int x = event.getX();
        int y = event.getY();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
        CustomBossInfoHandler.drawBar(event.getGuiGraphics(), x, y, (BossEvent)info);
        float shield = shieldInfo.isImmune() ? 1.0f : shieldInfo.getShield();
        MultiBufferSource.BufferSource getter = Minecraft.getInstance().renderBuffers().bufferSource();
        if (DEConfig.guardianShaders) {
            if (shieldInfo.isImmune()) {
                DEShaders.shieldColour.glUniform4f(0.0f, 1.0f, 1.0f, 2.0f);
            } else {
                DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 2.0f);
            }
            DEShaders.shieldBarMode.glUniform1i(1);
            DEShaders.shieldActivation.glUniform1f(shield);
            TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(DraconicGuardianRenderer.SHIELD_TYPE), poseStack);
            CustomBossInfoHandler.drawShieldRect((VertexConsumer)builder, x, y, 182, 6);
            getter.endBatch();
        }
        if (shieldInfo.crystals > 0) {
            MutableComponent countText = Component.literal((String)("x" + shieldInfo.crystals));
            int countWidth = mc.font.width((FormattedText)countText);
            float anim = ((float)TimeKeeper.getClientTick() + event.getPartialTick()) * 3.0f;
            VertexConsumer ivertexbuilder = getter.getBuffer(RENDER_TYPE);
            poseStack.pushPose();
            poseStack.translate((double)(x + 182 - countWidth - 8), (double)(y - 6), 0.0);
            poseStack.scale(14.0f, 14.0f, 14.0f);
            int i = OverlayTexture.NO_OVERLAY;
            poseStack.mulPose(Axis.YP.rotationDegrees(anim));
            poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            glass.render(poseStack, ivertexbuilder, 240, i);
            poseStack.scale(0.875f, 0.875f, 0.875f);
            poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            poseStack.mulPose(Axis.YP.rotationDegrees(anim));
            glass.render(poseStack, ivertexbuilder, 240, i);
            poseStack.scale(0.875f, 0.875f, 0.875f);
            poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            poseStack.mulPose(Axis.YP.rotationDegrees(anim));
            cube.render(poseStack, ivertexbuilder, 240, i);
            poseStack.popPose();
            getter.endBatch();
            if (DEConfig.guardianShaders) {
                DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 1.5f);
                DEShaders.shieldActivation.glUniform1f(1.0f);
                VertexConsumer shaderBuilder = getter.getBuffer(DraconicGuardianRenderer.SHIELD_TYPE);
                poseStack.pushPose();
                poseStack.translate((double)(x + 182 - countWidth - 8), (double)(y - 6), 0.0);
                poseStack.scale(14.0f, 14.0f, 14.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(anim));
                poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
                glass.render(poseStack, shaderBuilder, 240, i);
                poseStack.scale(0.875f, 0.875f, 0.875f);
                poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
                poseStack.mulPose(Axis.YP.rotationDegrees(anim));
                glass.render(poseStack, shaderBuilder, 240, i);
                poseStack.scale(0.875f, 0.875f, 0.875f);
                poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
                poseStack.mulPose(Axis.YP.rotationDegrees(anim));
                cube.render(poseStack, shaderBuilder, 240, i);
                poseStack.popPose();
                getter.endBatch();
            }
            render.drawString((Component)Component.literal((String)("x" + shieldInfo.crystals)), (double)(x + 182 - countWidth), (double)((float)y - 9.0f), 0xFFFFFF);
        }
        Component itextcomponent = info.getName();
        int stringWidth = mc.font.width((FormattedText)itextcomponent);
        int stringX = shieldInfo.crystals > 0 ? x : width / 2 - stringWidth / 2;
        int stringY = y - 9;
        poseStack.translate(0.0f, 0.0f, 16.0f);
        render.drawString(itextcomponent, (double)stringX, (double)stringY, 0xFF0000);
    }

    private static void drawBar(GuiGraphics graphics, int x, int y, BossEvent info) {
        int i;
        CustomBossInfoHandler.drawRect(graphics, x, y, 0, info.getColor().ordinal() * 5 * 2, 182, 5);
        if (info.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
            CustomBossInfoHandler.drawRect(graphics, x, y, 0, 80 + (info.getOverlay().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i = (int)(info.getProgress() * 183.0f)) > 0) {
            CustomBossInfoHandler.drawRect(graphics, x, y, 0, info.getColor().ordinal() * 5 * 2 + 5, i, 5);
            if (info.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
                CustomBossInfoHandler.drawRect(graphics, x, y, 0, 80 + (info.getOverlay().ordinal() - 1) * 5 * 2 + 5, i, 5);
            }
        }
    }

    private static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        events.clear();
    }

    public static void handlePacket(MCDataInput input) {
        UUID id = input.readUUID();
        byte op = input.readByte();
        switch (op) {
            case 0: {
                events.put(id, new BossShieldInfo(input.readFloat(), input.readByte(), input.readBoolean()));
                break;
            }
            case 1: {
                events.remove(id);
                break;
            }
            case 2: {
                events.get(id).setShield(input.readFloat());
                break;
            }
            case 3: {
                events.get(id).setCrystals(input.readByte());
                break;
            }
            case 4: {
                events.get(id).setImmune(input.readBoolean());
            }
        }
    }

    public static void drawRect(GuiGraphics render, int x, int y, int u, int v, int width, int height) {
        render.blit(GUI_BARS_LOCATION, x, y, 0, (float)u, (float)v, width, height, 256, 256);
    }

    public static void drawShieldRect(VertexConsumer builder, int x, int y, int width, int height) {
        CustomBossInfoHandler.drawQuad(builder, x, x + width, y, y + height, 0, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private static void drawQuad(VertexConsumer builder, int x, int xMax, int y, int yMax, int z, float u, float uMax, float v, float vMax) {
        builder.vertex((double)x, (double)yMax, (double)z).uv(u, vMax).endVertex();
        builder.vertex((double)xMax, (double)yMax, (double)z).uv(uMax, vMax).endVertex();
        builder.vertex((double)xMax, (double)y, (double)z).uv(uMax, v).endVertex();
        builder.vertex((double)x, (double)y, (double)z).uv(u, v).endVertex();
    }

    static {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("glass", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        ModelPart modelRoot = LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32).bakeRoot();
        glass = modelRoot.getChild("glass");
        cube = modelRoot.getChild("cube");
    }

    public static class BossShieldInfo {
        protected float lastPower;
        protected float targetPower;
        protected long setTime;
        protected int crystals;
        protected boolean immune;

        public BossShieldInfo(float power, int crystals, boolean immune) {
            this.lastPower = power;
            this.targetPower = power;
            this.crystals = crystals;
            this.immune = immune;
            this.setTime = Util.getMillis();
        }

        public BossShieldInfo setShield(float power) {
            this.lastPower = this.getShield();
            this.targetPower = power;
            this.setTime = Util.getMillis();
            return this;
        }

        public float getShield() {
            long i = Util.getMillis() - this.setTime;
            float f = Mth.clamp((float)((float)i / 100.0f), (float)0.0f, (float)1.0f);
            return Mth.lerp((float)f, (float)this.lastPower, (float)this.targetPower);
        }

        public void setCrystals(int crystals) {
            this.crystals = crystals;
        }

        public int getCrystals() {
            return this.crystals;
        }

        public void setImmune(boolean immune) {
            this.immune = immune;
        }

        public boolean isImmune() {
            return this.immune;
        }
    }
}

