/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiItemStack;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.brandonscore.lib.datamanager.ManagedTextComponent;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.inventory.FusionCraftingCoreMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class FusionCraftingCoreGui
extends ContainerGuiProvider<FusionCraftingCoreMenu> {
    private static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.fusion_craft");
    public static final int GUI_WIDTH = 218;
    public static final int GUI_HEIGHT = 220;
    private RecipeHolder<IFusionRecipe> currentRecipe = null;
    public GuiItemStack stackIcon;
    public Supplier<Boolean> hideRecipes;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), DEGuiTextures.themedGetter("fusion_craft"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<FusionCraftingCoreMenu> screenAccess) {
        gui.initStandardGui(218, 220);
        FusionCraftingCoreMenu menu = (FusionCraftingCoreMenu)screenAccess.getMenu();
        TileFusionCraftingCore tile = (TileFusionCraftingCore)menu.tile;
        GuiElement root = gui.getRoot();
        GuiText heading = TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true);
        this.hideRecipes = () -> tile.getActiveRecipe() != null;
        ButtonRow buttonRow = ButtonRow.topRightInside((GuiElement)root, (Direction)Direction.DOWN, (int)3, (int)3).setSpacing(1.0);
        buttonRow.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        GuiSlots.PlayerAll playInv = GuiSlots.playerAllSlots((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar, (SlotGroup)menu.armor, (SlotGroup)menu.offhand);
        playInv.stream().forEach(e -> e.setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        TOOLKIT.playerInvTitle(playInv.container());
        GuiElement craftArea = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement((GuiParent)root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)17.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-17.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)heading.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)playInv.container().get(GeoParam.TOP), (double)-3.0));
        GuiSlots catalyst = GuiSlots.singleSlot((GuiParent)craftArea, screenAccess, (SlotGroup)menu.catalyst);
        Constraints.center((ConstrainedGeometry)catalyst, (ConstrainedGeometry)craftArea, (double)0.0, (double)-22.0);
        GuiSlots output = GuiSlots.singleSlot((GuiParent)craftArea, screenAccess, (SlotGroup)menu.output);
        Constraints.center((ConstrainedGeometry)output, (ConstrainedGeometry)craftArea, (double)0.0, (double)22.0);
        GuiText statusLabel = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)catalyst, () -> ((ManagedTextComponent)tile.userStatus).get()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)heading.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)catalyst.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)catalyst.get(GeoParam.LEFT), (double)-32.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)catalyst.get(GeoParam.RIGHT), (double)32.0))).setWrap(true).setEnabled(() -> tile.userStatus.get() != null);
        GuiButton craft = ((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> Component.translatable((String)"gui.draconicevolution.fusion_craft.craft")).setEnabled(() -> tile.getActiveRecipe() != null && !tile.isCrafting())).onPress(() -> tile.sendPacketToServer(e -> {}, 0));
        Constraints.size((ConstrainedGeometry)craft, (double)80.0, (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)craft, (ConstrainedGeometry)playInv.container(), (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-12.0);
        this.stackIcon = new GuiItemStack((GuiParent)craftArea, ItemStack.EMPTY);
        Constraints.size((ConstrainedGeometry)this.stackIcon, (double)20.0, (double)20.0);
        Constraints.center((ConstrainedGeometry)this.stackIcon, (ConstrainedGeometry)craftArea);
        Constraints.bind((ConstrainedGeometry)new IngredRenderer((GuiParent<?>)craftArea, tile), (ConstrainedGeometry)craftArea);
        gui.onTick(() -> {
            this.currentRecipe = tile.getLevel().getRecipeManager().getRecipeFor((RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get(), (Container)tile, tile.getLevel()).orElse(null);
            if (this.currentRecipe == null) {
                this.stackIcon.setStack(ItemStack.EMPTY);
            } else {
                this.stackIcon.setStack(((IFusionRecipe)this.currentRecipe.value()).getResultItem(tile.getLevel().registryAccess()));
            }
        });
    }

    private static class IngredRenderer
    extends GuiElement<IngredRenderer> {
        private TileFusionCraftingCore core;
        private List<ItemStack> lastStacks = new ArrayList<ItemStack>();

        public IngredRenderer(@NotNull GuiParent<?> parent, TileFusionCraftingCore core) {
            super(parent);
            this.core = core;
        }

        private void setInjectors() {
            int i;
            double centerX = this.xMin() + this.xSize() / 2.0;
            ArrayList columns = new ArrayList();
            int colCount = Math.min((int)Math.ceil((double)this.lastStacks.size() / 12.0), 3) * 2;
            for (i = 0; i < colCount; ++i) {
                columns.add(new ArrayList());
            }
            for (i = 0; i < this.lastStacks.size(); ++i) {
                ((ArrayList)columns.get(i % colCount)).add(this.lastStacks.get(i));
            }
            int innerOffset = colCount == 6 ? 44 : (colCount == 4 ? 53 : 65);
            for (int column = 0; column < columns.size(); ++column) {
                List stacks = (List)columns.get(column);
                int offset = column / 2 * 20;
                double xPos = column % 2 == 0 ? centerX + (double)innerOffset + (double)offset : centerX - (double)innerOffset - (double)offset - 18.0;
                double yHeight = Math.min((double)(stacks.size() * 20), this.ySize());
                for (int i2 = 0; i2 < stacks.size(); ++i2) {
                    double yPos = this.yMin() + this.ySize() / 2.0 - yHeight / 2.0 + (double)i2 * (yHeight / (double)stacks.size());
                    ((GuiItemStack)((GuiItemStack)((GuiItemStack)new GuiItemStack((GuiParent)this, (ItemStack)stacks.get(i2)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)16.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.literal((double)xPos))).constrain(GeoParam.TOP, (Constraint)Constraint.literal((double)yPos));
                }
            }
        }

        public void tick(double mouseX, double mouseY) {
            List stacks = this.core.getInjectors().stream().map(IFusionInjector::getInjectorStack).filter(injectorStack -> !injectorStack.isEmpty()).collect(Collectors.toList());
            if (!stacks.equals(this.lastStacks)) {
                this.getChildren().forEach(arg_0 -> ((IngredRenderer)this).removeChild(arg_0));
                this.lastStacks = stacks;
                if (!this.lastStacks.isEmpty()) {
                    this.setInjectors();
                }
            }
            super.tick(mouseX, mouseY);
        }
    }

    public static class Screen
    extends ModularGuiContainer<FusionCraftingCoreMenu> {
        public Screen(FusionCraftingCoreMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new FusionCraftingCoreGui());
            this.getModularGui().setGuiTitle(title);
        }
    }
}

