/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class CrystalFXIO
extends CrystalFXBase<TileCrystalBase> {
    private static final ParticleRenderType BASIC_HANDLER = new FXHandler(new ResourceLocation("draconicevolution", "textures/particle/energy_beam_basic.png"));
    private static final ParticleRenderType WYVERN_HANDLER = new FXHandler(new ResourceLocation("draconicevolution", "textures/particle/energy_beam_wyvern.png"));
    private static final ParticleRenderType DRACONIC_HANDLER = new FXHandler(new ResourceLocation("draconicevolution", "textures/particle/energy_beam_draconic.png"));

    public CrystalFXIO(ClientLevel worldIn, TileCrystalBase tile) {
        super(worldIn, tile);
        this.age = worldIn.random.nextInt(1024);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksTillDeath-- <= 0) {
            this.remove();
        }
        float[] r = new float[]{0.0f, 0.8f, 1.0f};
        float[] g = new float[]{0.8f, 0.1f, 0.7f};
        float[] b = new float[]{1.0f, 1.0f, 0.2f};
        this.rCol = r[((TileCrystalBase)this.tile).getTier()];
        this.gCol = g[((TileCrystalBase)this.tile).getTier()];
        this.bCol = b[((TileCrystalBase)this.tile).getTier()];
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (!this.renderEnabled) {
            return;
        }
        Vec3 viewVec = renderInfo.getPosition();
        float viewX = (float)(this.x - viewVec.x());
        float viewY = (float)(this.y - viewVec.y());
        float viewZ = (float)(this.z - viewVec.z());
        Vector3f[] renderVector = this.getRenderVectors(renderInfo, viewX, viewY, viewZ, 0.2f);
        buffer.vertex((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).color(1.0f, 1.0f, 1.0f, 1.0f).uv(0.5f, 0.5f).uv2(240, 240).endVertex();
        buffer.vertex((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).color(1.0f, 1.0f, 1.0f, 1.0f).uv(0.5f, 0.0f).uv2(240, 240).endVertex();
        buffer.vertex((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).color(1.0f, 1.0f, 1.0f, 1.0f).uv(0.0f, 0.0f).uv2(240, 240).endVertex();
        buffer.vertex((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).color(1.0f, 1.0f, 1.0f, 1.0f).uv(0.0f, 0.5f).uv2(240, 240).endVertex();
    }

    public ParticleRenderType getRenderType() {
        return ((TileCrystalBase)this.tile).getTier() == 0 ? BASIC_HANDLER : (((TileCrystalBase)this.tile).getTier() == 1 ? WYVERN_HANDLER : DRACONIC_HANDLER);
    }

    public static class FXHandler
    implements ParticleRenderType {
        private ResourceLocation texture;

        public FXHandler(ResourceLocation texture) {
            this.texture = texture;
        }

        public void begin(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        }

        public void end(Tesselator tessellator) {
            tessellator.end();
        }
    }
}

