/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class CrystalFXLink
extends CrystalFXBase<TileCrystalBase> {
    private final Vec3D linkTarget;
    private final boolean terminateSource;
    private final boolean terminateTarget;
    public int timeout = 0;
    private static final ParticleRenderType HANDLER = new FXHandler();

    public CrystalFXLink(ClientLevel worldIn, TileCrystalBase tile, Vec3D linkTarget) {
        super(worldIn, tile);
        Direction face;
        this.age = worldIn.random.nextInt(1024);
        this.setPosition(tile.getBeamLinkPos(linkTarget.getPos()));
        this.terminateSource = true;
        this.linkTarget = linkTarget;
        Direction direction = face = tile instanceof TileCrystalWirelessIO ? ((TileCrystalWirelessIO)tile).getReceiversFaces().get(linkTarget.getPos()) : null;
        if (face != null) {
            linkTarget.add((double)face.getStepX() * 0.6, (double)face.getStepY() * 0.6, (double)face.getStepZ() * 0.6);
        }
        this.terminateTarget = true;
        this.setBoundingBox(new AABB(this.x, this.y, this.z, this.linkTarget.x, this.linkTarget.y, this.linkTarget.z));
    }

    @Override
    public void tick() {
        super.tick();
        if (!ClientEventHandler.playerHoldingWrench && this.timeout <= 0) {
            this.remove();
        } else if (this.timeout > 0) {
            --this.timeout;
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vector3f[] renderVector;
        float viewZ;
        float viewY;
        float viewX;
        float scale = 0.1f + (float)this.timeout * 0.005f;
        Vec3 viewVec = renderInfo.getPosition();
        Vector3 source = new Vector3(this.x - viewVec.x, this.y - viewVec.y, this.z - viewVec.z);
        Vector3 target = this.linkTarget.toVector3().subtract(viewVec.x, viewVec.y, viewVec.z);
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply((double)scale);
        planeB.multiply((double)scale);
        planeC.multiply((double)scale);
        planeD.multiply((double)scale);
        float dist = 0.2f * (float)Utils.getDistance((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        float anim = ((float)ClientEventHandler.elapsedTicks + partialTicks) / -15.0f;
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        scale *= 2.0f;
        float minU = 0.0f;
        float maxU = 0.53f;
        float minV = 0.0f;
        float maxV = 0.53f;
        if (this.terminateSource) {
            viewX = (float)(this.x - viewVec.x());
            viewY = (float)(this.y - viewVec.y());
            viewZ = (float)(this.z - viewVec.z());
            renderVector = this.getRenderVectors(renderInfo, viewX, viewY, viewZ, scale);
            buffer.vertex((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(maxU, maxV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(maxU, minV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(minU, minV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(minU, maxV).uv2(240, 240).endVertex();
        }
        if (this.terminateTarget) {
            viewX = (float)(this.linkTarget.x - viewVec.x());
            viewY = (float)(this.linkTarget.y - viewVec.y());
            viewZ = (float)(this.linkTarget.z - viewVec.z());
            renderVector = this.getRenderVectors(renderInfo, viewX, viewY, viewZ, scale);
            buffer.vertex((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(maxU, maxV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(maxU, minV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(minU, minV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).color(1.0f, 0.0f, 0.0f, 1.0f).uv(minU, maxV).uv2(240, 240).endVertex();
        }
    }

    private void bufferQuad(VertexConsumer buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, float anim, float dist) {
        buffer.vertex(p1.x, p1.y, p1.z).color(1.0f, 0.0f, 0.0f, 1.0f).uv(0.5f, anim).uv2(240, 240).endVertex();
        buffer.vertex(p2.x, p2.y, p2.z).color(1.0f, 0.0f, 0.0f, 1.0f).uv(0.5f, dist + anim).uv2(240, 240).endVertex();
        buffer.vertex(p4.x, p4.y, p4.z).color(1.0f, 0.0f, 0.0f, 1.0f).uv(1.0f, dist + anim).uv2(240, 240).endVertex();
        buffer.vertex(p3.x, p3.y, p3.z).color(1.0f, 0.0f, 0.0f, 1.0f).uv(1.0f, anim).uv2(240, 240).endVertex();
    }

    public ParticleRenderType getRenderType() {
        return HANDLER;
    }

    public static class FXHandler
    implements ParticleRenderType {
        private static final ResourceLocation highlightTexture = new ResourceLocation("draconicevolution", "textures/particle/energy_beam_highlight.png");

        public void begin(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)highlightTexture);
            builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        }

        public void end(Tesselator tessellator) {
            tessellator.end();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }
}

