/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class CrystalFXWireless
extends CrystalFXBase<TileCrystalWirelessIO> {
    private final BlockPos linkTarget;
    private final AABB targetBB;
    private float powerLevel = 0.0f;
    private List<PTracker> trackers = new ArrayList<PTracker>();
    private static final ParticleRenderType BASIC_HANDLER = new FXHandler();
    private static final ParticleRenderType WYVERN_HANDLER = new FXHandler();
    private static final ParticleRenderType DRACONIC_HANDLER = new FXHandler();

    public CrystalFXWireless(ClientLevel worldIn, TileCrystalWirelessIO tile, BlockPos linkTarget) {
        super(worldIn, tile);
        this.age = worldIn.random.nextInt(1024);
        this.setPosition(tile.getBeamLinkPos(linkTarget));
        this.linkTarget = linkTarget;
        BlockState state = worldIn.getBlockState(linkTarget);
        VoxelShape shape = state.getShape((BlockGetter)worldIn, linkTarget);
        if (shape.isEmpty()) {
            shape = Shapes.block();
        }
        this.targetBB = shape.bounds();
        this.targetBB.deflate(0.05);
        this.setBoundingBox(new AABB(this.x, this.y, this.z, (double)this.linkTarget.getX(), (double)this.linkTarget.getY(), (double)this.linkTarget.getZ()));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksTillDeath-- <= 0) {
            this.remove();
        }
        this.alpha = 1.0f;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.powerLevel = (float)MathHelper.approachExp((double)this.powerLevel, (double)this.fxState, (double)0.05);
        Iterator<PTracker> i = this.trackers.iterator();
        while (i.hasNext()) {
            PTracker next = i.next();
            if (next.ticksActive >= next.travelTime) {
                i.remove();
                continue;
            }
            ++next.ticksActive;
        }
        int ps = ((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId();
        if (this.age % 2 == 0 && this.powerLevel > this.random.nextFloat() && (ps == 0 || ps == 1 && this.random.nextInt(3) == 0 || ps == 2 && this.random.nextInt(10) == 0)) {
            double travel = 50 + this.random.nextInt(50);
            this.trackers.add(new PTracker((int)(travel *= (double)(1.4f - this.powerLevel)), new Vector3(this.targetBB.minX + this.random.nextDouble() * (this.targetBB.maxX - this.targetBB.minX), this.targetBB.minY + this.random.nextDouble() * (this.targetBB.maxY - this.targetBB.minY), this.targetBB.minZ + this.random.nextDouble() * (this.targetBB.maxZ - this.targetBB.minZ))));
        }
        ++this.age;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        int texIndex = ClientEventHandler.elapsedTicks % AtlasTextureHelper.ENERGY_PARTICLE.length;
        TextureAtlasSprite sprite = AtlasTextureHelper.ENERGY_PARTICLE[texIndex];
        if (sprite == null) {
            return;
        }
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        float scale = 0.08f;
        boolean output = !((TileCrystalWirelessIO)this.tile).inputMode.get();
        Vec3 view = renderInfo.getPosition();
        Vector3 source = new Vector3(this.x - view.x, this.y - view.y, this.z - view.z);
        Vector3 target = Vector3.fromBlockPos((BlockPos)this.linkTarget).subtract(view.x, view.y, view.z);
        for (PTracker tracker : this.trackers) {
            double progress = ((double)tracker.ticksActive + (double)partialTicks) / (double)tracker.travelTime;
            if (!output) {
                progress = 1.0 - progress;
            }
            if (progress >= 1.0 || progress <= 0.0) continue;
            Vector3 pathVec = target.copy().subtract(source);
            pathVec.add(tracker.tOffset);
            pathVec.multiply(progress);
            pathVec.add(source);
            Vector3f[] renderVector = this.getRenderVectors(renderInfo, (float)pathVec.x, (float)pathVec.y, (float)pathVec.z, scale);
            buffer.vertex((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).color(0.0f, 1.0f, 1.0f, 1.0f).uv(maxU, maxV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).color(0.0f, 1.0f, 1.0f, 1.0f).uv(maxU, minV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).color(0.0f, 1.0f, 1.0f, 1.0f).uv(minU, minV).uv2(240, 240).endVertex();
            buffer.vertex((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).color(0.0f, 1.0f, 1.0f, 1.0f).uv(minU, maxV).uv2(240, 240).endVertex();
        }
    }

    public ParticleRenderType getRenderType() {
        return ((TileCrystalWirelessIO)this.tile).getTier() == 0 ? BASIC_HANDLER : (((TileCrystalWirelessIO)this.tile).getTier() == 1 ? WYVERN_HANDLER : DRACONIC_HANDLER);
    }

    public static class PTracker {
        public int ticksActive = 0;
        public final int travelTime;
        public final Vector3 tOffset;

        public PTracker(int travelTime, Vector3 tOffset) {
            this.travelTime = travelTime;
            this.tOffset = tOffset;
        }
    }

    public static class FXHandler
    implements ParticleRenderType {
        public void begin(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        }

        public void end(Tesselator tessellator) {
            tessellator.end();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }
}

