/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class ReactorBeamFX
extends Particle {
    protected int ticksTillDeath = 0;
    protected float fxState;
    private float powerState;
    private TileReactorCore tile;
    private boolean isInjectorEffect;
    private Direction facing;
    private float dist;
    private static Colour fieldBeamColour = new ColourARGB(45311);
    private static Colour extractBeamColour = new ColourARGB(0xFF6600);
    private static Colour energyBeamColour = new ColourARGB(0xFF0000);
    private int boltSeed = -1;
    private int ttl = 10;
    public static RenderType REACTOR_BEAM_TYPE = RenderType.create((String)"draconicevolutionbeam_type", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setShaderState(new RenderStateShard.ShaderStateShard(() -> DEShaders.reactorBeamShader)).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    private static final ParticleRenderType FX_HANDLER = new FXHandler();

    public ReactorBeamFX(ClientLevel worldIn, Vec3D pos, Direction facing, TileReactorCore tile, boolean isInjectorEffect) {
        super(worldIn, pos.x, pos.y, pos.z);
        this.tile = tile;
        this.facing = facing;
        this.isInjectorEffect = isInjectorEffect;
        this.dist = (float)Utils.getDistance((Vec3D)pos, (Vec3D)Vec3D.getCenter((BlockPos)tile.getBlockPos()));
        this.random.setSeed(worldIn.random.nextLong());
        this.setBoundingBox(new AABB(this.x, this.y, this.z, (double)tile.getBlockPos().getX(), (double)tile.getBlockPos().getY(), (double)tile.getBlockPos().getZ()));
    }

    public void updateFX(float fxState, float powerState) {
        this.fxState = fxState;
        if (powerState != this.powerState) {
            ReactorBeamFX.fieldBeamColour.r = (byte)(this.powerState * 255.0f);
            ReactorBeamFX.fieldBeamColour.g = (byte)((1.0f - this.powerState) * 176.0f);
            ReactorBeamFX.fieldBeamColour.b = (byte)((1.0f - this.powerState) * 255.0f);
        }
        this.powerState = powerState;
        this.ticksTillDeath = 4;
        if (this.ttl-- <= 0) {
            this.remove();
        }
    }

    public void tick() {
        if (this.ticksTillDeath-- <= 0) {
            this.remove();
        }
        this.ttl = 10;
    }

    public void render(VertexConsumer b, Camera renderInfo, float partialTicks) {
        if (this.tile.roller == null) {
            // empty if block
        }
    }

    private VertexConsumer bindBuffer(CCRenderState ccrs, MultiBufferSource.BufferSource buffers) {
        VertexConsumer buffer = buffers.getBuffer(REACTOR_BEAM_TYPE);
        ccrs.bind(buffer, DefaultVertexFormat.POSITION_TEX);
        return buffer;
    }

    public void renderShaderBeam(CCRenderState ccrs, VertexConsumer buffer, Vec3D pos, double widthStart, double widthEnd, float length, boolean fadeReverse, boolean highRes) {
        float sides = highRes ? 599.0f : 99.0f;
        int i = 0;
        while ((float)i < sides + 1.0f) {
            double angle = (double)((float)i / sides) * (Math.PI * 2);
            float sin = (float)MathHelper.sin((double)angle);
            float cos = (float)MathHelper.cos((double)angle);
            float texX = (float)i / sides;
            Vec3D point = pos.copy().radialOffset(this.facing.getAxis(), (double)sin, (double)cos, widthStart);
            buffer.vertex(point.x, point.y, point.z).color(1.0f, 1.0f, 1.0f, fadeReverse ? 0.0f : this.fxState).uv(texX, fadeReverse ? 0.1f : 1.0f).endVertex();
            point.offset(this.facing, (double)length);
            point.radialOffset(this.facing.getAxis(), (double)sin, (double)cos, widthEnd - widthStart);
            buffer.vertex(point.x, point.y, point.z).color(1.0f, 1.0f, 1.0f, fadeReverse ? this.fxState : 0.0f).uv(texX, 0.0f).endVertex();
            ++i;
        }
    }

    public ParticleRenderType getRenderType() {
        return FX_HANDLER;
    }

    public static class FXHandler
    implements ParticleRenderType {
        public void begin(BufferBuilder builder, TextureManager p_217600_2_) {
        }

        public void end(Tesselator tessellator) {
        }
    }
}

