/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity.projectile;

import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.entity.projectile.DraconicArrowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DraconicArrowRenderer
extends EntityRenderer<DraconicArrowEntity> {
    public static final ResourceLocation RES_ARROW = new ResourceLocation("textures/entity/projectiles/arrow.png");
    public static final ResourceLocation RES_TIPPED_ARROW = new ResourceLocation("textures/entity/projectiles/tipped_arrow.png");

    public DraconicArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(DraconicArrowEntity arrowEntity, float entityYaw, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLightIn) {
        mStack.pushPose();
        mStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)arrowEntity.yRotO, (float)arrowEntity.getYRot()) - 90.0f));
        mStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)arrowEntity.xRotO, (float)arrowEntity.getXRot())));
        float f9 = (float)arrowEntity.shakeTime - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -Mth.sin((float)(f9 * 3.0f)) * f9;
            mStack.mulPose(Axis.ZP.rotationDegrees(f10));
        }
        mStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        mStack.scale(0.05625f, 0.05625f, 0.05625f);
        mStack.translate(-4.0, 0.0, 0.0);
        VertexConsumer ivertexbuilder = getter.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(arrowEntity)));
        PoseStack.Pose matrixstack$entry = mStack.last();
        Matrix4f matrix4f = matrixstack$entry.pose();
        Matrix3f matrix3f = matrixstack$entry.normal();
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLightIn);
        for (int j = 0; j < 4; ++j) {
            mStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, ivertexbuilder, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLightIn);
        }
        mStack.popPose();
        super.render((Entity)arrowEntity, entityYaw, partialTicks, mStack, getter, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, int offsetX, int offsetY, int offsetZ, float textureX, float textureY, int p_229039_9_, int p_229039_10_, int p_229039_11_, int packedLightIn) {
        vertexBuilder.vertex(matrix, (float)offsetX, (float)offsetY, (float)offsetZ).color(255, 255, 255, 255).uv(textureX, textureY).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(packedLightIn).normal(normals, (float)p_229039_9_, (float)p_229039_11_, (float)p_229039_10_).endVertex();
    }

    public ResourceLocation getTextureLocation(DraconicArrowEntity entity) {
        return entity.getColor() > 0 ? RES_TIPPED_ARROW : RES_ARROW;
    }

    public static void renderEnergyBolt(Vector3 startPos, Vector3 endPos, Matrix4 mat, MultiBufferSource getter, float partialTicks) {
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(RenderType.lightning()), (Transformation)mat);
    }

    public static void rendeArcP2P(PoseStack mStack, MultiBufferSource getter, Vector3 startPos, Vector3 endPos, int segCount, long randSeed, float scaleMod, float deflectMod, boolean autoScale, float segTaper, int colour) {
        double height = endPos.y - startPos.y;
        float relScale = autoScale ? (float)height / 128.0f : 1.0f;
        float segHeight = (float)height / (float)segCount;
        float[] segXOffset = new float[segCount + 1];
        float[] segZOffset = new float[segCount + 1];
        float xOffSum = 0.0f;
        float zOffSum = 0.0f;
        Random random = new Random(randSeed);
        for (int segment = 0; segment < segCount + 1; ++segment) {
            segXOffset[segment] = xOffSum + (float)startPos.x;
            segZOffset[segment] = zOffSum + (float)startPos.z;
            if (segment >= segCount) continue;
            xOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
            zOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
        }
        xOffSum -= (float)(endPos.x - startPos.x);
        zOffSum -= (float)(endPos.z - startPos.z);
        VertexConsumer builder = getter.getBuffer(RenderType.lightning());
        Matrix4f matrix4f = mStack.last().pose();
        for (int layer = 0; layer < 4; ++layer) {
            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colour & 0xFF) / 255.0f;
            float alpha = 0.3f;
            if (layer == 0) {
                alpha = 1.0f;
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            for (int seg = 0; seg < segCount; ++seg) {
                float pos = (float)seg / (float)segCount;
                float x = segXOffset[seg] - xOffSum * pos;
                float z = segZOffset[seg] - zOffSum * pos;
                float nextPos = (float)(seg + 1) / (float)segCount;
                float nextX = segXOffset[seg + 1] - xOffSum * nextPos;
                float nextZ = segZOffset[seg + 1] - zOffSum * nextPos;
                float layerOffsetA = (0.1f + (float)layer * 0.2f * (1.0f + segTaper)) * relScale * scaleMod;
                float layerOffsetB = (0.1f + (float)layer * 0.2f * (1.0f - segTaper)) * relScale * scaleMod;
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, false, true, false, segHeight);
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, false, true, true, segHeight);
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, true, false, true, segHeight);
                DraconicArrowRenderer.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, true, false, false, segHeight);
            }
        }
    }

    private static void addSegmentQuad(Matrix4f matrix4f, VertexConsumer builder, float x1, float yOffset, float z1, int segIndex, float x2, float z2, float red, float green, float blue, float alpha, float offsetA, float offsetB, boolean invA, boolean invB, boolean invC, boolean invD, float segHeight) {
        builder.vertex(matrix4f, x1 + (invA ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invB ? offsetB : -offsetB)).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix4f, x2 + (invA ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invB ? offsetA : -offsetA)).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix4f, x2 + (invC ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invD ? offsetA : -offsetA)).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix4f, x1 + (invC ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invD ? offsetB : -offsetB)).color(red, green, blue, alpha).endVertex();
    }
}

