/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class RenderItemMobSoul
implements IItemRenderer {
    private static Set<Entity> brokenMobs = new HashSet<Entity>();

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return true;
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Entity mob = ((MobSoul)((Object)DEContent.MOB_SOUL.get())).getRenderEntity(stack);
        if (brokenMobs.contains(mob)) {
            return;
        }
        float scale = 1.0f / Math.max(mob.getBbWidth(), mob.getBbHeight());
        mStack.translate(0.5, 0.0, 0.5);
        mStack.scale(scale, scale, scale);
        if (transformType != ItemDisplayContext.GROUND && transformType != ItemDisplayContext.FIXED) {
            float rotA = (float)Math.sin(((float)TimeKeeper.getClientTick() + Minecraft.getInstance().getFrameTime()) / 50.0f) * 15.0f;
            float rotB = ((float)TimeKeeper.getClientTick() + Minecraft.getInstance().getFrameTime()) * 3.0f;
            mStack.mulPose(new Quaternionf().rotationXYZ(1.0f * rotA * ((float)Math.PI / 180), 0.0f, -0.5f * rotA * ((float)Math.PI / 180)));
            mStack.mulPose(new Quaternionf().rotationXYZ(0.0f, 1.0f * rotB * ((float)Math.PI / 180), 0.0f));
        }
        EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();
        manager.render(mob, 0.0, 0.0, 0.0, 0.0f, 0.0f, mStack, getter, packedLight);
    }

    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean usesBlockLight() {
        return false;
    }
}

