/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.vec.Matrix4;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderModularSword
extends ToolRenderBase {
    private final ToolRenderBase.ToolPart basePart;
    private final ToolRenderBase.ToolPart materialPart;
    private final ToolRenderBase.ToolPart gemPart;
    private final ToolRenderBase.ToolPart tracePart;
    private final ToolRenderBase.ToolPart bladePart;

    public RenderModularSword(TechLevel techLevel) {
        super(techLevel, "sword");
        Map model = new OBJParser(new ResourceLocation("draconicevolution", "models/item/equipment/sword.obj")).ignoreMtl().parse();
        this.basePart = this.basePart(CCModel.combine(Arrays.asList((CCModel)model.get("handle"), (CCModel)model.get("handle_bauble"), (CCModel)model.get("hilt"))).backfacedCopy());
        this.materialPart = this.materialPart(((CCModel)model.get("blade_core")).backfacedCopy());
        this.gemPart = this.gemPart(((CCModel)model.get("blade_gem")).backfacedCopy());
        this.tracePart = this.tracePart(CCModel.combine(Arrays.asList((CCModel)model.get("trace_top"), (CCModel)model.get("trace_bottom"))).backfacedCopy());
        this.bladePart = this.bladePart(((CCModel)model.get("blade_edge")).backfacedCopy());
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemDisplayContext context, Matrix4 mat, MultiBufferSource buffers, boolean gui) {
        this.transform(mat, 0.29, 0.29, 0.5, gui ? 0.875 : 1.125);
        this.basePart.render(context, buffers, mat);
        this.materialPart.render(context, buffers, mat);
        this.tracePart.render(context, buffers, mat);
        this.gemPart.render(context, buffers, mat);
        this.bladePart.render(context, buffers, mat);
    }

    public static class SWORD_CHAOTIC
    extends RenderModularSword {
        public SWORD_CHAOTIC() {
            super(TechLevel.CHAOTIC);
        }
    }

    public static class SWORD_DRACONIC
    extends RenderModularSword {
        public SWORD_DRACONIC() {
            super(TechLevel.DRACONIC);
        }
    }

    public static class SWORD_WYVERN
    extends RenderModularSword {
        public SWORD_WYVERN() {
            super(TechLevel.WYVERN);
        }
    }
}

