/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public class RenderEnergyCoreStabilizer
implements BlockEntityRenderer<TileEnergyCoreStabilizer> {
    private static final RenderType MODEL_TYPE = RenderType.entitySolid((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_large.png"));
    private static final RenderType MODEL_TYPE_ACTIVE = RenderType.create((String)"stab_type_a", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_large.png"), false, false)).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false));
    private CCModel model;

    public RenderEnergyCoreStabilizer(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/energy_core/stabilizer_large.obj")).quads().ignoreMtl().parse();
        this.model = CCModel.combine(map.values()).backfacedCopy();
    }

    public void render(TileEnergyCoreStabilizer tile, float partialTicks, PoseStack poseStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        if (!tile.isValidMultiBlock.get()) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = 240;
        ccrs.overlay = packedOverlay;
        boolean coreActive = tile.isCoreActive.get();
        Direction facing = coreActive ? (Direction)tile.coreDirection.get() : Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)tile.multiBlockAxis.get()));
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (facing.getAxis() == Direction.Axis.X || facing.getAxis() == Direction.Axis.Y) {
            poseStack.mulPose(new Quaternionf().rotationXYZ((float)(facing.getStepY() * 90) * ((float)Math.PI / 180), (float)(facing.getStepX() * -90) * ((float)Math.PI / 180), 0.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(tile.rotation + (coreActive ? partialTicks : 0.0f)));
        poseStack.translate(0.0, -1.5, 0.0);
        ccrs.bind(coreActive ? MODEL_TYPE_ACTIVE : MODEL_TYPE, getter, poseStack);
        this.model.render(ccrs, new IVertexOperation[0]);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(TileEnergyCoreStabilizer blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(1.0);
    }
}

