/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.blocks.DislocatorPedestal;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorPedestal;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Quaternionf;

public class RenderTileDislocatorPedestal
implements BlockEntityRenderer<TileDislocatorPedestal> {
    public static List<BakedQuad> modelQuads = null;

    public RenderTileDislocatorPedestal(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileDislocatorPedestal tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedoverlay) {
        if (modelQuads == null) {
            modelQuads = Minecraft.getInstance().getBlockRenderer().getBlockModel(((DislocatorPedestal)((Object)DEContent.DISLOCATOR_PEDESTAL.get())).defaultBlockState()).getQuads(((DislocatorPedestal)((Object)DEContent.DISLOCATOR_PEDESTAL.get())).defaultBlockState(), null, tile.getLevel().random);
        }
        mStack.pushPose();
        mStack.translate(0.5, 0.5, 0.5);
        mStack.mulPose(Axis.YP.rotationDegrees((float)(-tile.rotation.get()) * 22.5f));
        mStack.translate(-0.5, -0.5, -0.5);
        VertexConsumer builder = getter.getBuffer(RenderType.solid());
        int j = modelQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = modelQuads.get(i);
            builder.putBulkData(mStack.last(), bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedLight, true);
        }
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = tile.itemHandler.getStackInSlot(0);
        if (!stack.isEmpty()) {
            mStack.pushPose();
            mStack.translate(0.5, 0.79, 0.52);
            mStack.scale(0.5f, 0.5f, 0.5f);
            mStack.mulPose(Axis.XP.rotationDegrees(-67.5f));
            mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedoverlay, mStack, getter, tile.getLevel(), tile.posSeed());
            mStack.popPose();
        }
        RenderUtils.endBatch((MultiBufferSource)getter);
        mStack.popPose();
        if (!stack.isEmpty()) {
            this.drawName(tile, stack, mStack, getter, partialTicks);
        }
    }

    private void drawName(TileDislocatorPedestal tile, ItemStack item, PoseStack mStack, MultiBufferSource getter, float partialTicks) {
        DislocatorAdvanced.DislocatorTarget location;
        String name;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        HitResult hitResult = player.pick(10.0, partialTicks, true);
        boolean isCursorOver = hitResult.getType() == HitResult.Type.BLOCK && ((BlockHitResult)hitResult).getBlockPos().equals((Object)tile.getBlockPos());
        boolean isSneaking = player.isShiftKeyDown();
        if (!isCursorOver && isSneaking != DEOldConfig.invertDPDSB) {
            return;
        }
        String string = name = item.hasCustomHoverName() ? item.getHoverName().getString() : "";
        if (item.getItem() instanceof DislocatorAdvanced && (location = ((DislocatorAdvanced)item.getItem()).getTargetPos(item, tile.getLevel())) != null) {
            name = location.getName();
        }
        if (name.isEmpty()) {
            return;
        }
        mStack.pushPose();
        mStack.translate(0.5, 1.125, 0.5);
        mStack.scale(0.02f, 0.02f, 0.02f);
        mStack.mulPose(new Quaternionf().rotationXYZ(0.0f, -1.5707964f, (float)Math.PI));
        double xDiff = player.getX() - ((double)tile.getBlockPos().getX() + 0.5);
        double yDiff = player.getY() + (double)player.getEyeHeight() - ((double)tile.getBlockPos().getY() + 1.125);
        double zDiff = player.getZ() - ((double)tile.getBlockPos().getZ() + 0.5);
        double yawAngle = Math.toDegrees(Math.atan2(zDiff, xDiff));
        double pitchAngle = Math.toDegrees(Math.atan2(yDiff, Utils.getDistance((double)player.getX(), (double)player.getY(), (double)player.getZ(), (double)((double)tile.getBlockPos().getX() + 0.5), (double)((double)tile.getBlockPos().getY() + 0.5), (double)((double)tile.getBlockPos().getZ() + 0.5))));
        mStack.mulPose(Axis.YP.rotationDegrees((float)yawAngle));
        mStack.mulPose(Axis.XP.rotationDegrees((float)(-pitchAngle)));
        mStack.scale(1.0f, 1.0f, -1.0f);
        int textWidth = mc.font.width(name);
        mStack.translate(0.0, 0.0, -0.0125);
        mc.font.drawInBatch(name, -((float)textWidth / 2.0f), 0.0f, 0xFFFFFF, true, mStack.last().pose(), getter, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        mStack.popPose();
    }
}

