/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.colour.Colour;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.render.MultiBlockRenderers;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.multiblock.MultiBlockDefinition;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RenderTileEnergyCore
implements BlockEntityRenderer<TileEnergyCore> {
    public static final double[] SCALES = new double[]{1.1, 1.7, 2.3, 3.6, 5.5, 7.1, 8.6, 10.2};
    private static final RenderType innerCoreType = RenderType.entitySolid((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/energy_core/energy_core_base.png"));
    private static final RenderType outerCoreType = RenderType.create((String)"outer_core", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/energy_core_overlay.png"), false, false)).setShaderState(new RenderStateShard.ShaderStateShard(() -> BCShaders.posColourTexAlpha0)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).createCompositeState(false));
    private static final RenderType innerStabType = RenderType.create((String)"inner_stab", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_sphere.png"), false, false)).setShaderState(new RenderStateShard.ShaderStateShard(() -> BCShaders.posColourTexAlpha0)).setTransparencyState(RenderStateShard.NO_TRANSPARENCY).createCompositeState(false));
    private static final RenderType outerStabType = RenderType.create((String)"outer_stab", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_sphere.png"), false, false)).setShaderState(new RenderStateShard.ShaderStateShard(() -> BCShaders.posColourTexAlpha0)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).createCompositeState(false));
    private static final RenderType beamType = RenderType.create((String)"inner_beam", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_beam.png"), false, false)).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexShader)).setTransparencyState(RenderStateShard.NO_TRANSPARENCY).createCompositeState(false));
    private static final RenderType outerBeamType = RenderType.create((String)"outer_beam", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_beam.png"), false, false)).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));
    private static RenderType coreShaderType = RenderType.create((String)"test_shader", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/energy_core_overlay.png"), false, false)).setShaderState(new RenderStateShard.ShaderStateShard(() -> DEShaders.energyCoreShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    private final CCModel modelStabilizerSphere;
    private final CCModel modelEnergyCore;

    public RenderTileEnergyCore(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/energy_core/stabilizer_sphere.obj")).quads().ignoreMtl().parse();
        this.modelStabilizerSphere = CCModel.combine(map.values());
        this.modelStabilizerSphere.computeNormals();
        map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/energy_core/energy_core_model.obj")).quads().ignoreMtl().parse();
        this.modelEnergyCore = CCModel.combine(map.values());
        this.modelEnergyCore.computeNormals();
    }

    public void render(TileEnergyCore te, float partialTicks, PoseStack poseStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        MultiBlockDefinition def;
        if (te.buildGuide.get() && (def = te.getMultiBlockDef()) != null) {
            MultiBlockRenderers.renderBuildGuide((Level)te.getLevel(), (BlockPos)te.getBlockPos(), (PoseStack)poseStack, (MultiBufferSource)getter, (MultiBlockDefinition)def, (int)200, (float)partialTicks);
        }
        if (!te.active.get()) {
            return;
        }
        Matrix4 mat = new Matrix4(poseStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        float rotation = ((float)ClientEventHandler.elapsedTicks + partialTicks) / 2.0f;
        double scale = SCALES[te.tier.get() - 1];
        this.renderInnerCore(te, ccrs, mat, getter, partialTicks, rotation, scale);
        ccrs.reset();
        if (te.legacyRender.get()) {
            this.renderLegacyOuterCore(te, ccrs, mat, getter, partialTicks, rotation, scale);
        } else {
            this.renderFancyOuterCore(te, ccrs, mat, getter, partialTicks, rotation, scale);
        }
        this.renderStabilizers(te, ccrs, mat, getter, partialTicks);
    }

    public void renderInnerCore(TileEnergyCore te, CCRenderState ccrs, Matrix4 mat, MultiBufferSource getter, float partialTicks, float rotation, double scale) {
        int brightness = (int)Math.abs(Math.sin((float)ClientEventHandler.elapsedTicks / 100.0f) * 100.0);
        ccrs.baseColour = te.getColour();
        ccrs.brightness = 140 + brightness;
        ccrs.bind(innerCoreType, getter);
        Matrix4 coreMat = mat.copy();
        coreMat.translate(Vector3.CENTER);
        coreMat.scale(scale * -0.65, scale * -0.65, scale * -0.65);
        coreMat.rotate((double)rotation * 0.017453292519943, new Vector3(0.0, 1.0, 0.5).normalize());
        this.modelEnergyCore.render(ccrs, new IVertexOperation[]{coreMat});
    }

    public void renderFancyOuterCore(TileEnergyCore te, CCRenderState ccrs, Matrix4 mat, MultiBufferSource getter, float partialTicks, float rotation, double scale) {
        float[] effect;
        float[] triangle;
        float[] frame;
        boolean t8;
        DEShaders.energyCoreActivation.glUniform1f(1.0f);
        boolean bl = t8 = te.tier.get() == 8;
        if (te.customColour.get()) {
            frame = RenderTileEnergyCore.unpack(te.frameColour.get());
            triangle = RenderTileEnergyCore.unpack(te.innerColour.get());
            effect = RenderTileEnergyCore.unpack(te.effectColour.get());
        } else {
            frame = RenderTileEnergyCore.unpack(t8 ? 0x191919 : 0x191919);
            triangle = RenderTileEnergyCore.unpack(t8 ? 10823168 : 0x660099);
            effect = RenderTileEnergyCore.unpack(t8 ? 0xFF7F00 : 62194);
        }
        DEShaders.energyCoreFrameColour.glUniform3f(frame[0], frame[1], frame[2]);
        DEShaders.energyCoreRotTriColour.glUniform3f(triangle[0], triangle[1], triangle[2]);
        DEShaders.energyCoreEffectColour.glUniform3f(effect[0], effect[1], effect[2]);
        ccrs.bind(coreShaderType, getter);
        Matrix4 overlayMat = mat.copy();
        overlayMat.translate(Vector3.CENTER);
        overlayMat.scale(scale * -0.7, scale * -0.7, scale * -0.7);
        overlayMat.rotate((double)(rotation * 0.5f) * 0.017453292519943, new Vector3(0.0, -1.0, -0.5).normalize());
        this.modelEnergyCore.render(ccrs, new IVertexOperation[]{overlayMat});
    }

    public void renderLegacyOuterCore(TileEnergyCore te, CCRenderState ccrs, Matrix4 mat, MultiBufferSource getter, float partialTicks, float rotation, double scale) {
        ccrs.baseColour = te.tier.get() == 8 ? Colour.packRGBA((double)0.95f, (double)0.45f, (double)0.0, (double)1.0) : Colour.packRGBA((double)0.2f, (double)1.0, (double)1.0, (double)1.0);
        ccrs.bind(outerCoreType, getter);
        Matrix4 overlayMatRef = mat.copy();
        overlayMatRef.translate(0.5, 0.5, 0.5);
        overlayMatRef.scale(scale * -0.7, scale * -0.7, scale * -0.7);
        overlayMatRef.rotate((double)(rotation * 0.5f) * 0.017453292519943, new Vector3(0.0, -1.0, -0.5).normalize());
        this.modelEnergyCore.render(ccrs, new IVertexOperation[]{overlayMatRef});
    }

    private void renderStabilizers(TileEnergyCore te, CCRenderState ccrs, Matrix4 matrix4, MultiBufferSource getter, float partialTick) {
        if (!te.stabilizersValid.get()) {
            return;
        }
        for (ManagedPos posOffset : te.stabilizerPositions) {
            Matrix4 mat = matrix4.copy();
            mat.translate((double)(-posOffset.get().getX()) + 0.5, (double)(-posOffset.get().getY()) + 0.5, (double)(-posOffset.get().getZ()) + 0.5);
            Direction facing = Direction.getNearest((float)posOffset.get().getX(), (float)posOffset.get().getY(), (float)posOffset.get().getZ());
            if (facing.getAxis() == Direction.Axis.X || facing.getAxis() == Direction.Axis.Y) {
                mat.rotate(-1.5707963267948701, new Vector3((double)(-facing.getStepY()), (double)facing.getStepX(), 0.0).normalize());
            } else if (facing == Direction.SOUTH) {
                mat.rotate(3.1415926535897403, new Vector3(0.0, 1.0, 0.0).normalize());
            }
            mat.rotate(1.5707963267948701, new Vector3(1.0, 0.0, 0.0).normalize());
            ccrs.baseColour = -1;
            this.renderStabilizerBeam(te, mat, getter, posOffset.get(), partialTick);
            if (te.tier.get() >= 5) {
                mat.scale((double)-1.2f, -0.5, (double)-1.2f);
            } else {
                mat.scale(-0.45, -0.45, -0.45);
            }
            Matrix4 innerMat = mat.copy();
            innerMat.scale((double)0.9f, (double)0.9f, (double)0.9f);
            ccrs.baseColour = 0xFFFFFF;
            ccrs.brightness = 240;
            innerMat.rotate((double)((float)ClientEventHandler.elapsedTicks + partialTick) * 0.017453292519943, new Vector3(0.0, -1.0, 0.0));
            ccrs.bind(innerStabType, getter);
            this.modelStabilizerSphere.render(ccrs, new IVertexOperation[]{innerMat});
            mat.scale((double)1.1f, (double)1.1f, (double)1.1f);
            ccrs.baseColour = 0xFFFF7F;
            ccrs.brightness = 240;
            mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTick) * 0.5f) * 0.017453292519943, new Vector3(0.0, 1.0, 0.0));
            ccrs.bind(outerStabType, getter);
            this.modelStabilizerSphere.render(ccrs, new IVertexOperation[]{mat});
        }
    }

    private void renderStabilizerBeam(TileEnergyCore te, Matrix4 matrix4, MultiBufferSource getter, BlockPos vec, float partialTick) {
        Matrix4 innerMat = matrix4.copy();
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(beamType), (Transformation)innerMat);
        innerMat.rotate(3.1415926535897403, new Vector3(0.0, 0.0, 1.0));
        float beamLength = (float)Math.abs(vec.getX() + vec.getY() + vec.getZ()) - 0.5f;
        float time = (float)ClientEventHandler.elapsedTicks + partialTick;
        double rotation = (double)time * 0.025 * -1.5;
        float beamMotion = -time * 0.2f - (float)MathHelper.floor((float)(-time * 0.1f));
        float scale = 0.2f;
        float d7 = 0.5f + (float)Math.cos(rotation + 2.356194496154785) * scale;
        float d9 = 0.5f + (float)Math.sin(rotation + 2.356194496154785) * scale;
        float d11 = 0.5f + (float)Math.cos(rotation + 0.7853981633974483) * scale;
        float d13 = 0.5f + (float)Math.sin(rotation + 0.7853981633974483) * scale;
        float d15 = 0.5f + (float)Math.cos(rotation + 3.9269907474517822) * scale;
        float d17 = 0.5f + (float)Math.sin(rotation + 3.9269907474517822) * scale;
        float d19 = 0.5f + (float)Math.cos(rotation + 5.497786998748779) * scale;
        float d21 = 0.5f + (float)Math.sin(rotation + 5.497786998748779) * scale;
        float texXMin = 0.0f;
        float texXMax = 1.0f;
        float d28 = -1.0f + beamMotion;
        float texHeight = beamLength * (0.5f / scale) + d28;
        if (te.tier.get() >= 5) {
            innerMat.scale(3.5, 1.0, 3.5);
        }
        innerMat.translate(-0.5, 0.0, -0.5);
        builder.vertex((double)d7, (double)beamLength, (double)d9).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d7, 0.0, (double)d9).uv(texXMax, d28).endVertex();
        builder.vertex((double)d11, 0.0, (double)d13).uv(texXMin, d28).endVertex();
        builder.vertex((double)d11, (double)beamLength, (double)d13).uv(texXMin, texHeight).endVertex();
        builder.vertex((double)d19, (double)beamLength, (double)d21).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d19, 0.0, (double)d21).uv(texXMax, d28).endVertex();
        builder.vertex((double)d15, 0.0, (double)d17).uv(texXMin, d28).endVertex();
        builder.vertex((double)d15, (double)beamLength, (double)d17).uv(texXMin, texHeight).endVertex();
        builder.vertex((double)d11, (double)beamLength, (double)d13).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d11, 0.0, (double)d13).uv(texXMax, d28).endVertex();
        builder.vertex((double)d19, 0.0, (double)d21).uv(texXMin, d28).endVertex();
        builder.vertex((double)d19, (double)beamLength, (double)d21).uv(texXMin, texHeight).endVertex();
        builder.vertex((double)d15, (double)beamLength, (double)d17).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d15, 0.0, (double)d17).uv(texXMax, d28).endVertex();
        builder.vertex((double)d7, 0.0, (double)d9).uv(texXMin, d28).endVertex();
        builder.vertex((double)d7, (double)beamLength, (double)d9).uv(texXMin, texHeight).endVertex();
        d7 = 0.5f + (float)Math.cos((rotation += (double)0.77f) + 2.356194496154785) * scale;
        d9 = 0.5f + (float)Math.sin(rotation + 2.356194496154785) * scale;
        d11 = 0.5f + (float)Math.cos(rotation + 0.7853981633974483) * scale;
        d13 = 0.5f + (float)Math.sin(rotation + 0.7853981633974483) * scale;
        d15 = 0.5f + (float)Math.cos(rotation + 3.9269907474517822) * scale;
        d17 = 0.5f + (float)Math.sin(rotation + 3.9269907474517822) * scale;
        d19 = 0.5f + (float)Math.cos(rotation + 5.497786998748779) * scale;
        d21 = 0.5f + (float)Math.sin(rotation + 5.497786998748779) * scale;
        d28 = -1.0f + beamMotion * 1.0f;
        texHeight = beamLength * (0.5f / scale) + d28;
        builder.vertex((double)d7, (double)beamLength, (double)d9).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d7, 0.0, (double)d9).uv(texXMax, d28).endVertex();
        builder.vertex((double)d11, 0.0, (double)d13).uv(texXMin, d28).endVertex();
        builder.vertex((double)d11, (double)beamLength, (double)d13).uv(texXMin, texHeight).endVertex();
        builder.vertex((double)d19, (double)beamLength, (double)d21).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d19, 0.0, (double)d21).uv(texXMax, d28).endVertex();
        builder.vertex((double)d15, 0.0, (double)d17).uv(texXMin, d28).endVertex();
        builder.vertex((double)d15, (double)beamLength, (double)d17).uv(texXMin, texHeight).endVertex();
        builder.vertex((double)d11, (double)beamLength, (double)d13).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d11, 0.0, (double)d13).uv(texXMax, d28).endVertex();
        builder.vertex((double)d19, 0.0, (double)d21).uv(texXMin, d28).endVertex();
        builder.vertex((double)d19, (double)beamLength, (double)d21).uv(texXMin, texHeight).endVertex();
        builder.vertex((double)d15, (double)beamLength, (double)d17).uv(texXMax, texHeight).endVertex();
        builder.vertex((double)d15, 0.0, (double)d17).uv(texXMax, d28).endVertex();
        builder.vertex((double)d7, 0.0, (double)d9).uv(texXMin, d28).endVertex();
        builder.vertex((double)d7, (double)beamLength, (double)d9).uv(texXMin, texHeight).endVertex();
        Matrix4 outerMat = matrix4.copy();
        builder = new TransformingVertexConsumer(getter.getBuffer(outerBeamType), (Transformation)outerMat);
        outerMat.rotate(3.1415926535897403, new Vector3(0.0, 0.0, 1.0));
        outerMat.rotate(1.5707963267948701, new Vector3(-1.0, 0.0, 0.0));
        outerMat.rotate(0.7853981633974351, new Vector3(0.0, 0.0, 1.0));
        outerMat.translate(0.0, 0.0, 0.4);
        int sides = 4;
        float enlarge = 0.35f;
        if (te.tier.get() >= 5) {
            sides = 12;
            enlarge = 0.5f + (float)(te.tier.get() - 5) * 0.1f;
            outerMat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTick) * 0.6f) * 0.017453292519943, new Vector3(0.0, 0.0, -1.0));
            outerMat.scale(3.5, 3.5, 1.0);
        }
        for (int i = 0; i <= sides; ++i) {
            float verX = (float)Math.sin((float)(i % sides) * (float)Math.PI * 2.0f / (float)sides) * 1.0f;
            float verY = (float)Math.cos((float)(i % sides) * (float)Math.PI * 2.0f / (float)sides) * 1.0f;
            builder.vertex((double)(verX * 0.35f), (double)(verY * 0.35f), 0.0).color(255, 255, 255, 32).uv((float)i, beamMotion * 2.0f).endVertex();
            builder.vertex((double)(verX * enlarge), (double)(verY * enlarge), (double)beamLength).color(255, 255, 255, 32).uv((float)i, beamLength + beamMotion * 2.0f).endVertex();
        }
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen(TileEnergyCore p_188185_1_) {
        return true;
    }

    private static float[] unpack(int colour) {
        return new float[]{(float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f};
    }

    public AABB getRenderBoundingBox(TileEnergyCore blockEntity) {
        return INFINITE_EXTENT_AABB;
    }
}

