/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianPartEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DraconicGuardianEntity
extends Mob
implements Enemy {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    public static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> CRYSTAL_ID = SynchedEntityData.defineId(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> SHIELD_POWER = SynchedEntityData.defineId(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Optional<BlockPos>> ORIGIN = SynchedEntityData.defineId(DraconicGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final TargetingConditions PLAYER_INVADER_CONDITION = TargetingConditions.forCombat().range(64.0);
    public final double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    private final DraconicGuardianPartEntity[] dragonParts;
    public final DraconicGuardianPartEntity dragonPartHead;
    private final DraconicGuardianPartEntity dragonPartNeck;
    private final DraconicGuardianPartEntity dragonPartBody;
    private final DraconicGuardianPartEntity dragonPartTail1;
    private final DraconicGuardianPartEntity dragonPartTail2;
    private final DraconicGuardianPartEntity dragonPartTail3;
    private final DraconicGuardianPartEntity dragonPartRightWing;
    private final DraconicGuardianPartEntity dragonPartLeftWing;
    public float oFlapTime;
    public float flapTime;
    public boolean slowed;
    public int deathTicks;
    public float yRotA;
    @javax.annotation.Nullable
    public GuardianCrystalEntity closestGuardianCrystal;
    @javax.annotation.Nullable
    private GuardianFightManager fightManager;
    private final PhaseManager phaseManager;
    private int growlTime = 100;
    private Node[] pathPoints = new Node[24];
    private final BinaryHeap pathFindQueue = new BinaryHeap();
    private double speedMult = 1.0;
    public float dpm = 0.0f;
    private float lastDamage;
    private int hitCoolDown;

    public DraconicGuardianEntity(EntityType<?> type, Level world) {
        super((EntityType)DEContent.ENTITY_DRACONIC_GUARDIAN.get(), world);
        this.dragonPartHead = new DraconicGuardianPartEntity(this, "head", 1.0f, 1.0f);
        this.dragonPartNeck = new DraconicGuardianPartEntity(this, "neck", 3.0f, 3.0f);
        this.dragonPartBody = new DraconicGuardianPartEntity(this, "body", 5.0f, 3.0f);
        this.dragonPartTail1 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail2 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail3 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartRightWing = new DraconicGuardianPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonPartLeftWing = new DraconicGuardianPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonParts = new DraconicGuardianPartEntity[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartRightWing, this.dragonPartLeftWing};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.noCulling = true;
        this.phaseManager = new PhaseManager(this);
        this.setId(ENTITY_COUNTER.getAndAdd(this.dragonParts.length + 1) + 1);
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.dragonParts.length; ++i) {
            this.dragonParts[i].setId(id + i + 1);
        }
    }

    public void knockback(double p_147241_, double p_147242_, double p_147243_) {
    }

    public void setFightManager(GuardianFightManager fightManager) {
        this.fightManager = fightManager;
    }

    public void setArenaOrigin(BlockPos arenaOrigin) {
        this.entityData.set(ORIGIN, Optional.ofNullable(arenaOrigin));
    }

    public BlockPos getArenaOrigin() {
        return ((Optional)this.entityData.get(ORIGIN)).orElse(null);
    }

    public AttributeMap getAttributes() {
        return super.getAttributes();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (double)DEConfig.guardianHealth);
    }

    public float getShieldPower() {
        return ((Float)this.entityData.get(SHIELD_POWER)).floatValue();
    }

    public void setShieldPower(float shieldPower) {
        this.entityData.set(SHIELD_POWER, (Object)Float.valueOf(shieldPower));
        GuardianFightManager manager = this.getFightManager();
        if (manager != null) {
            manager.guardianUpdate(this);
        }
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(PHASE, (Object)PhaseType.HOVER.getId());
        this.getEntityData().define(CRYSTAL_ID, (Object)-1);
        this.getEntityData().define(SHIELD_POWER, (Object)Float.valueOf(0.0f));
        this.getEntityData().define(ORIGIN, Optional.empty());
    }

    public void tick() {
        GuardianFightManager manager;
        super.tick();
        if (!this.level().isClientSide && this.getShieldPower() < (float)DEConfig.guardianShield && (manager = this.getFightManager()) != null && manager.getNumAliveCrystals() > 0) {
            this.setShieldPower(Math.min((float)DEConfig.guardianShield, this.getShieldPower() + (float)DEConfig.guardianShield / 200.0f));
        }
        if (this.hitCoolDown > 0) {
            --this.hitCoolDown;
        }
    }

    public double[] getLatencyPos(int index, float partialTicks) {
        if (this.isDeadOrDying()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - index & 0x3F;
        int j = this.ringBufferIndex - index - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = Mth.wrapDegrees((double)(this.ringBuffer[j][0] - d0));
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.lerp((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    public void aiStep() {
        this.speedMult = MathHelper.approachLinear((double)this.speedMult, (double)this.phaseManager.getCurrentPhase().getGuardianSpeed(), (double)0.1);
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent()) {
                float f = Mth.cos((float)(this.flapTime * ((float)Math.PI * 2)));
                float f1 = Mth.cos((float)(this.oFlapTime * ((float)Math.PI * 2)));
                if (f1 <= -0.3f && f >= -0.3f) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
                }
                if (!this.phaseManager.getCurrentPhase().getIsStationary() && --this.growlTime < 0) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                    this.growlTime = 200 + this.random.nextInt(200);
                }
            }
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float randX = (this.random.nextFloat() - 0.5f) * 8.0f;
            float randY = (this.random.nextFloat() - 0.5f) * 4.0f;
            float randZ = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)randX, this.getY() + 2.0 + (double)randY, this.getZ() + (double)randZ, 0.0, 0.0, 0.0);
        } else {
            this.updateDragonEnderCrystal();
            Vec3 vec3 = this.getDeltaMovement();
            float f = 0.2f / ((float)vec3.horizontalDistance() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().getIsStationary() ? (this.flapTime += 0.1f) : (this.slowed ? (this.flapTime += f * 0.5f) : (this.flapTime += (f *= (float)Math.pow(2.0, vec3.y))));
            this.setYRot(Mth.wrapDegrees((float)this.getYRot()));
            if (this.isNoAi()) {
                this.flapTime = 0.5f;
            } else {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.getYRot();
                        this.ringBuffer[i][1] = this.getY();
                    }
                }
                if (++this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.getYRot();
                this.ringBuffer[this.ringBufferIndex][1] = this.getY();
                if (this.level().isClientSide) {
                    if (this.lerpSteps > 0) {
                        double d7 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
                        double d0 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
                        double d1 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
                        double d2 = Mth.wrapDegrees((double)(this.lerpYRot - (double)this.getYRot()));
                        this.setYRot((float)((double)this.getYRot() + d2 / (double)this.lerpSteps));
                        this.setXRot((float)((double)this.getXRot() + (this.lerpXRot - (double)this.getXRot()) / (double)this.lerpSteps));
                        --this.lerpSteps;
                        this.setPos(d7, d0, d1);
                        this.setRot(this.getYRot(), this.getXRot());
                    }
                    this.phaseManager.getCurrentPhase().clientTick();
                } else {
                    IPhase iphase = this.phaseManager.getCurrentPhase();
                    iphase.serverTick();
                    if (this.phaseManager.getCurrentPhase() != iphase) {
                        iphase = this.phaseManager.getCurrentPhase();
                        iphase.serverTick();
                    }
                    this.phaseManager.globalServerTick();
                    Vec3 targetLocation = iphase.getTargetLocation();
                    if (targetLocation != null) {
                        double tRelX = targetLocation.x - this.getX();
                        double tRelY = targetLocation.y - this.getY();
                        double tRelZ = targetLocation.z - this.getZ();
                        double distanceSq = tRelX * tRelX + tRelY * tRelY + tRelZ * tRelZ;
                        float maxRiseOrFall = iphase.getMaxRiseOrFall();
                        double distanceXZ = Math.sqrt(tRelX * tRelX + tRelZ * tRelZ);
                        if (distanceXZ > 0.0) {
                            tRelY = this.phaseManager.getCurrentPhase().highVerticalAgility() ? Mth.clamp((double)tRelY, (double)(-maxRiseOrFall), (double)maxRiseOrFall) : Mth.clamp((double)(tRelY / distanceXZ), (double)(-maxRiseOrFall), (double)maxRiseOrFall);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, tRelY * 0.01, 0.0));
                        this.setYRot(Mth.wrapDegrees((float)this.getYRot()));
                        double relTargetAngle = Mth.clamp((double)Mth.wrapDegrees((double)(180.0 - Mth.atan2((double)tRelX, (double)tRelZ) * 57.2957763671875 - (double)this.getYRot())), (double)-50.0, (double)50.0);
                        if (Math.abs(relTargetAngle) < 5.0) {
                            relTargetAngle *= this.speedMult * 5.0;
                        }
                        Vec3 targetVector = targetLocation.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                        Vec3 vector3d2 = new Vec3((double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), this.getDeltaMovement().y, (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))))).normalize();
                        float f8 = Math.max(((float)vector3d2.dot(targetVector) + 0.5f) / 1.5f, 0.0f);
                        this.yRotA *= 0.8f;
                        this.yRotA = (float)((double)this.yRotA + relTargetAngle * (double)iphase.getYawFactor());
                        this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                        float f9 = (float)(2.0 / (distanceSq + 1.0));
                        float f10 = 0.06f;
                        this.moveRelative(f10 * (f8 * f9 + (1.0f - f9)), new Vec3(0.0, 0.0, -1.0));
                        if (this.slowed) {
                            this.move(MoverType.SELF, this.getDeltaMovement().scale((double)0.8f).scale(this.speedMult));
                        } else {
                            this.move(MoverType.SELF, this.getDeltaMovement().scale(this.speedMult));
                        }
                        Vec3 vector3d3 = this.getDeltaMovement().normalize();
                        double d6 = 0.8 + 0.15 * (vector3d3.dot(vector3d2) + 1.0) / 2.0;
                        this.setDeltaMovement(this.getDeltaMovement().multiply(d6, (double)0.91f, d6));
                    }
                }
                this.yBodyRot = this.getYRot();
                Vec3[] avector3d = new Vec3[this.dragonParts.length];
                for (int j = 0; j < this.dragonParts.length; ++j) {
                    avector3d[j] = new Vec3(this.dragonParts[j].getX(), this.dragonParts[j].getY(), this.dragonParts[j].getZ());
                }
                float f15 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = Mth.cos((float)f15);
                float f2 = Mth.sin((float)f15);
                float f17 = this.getYRot() * ((float)Math.PI / 180);
                float f3 = Mth.sin((float)f17);
                float f18 = Mth.cos((float)f17);
                this.setPartPosition(this.dragonPartBody, f3 * 0.5f, 0.0, -f18 * 0.5f);
                this.setPartPosition(this.dragonPartRightWing, f18 * 4.5f, 2.0, f3 * 4.5f);
                this.setPartPosition(this.dragonPartLeftWing, f18 * -4.5f, 2.0, f3 * -4.5f);
                if (!this.level().isClientSide && this.hurtTime == 0) {
                    this.collideWithEntities(this.level().getEntities((Entity)this, this.dragonPartRightWing.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    this.collideWithEntities(this.level().getEntities((Entity)this, this.dragonPartLeftWing.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    this.attackEntitiesInList(this.level().getEntities((Entity)this, this.dragonPartHead.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    this.attackEntitiesInList(this.level().getEntities((Entity)this, this.dragonPartNeck.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                }
                float f4 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f19 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f5 = this.getHeadAndNeckYOffset();
                this.setPartPosition(this.dragonPartHead, f4 * 6.5f * f16, f5 + f2 * 6.5f, -f19 * 6.5f * f16);
                this.setPartPosition(this.dragonPartNeck, f4 * 5.5f * f16, f5 + f2 * 5.5f, -f19 * 5.5f * f16);
                double[] adouble = this.getLatencyPos(5, 1.0f);
                for (int k = 0; k < 3; ++k) {
                    DraconicGuardianPartEntity enderdragonpartentity = null;
                    if (k == 0) {
                        enderdragonpartentity = this.dragonPartTail1;
                    }
                    if (k == 1) {
                        enderdragonpartentity = this.dragonPartTail2;
                    }
                    if (k == 2) {
                        enderdragonpartentity = this.dragonPartTail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, 1.0f);
                    float f7 = this.getYRot() * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f20 = Mth.sin((float)f7);
                    float f21 = Mth.cos((float)f7);
                    float f22 = 1.5f;
                    float f23 = (float)(k + 1) * 2.0f;
                    this.setPartPosition(enderdragonpartentity, -(f3 * 1.5f + f20 * f23) * f16, adouble1[1] - adouble[1] - (double)((f23 + 1.5f) * f2) + 1.5, (f18 * 1.5f + f21 * f23) * f16);
                }
                if (!this.level().isClientSide) {
                    this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.getBoundingBox()) | this.destroyBlocksInAABB(this.dragonPartNeck.getBoundingBox()) | this.destroyBlocksInAABB(this.dragonPartBody.getBoundingBox());
                    if (this.fightManager != null) {
                        this.fightManager.guardianUpdate(this);
                    }
                }
                for (int l = 0; l < this.dragonParts.length; ++l) {
                    this.dragonParts[l].xo = avector3d[l].x;
                    this.dragonParts[l].yo = avector3d[l].y;
                    this.dragonParts[l].zo = avector3d[l].z;
                    this.dragonParts[l].xOld = avector3d[l].x;
                    this.dragonParts[l].yOld = avector3d[l].y;
                    this.dragonParts[l].zOld = avector3d[l].z;
                }
            }
        }
    }

    private void setPartPosition(DraconicGuardianPartEntity part, double offsetX, double offsetY, double offsetZ) {
        part.setPos(this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ);
    }

    private float getHeadAndNeckYOffset() {
        if (this.phaseManager.getCurrentPhase().getIsStationary()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void updateDragonEnderCrystal() {
        if (this.closestGuardianCrystal != null) {
            if (!this.closestGuardianCrystal.isAlive()) {
                this.closestGuardianCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0 && !this.level().isClientSide) {
            if (this.fightManager != null) {
                this.closestGuardianCrystal = this.fightManager.getCrystals().stream().min(Comparator.comparingDouble(arg_0 -> ((DraconicGuardianEntity)this).distanceToSqr(arg_0))).orElse(null);
            } else {
                List list = this.level().getEntitiesOfClass(GuardianCrystalEntity.class, this.getBoundingBox().inflate(32.0));
                GuardianCrystalEntity crystal = null;
                double d0 = Double.MAX_VALUE;
                for (GuardianCrystalEntity endercrystalentity1 : list) {
                    double d1 = endercrystalentity1.distanceToSqr((Entity)this);
                    if (!(d1 < d0)) continue;
                    d0 = d1;
                    crystal = endercrystalentity1;
                }
                this.closestGuardianCrystal = crystal;
            }
            this.getEntityData().set(CRYSTAL_ID, (Object)(this.closestGuardianCrystal == null ? -1 : this.closestGuardianCrystal.getId()));
        }
    }

    private void collideWithEntities(List<Entity> entities) {
        double d0 = (this.dragonPartBody.getBoundingBox().minX + this.dragonPartBody.getBoundingBox().maxX) / 2.0;
        double d1 = (this.dragonPartBody.getBoundingBox().minZ + this.dragonPartBody.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().getIsStationary() || ((LivingEntity)entity).getLastHurtByMobTimestamp() >= entity.tickCount - 2) continue;
            entity.hurt(DEDamage.guardian(this.level(), (Entity)this), 15.0f);
            this.doEnchantDamageEffects((LivingEntity)this, entity);
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.hurt(DEDamage.guardian(this.level(), (Entity)this), 20.0f);
            this.doEnchantDamageEffects((LivingEntity)this, entity);
        }
    }

    private float simplifyAngle(double angle) {
        return (float)Mth.wrapDegrees((double)angle);
    }

    private boolean destroyBlocksInAABB(AABB area) {
        int i = Mth.floor((double)area.minX);
        int j = Mth.floor((double)area.minY);
        int k = Mth.floor((double)area.minZ);
        int l = Mth.floor((double)area.maxX);
        int i1 = Mth.floor((double)area.maxY);
        int j1 = Mth.floor((double)area.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.level().getBlockState(blockpos);
                    Block block = blockstate.getBlock();
                    if (blockstate.isAir() || blockstate.is(BlockTags.FIRE)) continue;
                    if (CommonHooks.canEntityDestroy((Level)this.level(), (BlockPos)blockpos, (LivingEntity)this) && !blockstate.is(BlockTags.DRAGON_IMMUNE) && block != Blocks.NETHER_BRICKS && block != Blocks.NETHER_BRICK_SLAB) {
                        flag1 = this.level().removeBlock(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.random.nextInt(l - i + 1), j + this.random.nextInt(i1 - j + 1), k + this.random.nextInt(j1 - k + 1));
            this.level().levelEvent(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean attackEntityPartFrom(DraconicGuardianPartEntity part, DamageSource source, float damage) {
        if (this.phaseManager.getCurrentPhase().getType() == PhaseType.DYING || source.getEntity() == this) {
            return false;
        }
        float shieldPower = this.getShieldPower();
        if (shieldPower > 0.0f) {
            BCoreNetwork.sendSound((Level)this.level(), (BlockPos)this.blockPosition(), (SoundEvent)((SoundEvent)DESounds.SHIELD_STRIKE.get()), (SoundSource)SoundSource.HOSTILE, (float)20.0f, (float)(this.random.nextFloat() * 0.2f + 0.9f), (boolean)false);
        }
        if (this.hitCoolDown > 0 && damage < this.lastDamage * 1.1f) {
            this.lastDamage = damage;
            return false;
        }
        this.lastDamage = damage;
        this.hitCoolDown = 5;
        if (this.fightManager != null && !this.fightManager.onGuardianAttacked(this, source, damage)) {
            this.phaseManager.getCurrentPhase().onAttacked(source, damage, shieldPower, false);
            return false;
        }
        damage = this.phaseManager.getCurrentPhase().onAttacked(source, damage, shieldPower, true);
        if (damage > 500.0f) {
            damage = 500.0f;
        }
        if ((shieldPower -= Math.min(shieldPower, damage)) > 0.0f) {
            this.setShieldPower(shieldPower);
            return true;
        }
        damage -= this.getShieldPower();
        this.setShieldPower(0.0f);
        if (damage > 100.0f) {
            damage = 100.0f;
        }
        if (part != this.dragonPartHead) {
            damage = damage / 4.0f + Math.min(damage, 1.0f);
        }
        if (damage < 0.01f) {
            return false;
        }
        if (source.getEntity() instanceof Player || source.is(DamageTypes.EXPLOSION)) {
            this.attackDragonFrom(source, damage);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().getIsStationary()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(PhaseType.DYING);
            }
        }
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        return this.level().isClientSide ? false : this.attackEntityPartFrom(this.dragonPartBody, source, amount);
    }

    protected boolean attackDragonFrom(DamageSource source, float amount) {
        return super.hurt(source, amount);
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        if (this.fightManager != null) {
            this.fightManager.guardianUpdate(this);
            this.fightManager.processDragonDeath(this);
        }
    }

    protected void tickDeath() {
        if (this.fightManager != null) {
            this.fightManager.guardianUpdate(this);
        }
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int xpAmount = 24000;
        if (!this.level().isClientSide) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && flag) {
                this.dropExperience(Mth.floor((float)((float)xpAmount * 0.08f)));
            }
            if (this.deathTicks == 1 && !this.isSilent()) {
                this.level().globalLevelEvent(1028, this.blockPosition(), 0);
            }
        }
        this.move(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        this.setYRot(this.getYRot() + 20.0f);
        this.yBodyRot = this.getYRot();
        if (this.deathTicks == 200 && !this.level().isClientSide) {
            if (flag) {
                this.dropExperience(Mth.floor((float)((float)xpAmount * 0.2f)));
            }
            if (this.fightManager != null) {
                this.fightManager.processDragonDeath(this);
            }
            this.discard();
        }
    }

    private void dropExperience(int xp) {
        while (xp > 0) {
            int i = ExperienceOrb.getExperienceValue((int)xp);
            xp -= i;
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY(), this.getZ(), i));
        }
    }

    public int initPathPoints(boolean regenerate) {
        if (this.pathPoints[0] == null || regenerate) {
            if (this.getArenaOrigin() == null) {
                this.setArenaOrigin(this.blockPosition());
            }
            BlockPos arenaOrigin = this.getArenaOrigin();
            for (int i = 0; i < 24; ++i) {
                float loopPos = (float)i / 24.0f;
                float angle = loopPos * 360.0f;
                int pointX = MathHelper.floor((double)(70.0 * Math.cos((double)angle * 0.017453292519943)));
                int pointZ = MathHelper.floor((double)(70.0 * Math.sin((double)angle * 0.017453292519943)));
                int pointY = Math.max(arenaOrigin.getY() + 40, this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(pointX, 0, pointZ)).getY());
                this.pathPoints[i] = new Node(arenaOrigin.getX() + pointX, pointY, arenaOrigin.getZ() + pointZ);
            }
        }
        return this.getNearestPpIdx(this.getX(), this.getY(), this.getZ());
    }

    public int getNearestPpIdx(double x, double y, double z) {
        float f = 10000.0f;
        int i = 0;
        Node pathpoint = new Node(Mth.floor((double)x), Mth.floor((double)y), Mth.floor((double)z));
        int j = 0;
        if (this.fightManager == null || this.fightManager.getNumAliveCrystals() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.pathPoints[k] == null || !((f1 = this.pathPoints[k].distanceToSqr(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @javax.annotation.Nullable
    public Path findPath(int startIdx, int finishIdx, @javax.annotation.Nullable Node andThen) {
        for (int i = 0; i < 24; ++i) {
            Node pathpoint = this.pathPoints[i];
            pathpoint.closed = false;
            pathpoint.f = 0.0f;
            pathpoint.g = 0.0f;
            pathpoint.h = 0.0f;
            pathpoint.cameFrom = null;
            pathpoint.heapIdx = -1;
        }
        Node startPoint = this.pathPoints[startIdx];
        Node endPoint = this.pathPoints[finishIdx];
        startPoint.g = 0.0f;
        startPoint.f = startPoint.h = startPoint.distanceTo(endPoint);
        this.pathFindQueue.clear();
        this.pathFindQueue.insert(startPoint);
        Node nextPoint = startPoint;
        int startIndex = 0;
        while (!this.pathFindQueue.isEmpty()) {
            Node testPoint = this.pathFindQueue.pop();
            if (testPoint.equals((Object)endPoint)) {
                if (andThen != null) {
                    andThen.cameFrom = endPoint;
                    endPoint = andThen;
                }
                return this.makePath(startPoint, endPoint);
            }
            if (testPoint.distanceToSqr(endPoint) < nextPoint.distanceToSqr(endPoint)) {
                nextPoint = testPoint;
            }
            testPoint.closed = true;
            for (int index = startIndex; index < 24; ++index) {
                Node pathpoint3 = this.pathPoints[index];
                if (pathpoint3.closed) continue;
                float f = testPoint.g + testPoint.distanceTo(pathpoint3);
                if (pathpoint3.inOpenSet() && !(f < pathpoint3.g)) continue;
                pathpoint3.cameFrom = testPoint;
                pathpoint3.g = f;
                pathpoint3.h = pathpoint3.distanceTo(endPoint);
                if (pathpoint3.inOpenSet()) {
                    this.pathFindQueue.changeCost(pathpoint3, pathpoint3.g + pathpoint3.h);
                    continue;
                }
                pathpoint3.f = pathpoint3.g + pathpoint3.h;
                this.pathFindQueue.insert(pathpoint3);
            }
        }
        if (nextPoint == startPoint) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)startIdx, (Object)finishIdx);
        if (andThen != null) {
            andThen.cameFrom = nextPoint;
            nextPoint = andThen;
        }
        return this.makePath(startPoint, nextPoint);
    }

    private Path makePath(Node start, Node finish) {
        ArrayList list = Lists.newArrayList();
        Node pathpoint = finish;
        list.add(0, finish);
        while (pathpoint.cameFrom != null) {
            pathpoint = pathpoint.cameFrom;
            list.add(0, pathpoint);
        }
        return new Path((List)list, new BlockPos(finish.x, finish.y, finish.z), true);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("dragon_phase", this.phaseManager.getCurrentPhase().getType().getId());
        if (this.getArenaOrigin() != null) {
            compound.put("arena_origin", (Tag)NbtUtils.writeBlockPos((BlockPos)this.getArenaOrigin()));
        }
        compound.putFloat("shield_power", this.getShieldPower());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("dragon_phase")) {
            this.phaseManager.setPhase(PhaseType.getById(compound.getInt("dragon_phase")));
        }
        if (compound.contains("arena_origin")) {
            this.setArenaOrigin(NbtUtils.readBlockPos((CompoundTag)compound.getCompound("arena_origin")));
        }
        if (this.level() instanceof ServerLevel) {
            this.fightManager = WorldEntityHandler.getWorldEntities().stream().filter(e -> e instanceof GuardianFightManager).map(e -> (GuardianFightManager)((Object)e)).filter(e -> this.getUUID().equals(e.getGuardianUniqueId())).findFirst().orElse(null);
            if (this.fightManager != null) {
                this.setArenaOrigin(this.fightManager.getArenaOrigin());
            }
        } else {
            this.fightManager = null;
        }
        if (compound.contains("shield_power", 5)) {
            this.setShieldPower(compound.getFloat("shield_power"));
        }
    }

    public void checkDespawn() {
    }

    public DraconicGuardianPartEntity[] getDragonParts() {
        return this.dragonParts;
    }

    public boolean isPickable() {
        return false;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    protected float getSoundVolume() {
        return 5.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadPartYOffset(int p_184667_1_, double[] spineEndOffsets, double[] headPartOffsets) {
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getType();
        double d0 = iphase.getIsStationary() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : headPartOffsets[1] - spineEndOffsets[1]);
        return (float)d0;
    }

    public void onCrystalAttacked(GuardianCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc, float damage, boolean destroyed) {
        Player playerentity = dmgSrc.getEntity() instanceof Player ? (Player)dmgSrc.getEntity() : this.level().getNearestPlayer(PLAYER_INVADER_CONDITION, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (crystal == this.closestGuardianCrystal && destroyed) {
            this.attackEntityPartFrom(this.dragonPartHead, this.damageSources().explosion((Entity)crystal, (Entity)playerentity), 20.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalAttacked(crystal, pos, dmgSrc, playerentity, damage, destroyed);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (PHASE.equals(key) && this.level().isClientSide) {
            this.phaseManager.setPhase(PhaseType.getById((Integer)this.getEntityData().get(PHASE)));
        } else if (CRYSTAL_ID.equals(key) && this.level().isClientSide) {
            Entity entity;
            int id = (Integer)this.getEntityData().get(CRYSTAL_ID);
            this.closestGuardianCrystal = id == -1 ? null : ((entity = this.level().getEntity(id)) instanceof GuardianCrystalEntity ? (GuardianCrystalEntity)entity : null);
        }
        super.onSyncedDataUpdated(key);
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @javax.annotation.Nullable
    public GuardianFightManager getFightManager() {
        return this.fightManager;
    }

    public boolean addEffect(MobEffectInstance effectInstanceIn, @Nullable Entity p_147209_) {
        if (effectInstanceIn.getEffect().isBeneficial()) {
            return super.addEffect(effectInstanceIn, p_147209_);
        }
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean canChangeDimensions() {
        return false;
    }

    @javax.annotation.Nullable
    public DraconicGuardianPartEntity[] getParts() {
        return this.dragonParts;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return super.getAddEntityPacket();
    }
}

