/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.particle.GuardianChargeParticle;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.handlers.DESounds;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class ChargeUpPhase
extends Phase {
    protected Map<Player, Vec3> trappedPlayers = new HashMap<Player, Vec3>();
    protected int requiredChargeTime;
    protected int chargeTime;
    protected int chargedTime;
    private int effectTimer = 0;
    private int effectTime = 0;
    public boolean disableFlight = false;
    public boolean trapPlayers = false;
    float speedMod;
    int offGroundTime = 0;

    public ChargeUpPhase(DraconicGuardianEntity guardian, int requiredChargeTime) {
        super(guardian);
        this.requiredChargeTime = requiredChargeTime;
    }

    @Override
    public boolean getIsStationary() {
        return true;
    }

    @Override
    public void initPhase() {
        this.chargeTime = 0;
        this.chargedTime = 0;
        this.effectTimer = 0;
    }

    @Override
    public void removeAreaEffect() {
        this.trappedPlayers.clear();
    }

    public void resetCharge() {
        this.chargeTime = 0;
    }

    @Override
    public void serverTick() {
        GuardianFightManager manager;
        BlockPos origin;
        GuardianFightManager manager2;
        if (this.trappedPlayers == null) {
            this.trappedPlayers = new HashMap<Player, Vec3>();
        }
        if (this.chargeTime < this.requiredChargeTime) {
            ++this.chargeTime;
        } else {
            ++this.chargedTime;
        }
        if (this.trapPlayers && this.isCharged() && (manager2 = this.guardian.getFightManager()) != null) {
            for (Player player : manager2.getTrackedPlayers()) {
                Vec3 vec3 = player.position();
                Vec3 lastPos = this.trappedPlayers.getOrDefault(player, player.position());
                Vec3 center = Vec3.atCenterOf((Vec3i)manager2.getArenaOrigin().offset(0, 16, 0));
                double currentDist = vec3.distanceToSqr(center);
                int threshold = 10000;
                int breakAway = 1000000;
                if (currentDist > (double)threshold && currentDist < (double)breakAway && lastPos.distanceToSqr(center) <= (double)threshold && player.level().dimension().equals(this.guardian.level().dimension())) {
                    TeleportUtils.teleportEntity((Entity)player, (ResourceKey)player.level().dimension(), (double)lastPos.x, (double)lastPos.y, (double)lastPos.z);
                }
                if (this.isValidTarget((LivingEntity)player) && player.getY() < (double)(manager2.getArenaOrigin().getY() - 10)) {
                    TeleportUtils.teleportEntity((Entity)player, (ResourceKey)player.level().dimension(), (double)player.getX(), (double)(manager2.getArenaOrigin().getY() + 15), (double)player.getZ());
                }
                if (!(player.position().distanceToSqr(center) < (double)threshold)) continue;
                this.trappedPlayers.put(player, player.position());
            }
        }
        if ((origin = this.guardian.getArenaOrigin()) == null) {
            return;
        }
        if (this.disableFlight && this.getChargeProgress() > 0.5 && (manager = this.guardian.getFightManager()) != null) {
            for (Player player : manager.getTrackedPlayers()) {
                if (!(player.getY() > (double)(origin.getY() + 8)) || !player.getAbilities().flying) continue;
                player.getAbilities().flying = false;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        double z;
        int i;
        if (this.chargeTime < this.requiredChargeTime) {
            ++this.chargeTime;
        } else {
            ++this.chargedTime;
        }
        BlockPos origin = this.guardian.getArenaOrigin();
        if (origin == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !this.isValidTarget((LivingEntity)player)) {
            return;
        }
        if (this.effectTimer == 0) {
            this.speedMod = (float)this.getChargeProgress();
            this.effectTime = this.effectTimer = (int)(20.0f - this.speedMod * 10.0f);
            this.guardian.level().playLocalSound(this.guardian.getX(), this.guardian.getY(), this.guardian.getZ(), (SoundEvent)DESounds.CRYSTAL_BEAM.get(), SoundSource.HOSTILE, 64.0f, 1.0f + this.speedMod, false);
            if (origin != null) {
                for (i = 0; i < 32; ++i) {
                    Minecraft.getInstance().particleEngine.add((Particle)new GuardianChargeParticle((ClientLevel)this.guardian.level(), Vector3.fromBlockPosCenter((BlockPos)origin), Vector3.fromEntity((Entity)this.guardian), (double)i / 32.0, this.effectTime, this.guardian.getPhaseManager()));
                }
            }
        } else {
            --this.effectTimer;
        }
        if (this.trapPlayers) {
            for (i = 0; i < 4; ++i) {
                float randDir = this.random.nextFloat() * (float)Math.PI * 2.0f;
                int randDist = 95 + this.random.nextInt(30);
                double x = this.guardian.getX() + (double)(Mth.sin((float)randDir) * (float)randDist);
                z = this.guardian.getZ() + (double)(Mth.cos((float)randDir) * (float)randDist);
                double y = this.guardian.getY() - 8.0 - (double)this.random.nextInt(32);
                Vector3 motion = new Vector3(this.guardian.getX(), y, this.guardian.getZ()).subtract(x, y, z).normalize().multiply((1.0 + this.random.nextDouble()) * this.getChargeProgress());
                this.guardian.level().addParticle((ParticleOptions)DEParticles.GUARDIAN_CLOUD.get(), true, x, y, z, motion.x, motion.y, motion.z);
            }
            Vector3 center = new Vector3(this.guardian.getX(), this.guardian.getY() - 32.0, this.guardian.getZ());
            int threshold = 85;
            if (!player.getAbilities().instabuild) {
                if (player.distanceToSqr(center.vec3()) > (double)(threshold * threshold)) {
                    double distanceOver = Math.sqrt(player.distanceToSqr(center.vec3())) - (double)threshold;
                    Vector3 forceVec = center.copy().subtract(player.getX(), player.getY(), player.getZ()).normalize().multiply(1.0 * (distanceOver / 10.0) * this.getChargeProgress());
                    this.debug(forceVec.toString());
                    player.setDeltaMovement(player.getDeltaMovement().add(forceVec.vec3()));
                }
                if (player.getY() < (double)origin.getY()) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, ((double)origin.getY() - player.getY()) / 5.0 * this.getChargeProgress(), 0.0));
                }
            }
        }
        if (this.disableFlight && player != null && !player.getAbilities().instabuild && this.getChargeProgress() > 0.5) {
            if (player.getY() > (double)(origin.getY() + 8)) {
                if (player.getAbilities().flying) {
                    player.getAbilities().flying = false;
                }
                if (player.isFallFlying()) {
                    Vec3 motion = player.getDeltaMovement();
                    player.setDeltaMovement(motion.x * 0.75, motion.y > 0.0 ? motion.y * 0.75 : motion.y, motion.z * 0.75);
                }
            }
            if (player.onGround() || player.getY() < (double)(origin.getY() + 8)) {
                this.offGroundTime = 0;
            } else {
                ++this.offGroundTime;
                if (this.offGroundTime > 40) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)Math.min(this.offGroundTime - 40, 200) / -100.0, 0.0));
                }
            }
            for (i = 0; i < 2; ++i) {
                double y;
                double x = this.guardian.getX() - 95.0 + (double)this.random.nextInt(190);
                if (!(this.guardian.distanceToSqr(x, y = this.guardian.getY() - (double)this.random.nextInt(35), z = this.guardian.getZ() - 95.0 + (double)this.random.nextInt(190)) < 10000.0)) continue;
                this.guardian.level().addParticle((ParticleOptions)DEParticles.GUARDIAN_CLOUD.get(), true, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public float animState() {
        return this.effectTimer > 0 ? (float)this.effectTimer / (float)this.effectTime : 0.0f;
    }

    public double getChargeProgress() {
        return (double)this.chargeTime / (double)this.requiredChargeTime;
    }

    public boolean isCharged() {
        return this.chargeTime >= this.requiredChargeTime;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        if (this.isInvulnerable()) {
            if (source.getDirectEntity() instanceof AbstractArrow) {
                source.getDirectEntity().setSecondsOnFire(1);
            }
            return 0.0f;
        }
        return super.onAttacked(source, damage, shield, effective);
    }

    @Override
    public void handlePacket(MCDataInput input, int func) {
        if (func == 0) {
            this.resetCharge();
        }
    }

    @Override
    public boolean isInvulnerable() {
        return true;
    }
}

