/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.render.DERenderTypes;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BinderHandler {
    public static Map<AABB, CCModel> modelCache = new HashMap<AABB, CCModel>();

    public static boolean onBinderUse(Player player, InteractionHand hand, Level world, BlockPos blockClicked, @Nonnull ItemStack binder, Direction sideClicked) {
        BlockEntity tile = world.getBlockEntity(blockClicked);
        boolean isBound = BinderHandler.isBound(binder);
        if (tile instanceof ICrystalLink && player.isShiftKeyDown()) {
            BinderHandler.bind(binder, blockClicked);
            if (world.isClientSide) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.pos_saved_to_tool").withStyle(ChatFormatting.GREEN), (UUID)TileCrystalBase.MSG_ID);
                player.swing(hand);
            }
            return true;
        }
        if (tile instanceof ICrystalLink && !isBound) {
            ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.tool_not_bound").withStyle(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
            return true;
        }
        if (isBound) {
            BlockPos boundLinkable = BinderHandler.getBound(binder);
            if (boundLinkable.equals((Object)blockClicked)) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.link_to_self").withStyle(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
                return true;
            }
            BlockEntity boundTile = world.getBlockEntity(boundLinkable);
            if (boundTile instanceof ICrystalLink) {
                if (((ICrystalLink)boundTile).binderUsed(player, blockClicked, sideClicked)) {
                    player.swing(hand);
                }
            } else {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.bound_to_invalid").withStyle(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
            }
            return true;
        }
        return false;
    }

    private static boolean isBound(ItemStack stack) {
        return stack.hasTag() && stack.getTag().contains("draconicevolution:binder", 11);
    }

    private static void bind(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.getCompound((ItemStack)stack).putIntArray("draconicevolution:binder", new int[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    private static BlockPos getBound(ItemStack stack) {
        int[] intArray = stack.getTag().getIntArray("draconicevolution:binder");
        return new BlockPos(intArray[0], intArray[1], intArray[2]);
    }

    public static boolean clearBinder(Player player, @Nonnull ItemStack stack) {
        if (stack.hasTag() && stack.getTag().contains("draconicevolution:binder")) {
            stack.getTag().remove("draconicevolution:binder");
            ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.pos_cleared"), (UUID)TileCrystalBase.MSG_ID);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWorldOverlay(LocalPlayer player, PoseStack pStack, Level world, ItemStack stack, Minecraft mc, float partialTicks) {
        if (!BinderHandler.isBound(stack)) {
            return;
        }
        BlockPos pos = BinderHandler.getBound(stack);
        boolean valid = world.getBlockEntity(pos) instanceof ICrystalLink;
        BlockState state = world.getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)world, pos);
        if (shape.isEmpty()) {
            shape = Shapes.block();
        }
        Cuboid6 cuboid6 = new Cuboid6(shape.bounds());
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        pStack.pushPose();
        pStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        pStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        RenderUtils.bufferCuboidSolid((VertexConsumer)new TransformingVertexConsumer(source.getBuffer(DERenderTypes.BOX_NO_DEPTH), pStack), (Cuboid6)cuboid6, (float)(valid ? 0.0f : 1.0f), (float)(valid ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
        source.endBatch();
        RenderUtils.bufferCuboidOutline((VertexConsumer)new TransformingVertexConsumer(source.getBuffer(DERenderTypes.OUTLINE_TYPE), pStack), (Cuboid6)cuboid6, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        source.endBatch();
        pStack.popPose();
    }

    private static CCModel modelForAABB(AABB aabb) {
        if (!modelCache.containsKey(aabb)) {
            modelCache.put(aabb, CCModel.newModel((VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)24).generateBlock(0, new Cuboid6(aabb)));
        }
        return modelCache.get(aabb);
    }
}

