/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.FlightData;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.FlightEntity;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.entities.UndyingEntity;
import com.brandon3055.draconicevolution.handlers.EntityAttributeHandler;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

public class ModularArmorEventHandler {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    public static final UUID WALK_SPEED_UUID = UUID.fromString("0ea6ce8e-d2e8-11e5-ab30-625662870761");
    public static final UUID STEP_HEIGHT_UUID = UUID.fromString("f4ccc2d7-477a-4610-bac0-b4de1a20e12f");
    public static final UUID FLY_SPEED_UUID = UUID.fromString("364320fe-5cba-48db-a28f-7f4f57422bf5");
    public static final EntityAttributeHandler<ArmorAbilities> ATTRIBUTE_HANDLER = new EntityAttributeHandler();
    public static Map<Player, Boolean> playersWithFlight = new WeakHashMap<Player, Boolean>();

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, ModularArmorEventHandler::onEntityAttacked);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, ModularArmorEventHandler::onEntityDamaged);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::onEntityFall);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, ModularArmorEventHandler::onEntityDeath);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::livingTick);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::onLivingJumpEvent);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, ModularArmorEventHandler::breakSpeed);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::onPlayerLogin);
        ATTRIBUTE_HANDLER.register(WALK_SPEED_UUID, () -> Attributes.MOVEMENT_SPEED, ModularArmorEventHandler::getWalkSpeedAttribute);
        ATTRIBUTE_HANDLER.register(FLY_SPEED_UUID, () -> Attributes.FLYING_SPEED, ModularArmorEventHandler::getFlightSpeedAttribute);
        ATTRIBUTE_HANDLER.register(STEP_HEIGHT_UUID, () -> ((Holder)NeoForgeMod.STEP_HEIGHT).value(), ModularArmorEventHandler::getStepHeight);
    }

    @Nullable
    private static AttributeModifier getWalkSpeedAttribute(LivingEntity entity, ArmorAbilities abilities) {
        if (abilities.data == null) {
            return null;
        }
        double speedModifier = abilities.data.speedMultiplier();
        if (entity.isSprinting() && abilities.speedSettingRun != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSettingRun);
        } else if (abilities.speedSetting != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSetting);
        }
        if (speedModifier > 0.0) {
            return new AttributeModifier(WALK_SPEED_UUID, Attributes.MOVEMENT_SPEED.getDescriptionId(), speedModifier, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        return null;
    }

    @Nullable
    private static AttributeModifier getFlightSpeedAttribute(LivingEntity entity, ArmorAbilities abilities) {
        if (abilities.data == null) {
            return null;
        }
        double speedModifier = abilities.data.speedMultiplier();
        if (entity.isSprinting() && abilities.speedSettingRun != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSettingRun);
        } else if (abilities.speedSetting != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSetting);
        }
        if (speedModifier > 0.0) {
            return new AttributeModifier(FLY_SPEED_UUID, Attributes.FLYING_SPEED.getDescriptionId(), speedModifier / 2.0, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        return null;
    }

    @Nullable
    private static AttributeModifier getStepHeight(LivingEntity entity, ArmorAbilities abilities) {
        ItemStack chestStack = IModularArmor.getArmor(entity);
        ModuleHost host = (ModuleHost)chestStack.getCapability(DECapabilities.Host.ITEM);
        boolean hasHost = !chestStack.isEmpty() && host != null;
        boolean hasHighStep = hasHost && host.getEntitiesByType(ModuleTypes.HILL_STEP).findAny().isPresent() && !entity.isShiftKeyDown();
        AttributeInstance instance = entity.getAttribute((Attribute)NeoForgeMod.STEP_HEIGHT.value());
        if (hasHighStep && instance != null) {
            double stepHeight = instance.getValue();
            if (stepHeight > 1.0 && instance.getModifier(STEP_HEIGHT_UUID) == null) {
                return null;
            }
            return new AttributeModifier(STEP_HEIGHT_UUID, ((Attribute)NeoForgeMod.STEP_HEIGHT.value()).getDescriptionId(), 1.0625 - stepHeight, AttributeModifier.Operation.ADDITION);
        }
        return null;
    }

    private static void onEntityAttacked(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.isCanceled() || event.getAmount() <= 0.0f || entity.level().isClientSide || event.getSource().is(DEDamage.KILL)) {
            return;
        }
        ItemStack chestStack = IModularArmor.getArmor(entity);
        ModuleHost host = (ModuleHost)chestStack.getCapability(DECapabilities.Host.ITEM);
        if (chestStack.isEmpty() || host == null) {
            return;
        }
        if (event.getAmount() == Float.MAX_VALUE && event.getSource().is(DamageTypes.FELL_OUT_OF_WORLD)) {
            event.setCanceled(true);
            entity.hurt(DEDamage.killDamage(entity.level()), 6.805647E37f);
            return;
        }
        if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
            return;
        }
        ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
        if (shieldControl == null) {
            return;
        }
        shieldControl.tryBlockDamage(event);
    }

    private static void onEntityDamaged(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.isCanceled() || event.getAmount() <= 0.0f || entity.level().isClientSide || event.getSource().is(DEDamage.KILL)) {
            return;
        }
        ItemStack chestStack = IModularArmor.getArmor(entity);
        ModuleHost host = (ModuleHost)chestStack.getCapability(DECapabilities.Host.ITEM);
        if (chestStack.isEmpty() || host == null) {
            return;
        }
        if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
            return;
        }
        ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
        if (shieldControl == null) {
            return;
        }
        shieldControl.tryBlockDamage(event);
    }

    private static void onEntityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, true);
        if (jumpBoost > 0.0f) {
            event.setDistance(Math.max(0.0f, event.getDistance() - (jumpBoost *= 2.0f)));
        }
    }

    private static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.isCanceled() || entity.level().isClientSide) {
            return;
        }
        ArrayList<UndyingEntity> undyingModules = new ArrayList<UndyingEntity>();
        if (entity instanceof Player) {
            EquipmentSlot[] player = (EquipmentSlot[])entity;
            NonNullList stacks = player.getInventory().items;
            for (int i = 0; i < stacks.size(); ++i) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)stacks.get(i), undyingModules, (EquipmentSlot)(player.getInventory().selected == i ? EquipmentSlot.MAINHAND : null), false);
            }
            for (EquipmentSlot slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)player.getInventory().armor.get(slot.getIndex()), undyingModules, slot, false);
            }
            for (ItemStack stack : player.getInventory().offhand) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, EquipmentSlot.OFFHAND, false);
            }
            for (ItemStack stack : EquipmentManager.getAllItems(entity)) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, null, true);
            }
        } else if (EquipmentManager.equipModLoaded()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ModularArmorEventHandler.getUndyingEntities(entity.getItemBySlot(slot), undyingModules, slot, true);
            }
        }
        if (undyingModules.isEmpty() || event.getSource().is(DEDamage.KILL)) {
            return;
        }
        boolean blocked = undyingModules.stream().sorted(Comparator.comparing(e -> e.getModule().getModuleTechLevel().index)).anyMatch(e -> e.tryBlockDeath(event));
        if (blocked) {
            event.setCanceled(true);
        }
    }

    private static void getUndyingEntities(ItemStack stack, List<UndyingEntity> entities, EquipmentSlot slot, boolean inEquipModSlot) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
        if (!stack.isEmpty() && stack.getItem() instanceof IModularItem && ((IModularItem)stack.getItem()).isEquipped(stack, slot, inEquipModSlot) && host != null) {
            entities.addAll(host.getModuleEntities().stream().filter(e -> e instanceof UndyingEntity).map(e -> (UndyingEntity)e).toList());
        }
    }

    private static void livingTick(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        ArmorAbilities armorAbilities = new ArmorAbilities();
        if (entity instanceof Player) {
            player = (Player)entity;
            NonNullList stacks = player.getInventory().items;
            for (int i = 0; i < stacks.size(); ++i) {
                ModularArmorEventHandler.tryTickStack((ItemStack)stacks.get(i), (LivingEntity)player, (EquipmentSlot)(player.getInventory().selected == i ? EquipmentSlot.MAINHAND : null), armorAbilities, false);
            }
            for (EquipmentSlot slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.tryTickStack((ItemStack)player.getInventory().armor.get(slot.getIndex()), (LivingEntity)player, slot, armorAbilities, false);
            }
            for (ItemStack stack2 : player.getInventory().offhand) {
                ModularArmorEventHandler.tryTickStack(stack2, (LivingEntity)player, EquipmentSlot.OFFHAND, armorAbilities, false);
            }
            if (EquipmentManager.equipModLoaded()) {
                EquipmentManager.findItems(e -> e.getItem() instanceof IModularItem, entity).forEach(stack -> ModularArmorEventHandler.tryTickStack(stack, (LivingEntity)player, null, armorAbilities, true));
            }
        } else {
            for (NonNullList slot : EquipmentSlot.values()) {
                ModularArmorEventHandler.tryTickStack(entity.getItemBySlot((EquipmentSlot)slot), entity, (EquipmentSlot)slot, armorAbilities, false);
            }
        }
        if (!entity.level().isClientSide() && TimeKeeper.getServerTick() % 10 == 0) {
            ATTRIBUTE_HANDLER.updateEntity(entity, armorAbilities);
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            boolean canFly = true;
            boolean noPower = false;
            if (armorAbilities.creativeFlight && armorAbilities.flightPower != null && !player.getAbilities().instabuild && !player.isSpectator()) {
                canFly = armorAbilities.flightPower.getOPStored() >= (long)EquipCfg.creativeFlightEnergy;
                boolean bl = noPower = !canFly;
                if (canFly && player.getAbilities().flying && !entity.level().isClientSide) {
                    armorAbilities.flightPower.modifyEnergyStored((long)(-EquipCfg.creativeFlightEnergy));
                }
            }
            if (armorAbilities.creativeFlight && canFly) {
                player.getAbilities().mayfly = true;
                playersWithFlight.put(player, true);
            } else {
                if (!playersWithFlight.containsKey(player)) {
                    playersWithFlight.put(player, false);
                }
                if (playersWithFlight.get(player).booleanValue() && !entity.level().isClientSide) {
                    playersWithFlight.put(player, false);
                    if (!player.getAbilities().instabuild && !player.isSpectator()) {
                        boolean wasFlying = player.getAbilities().flying;
                        player.getAbilities().mayfly = false;
                        player.getAbilities().flying = false;
                        player.onUpdateAbilities();
                        if (wasFlying && noPower) {
                            player.tryToStartFallFlying();
                        }
                    }
                }
                if (player.level().isClientSide && playersWithFlight.get(player).booleanValue()) {
                    playersWithFlight.put(player, false);
                    if (!player.getAbilities().instabuild) {
                        player.getAbilities().mayfly = false;
                        player.getAbilities().flying = false;
                    }
                }
            }
        }
    }

    private static float getJumpBoost(LivingEntity entity, boolean max) {
        JumpData jumpData;
        ItemStack chestStack = IModularArmor.getArmor(entity);
        ModuleHost host = (ModuleHost)chestStack.getCapability(DECapabilities.Host.ITEM);
        if (host != null && (jumpData = host.getModuleData(ModuleTypes.JUMP_BOOST)) != null) {
            double jump = jumpData.multiplier();
            if (max) {
                return (float)jump;
            }
            if (entity.isSprinting()) {
                if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("jump_boost_run")) {
                    jump = Math.min(jump, ((PropertyProvider)((Object)host)).getDecimal("jump_boost_run").getValue());
                }
            } else if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("jump_boost")) {
                jump = Math.min(jump, ((PropertyProvider)((Object)host)).getDecimal("jump_boost").getValue());
            }
            return (float)jump;
        }
        return 0.0f;
    }

    private static void tryTickStack(ItemStack stack, LivingEntity entity, EquipmentSlot slot, ArmorAbilities abilities, boolean equipMod) {
        if (stack.getItem() instanceof IModularItem) {
            ModuleHost host;
            ((IModularItem)stack.getItem()).handleTick(stack, entity, slot, equipMod);
            if ((slot != null && slot.getType() == EquipmentSlot.Type.ARMOR || equipMod) && (host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM)) != null) {
                ModularArmorEventHandler.gatherArmorProps(stack, host, entity, abilities);
            }
        }
    }

    private static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, false);
        if (jumpBoost > 0.0f && !entity.isShiftKeyDown()) {
            entity.push(0.0, (double)(0.1f * (jumpBoost + 1.0f)), 0.0);
        }
    }

    private static void breakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        float newDigSpeed = event.getOriginalSpeed();
        ItemStack chestStack = IModularArmor.getArmor((LivingEntity)player);
        ModuleHost host = (ModuleHost)chestStack.getCapability(DECapabilities.Host.ITEM);
        if (host == null) {
            return;
        }
        if (host.getModuleData(ModuleTypes.AQUA_ADAPT) != null && player.isEyeInFluid(FluidTags.WATER) && !EnchantmentHelper.hasAquaAffinity((LivingEntity)player)) {
            newDigSpeed *= 5.0f;
        }
        if (!player.onGround() && host.getModuleData(ModuleTypes.MINING_STABILITY) != null) {
            newDigSpeed *= 5.0f;
        }
        if (newDigSpeed != event.getOriginalSpeed()) {
            event.setNewSpeed(newDigSpeed);
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        FlightData flightData;
        Player player = event.getEntity();
        if (player.onGround()) {
            return;
        }
        ItemStack chestStack = IModularArmor.getArmor((LivingEntity)player);
        ModuleHost host = (ModuleHost)chestStack.getCapability(DECapabilities.Host.ITEM);
        if (host != null && (flightData = host.getModuleData(ModuleTypes.FLIGHT)) != null && flightData.creative()) {
            player.getAbilities().flying = true;
            player.onUpdateAbilities();
        }
    }

    private static void gatherArmorProps(ItemStack stack, ModuleHost host, LivingEntity entity, ArmorAbilities abilities) {
        FlightEntity flight;
        SpeedData speed = host.getModuleData(ModuleTypes.SPEED);
        if (speed != null) {
            abilities.addSpeedData(speed, host);
        }
        if ((flight = (FlightEntity)host.getEntitiesByType(ModuleTypes.FLIGHT).map(e -> (FlightEntity)e).findAny().orElse(null)) != null) {
            abilities.addFlightData(flight, (IOPStorage)stack.getCapability(CapabilityOP.ITEM));
        }
    }

    public static class ArmorAbilities {
        private double speedSetting = -1.0;
        private double speedSettingRun = -1.0;
        private SpeedData data;
        private boolean elytraFlight = false;
        private boolean creativeFlight = false;
        private IOPStorage flightPower = null;

        private void addSpeedData(SpeedData data, ModuleHost host) {
            SpeedData speedData = this.data = this.data == null ? data : this.data.combine(data);
            if (host instanceof PropertyProvider) {
                if (((PropertyProvider)((Object)host)).hasDecimal("run_speed")) {
                    if (this.speedSettingRun == -1.0) {
                        this.speedSettingRun = 0.0;
                    }
                    this.speedSettingRun += ((PropertyProvider)((Object)host)).getDecimal("run_speed").getValue();
                }
                if (((PropertyProvider)((Object)host)).hasDecimal("walk_speed")) {
                    if (this.speedSetting == -1.0) {
                        this.speedSetting = 0.0;
                    }
                    this.speedSetting += ((PropertyProvider)((Object)host)).getDecimal("walk_speed").getValue();
                }
            }
        }

        private void addFlightData(FlightEntity entity, IOPStorage flightPower) {
            this.elytraFlight = this.elytraFlight || entity.getElytraEnabled();
            boolean bl = this.creativeFlight = this.creativeFlight || entity.getCreativeEnabled();
            if (flightPower != null && (this.flightPower == null || flightPower.getOPStored() > this.flightPower.getOPStored())) {
                this.flightPower = flightPower;
            }
        }
    }
}

