/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public interface IModularMelee
extends IModularTieredItem,
IDraconicMelee {
    default public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
        float damage = (float)this.getAttackDamage(host, stack);
        long energyPerHit = (long)((float)EquipCfg.energyAttack * damage);
        this.extractEnergy(player, stack, energyPerHit);
        double aoe = (double)host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe() * 1.5;
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("attack_aoe")) {
            aoe = ((PropertyProvider)((Object)host)).getDecimal("attack_aoe").getValue();
        }
        float attackStrength = player.getAttackStrengthScale(0.5f);
        if (aoe > 0.0 && (double)attackStrength > 0.9) {
            this.dealAOEDamage(player, target, stack, energyPerHit, damage *= 0.2f + attackStrength * attackStrength * 0.8f, aoe);
        }
        return false;
    }

    default public void dealAOEDamage(Player player, Entity target, ItemStack stack, long energyPerHit, float damage, double aoe) {
        List entities = player.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(aoe, 0.25, aoe));
        double aoeAngle = 100.0;
        double yaw = player.getYRot() - 180.0f;
        int fireAspect = EnchantmentHelper.getFireAspect((LivingEntity)player);
        for (LivingEntity entity : entities) {
            if (this.getEnergyStored(stack) < energyPerHit && !player.getAbilities().instabuild) break;
            float distance = player.distanceTo((Entity)entity);
            if (entity == player || entity == target || player.isAlliedTo((Entity)entity) || distance < 1.0f || (double)entity.distanceTo(target) > aoe) continue;
            double angle = Math.atan2(player.getX() - entity.getX(), player.getZ() - entity.getZ()) * 57.29577951308232;
            double relativeAngle = Math.abs((angle + yaw) % 360.0);
            if (relativeAngle <= aoeAngle / 2.0 || relativeAngle > 360.0 - aoeAngle / 2.0) {
                boolean lit = false;
                float health = entity.getHealth();
                if (fireAspect > 0 && !entity.isOnFire()) {
                    lit = true;
                    entity.setSecondsOnFire(1);
                }
                if (entity.hurt(entity.level().damageSources().playerAttack(player), damage)) {
                    int k;
                    float damageDealt = health - entity.getHealth();
                    entity.knockback((double)0.4f, MathHelper.sin((double)((double)player.getYRot() * 0.017453292519943)), -MathHelper.cos((double)((double)player.getYRot() * 0.017453292519943)));
                    if (fireAspect > 0) {
                        entity.setSecondsOnFire(fireAspect * 4);
                    }
                    if (player.level() instanceof ServerLevel && damageDealt > 2.0f) {
                        k = (int)((double)damage * 0.5);
                        ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, entity.getX(), entity.getY(0.5), entity.getZ(), k, 0.1, 0.0, 0.1, 0.2);
                    }
                    player.awardStat(Stats.DAMAGE_DEALT, Math.round(damageDealt * 10.0f));
                    if (player.level() instanceof ServerLevel && damageDealt > 2.0f) {
                        k = (int)((double)damageDealt * 0.5);
                        ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, entity.getX(), entity.getY(0.5), entity.getZ(), k, 0.1, 0.0, 0.1, 0.2);
                    }
                } else if (lit) {
                    entity.clearFire();
                }
            }
            this.extractEnergy(player, stack, energyPerHit);
        }
    }
}

