/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.CommonHooks;

public interface IModularMiningTool
extends IModularTieredItem {
    public static final Random rand = new Random();

    default public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (this.getEnergyStored(stack) < (long)EquipCfg.energyHarvest && !player.getAbilities().instabuild) {
            return false;
        }
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
        int aoe = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe();
        boolean aoeSafe = false;
        if (host instanceof PropertyProvider) {
            if (((PropertyProvider)((Object)host)).hasInt("mining_aoe")) {
                aoe = ((PropertyProvider)((Object)host)).getInt("mining_aoe").getValue();
            }
            if (((PropertyProvider)((Object)host)).hasBool("aoe_safe")) {
                aoeSafe = ((PropertyProvider)((Object)host)).getBool("aoe_safe").getValue();
            }
        }
        return this.breakAOEBlocks(host, stack, pos, aoe, 0, player, aoeSafe);
    }

    default public boolean breakAOEBlocks(ModuleHost host, ItemStack stack, BlockPos pos, int breakRadius, int breakDepth, Player player, boolean aoeSafe) {
        BlockState blockState = player.level().getBlockState(pos);
        if (!this.isCorrectToolForDrops(stack, blockState)) {
            return false;
        }
        InventoryDynamic inventoryDynamic = new InventoryDynamic();
        float refStrength = IModularMiningTool.blockStrength(blockState, player, player.level(), pos);
        Pair<BlockPos, BlockPos> aoe = this.getMiningArea(pos, player, breakRadius, breakDepth);
        List<BlockPos> aoeBlocks = BlockPos.betweenClosedStream((BlockPos)((BlockPos)aoe.key()), (BlockPos)((BlockPos)aoe.value())).map(BlockPos::new).toList();
        if (aoeSafe) {
            for (BlockPos block2 : aoeBlocks) {
                if (player.level().isEmptyBlock(block2) || player.level().getBlockEntity(block2) == null) continue;
                if (player.level().isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)"item_prop.draconicevolution.aoe_safe.blocked"));
                } else {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)player.level(), block2));
                }
                return true;
            }
        }
        aoeBlocks.forEach(block -> this.breakAOEBlock(stack, player.level(), (BlockPos)block, player, refStrength, inventoryDynamic, rand.nextInt(Math.max(5, breakRadius * breakDepth / 5)) == 0));
        List items = player.level().getEntitiesOfClass(ItemEntity.class, new AABB((BlockPos)aoe.key()));
        for (ItemEntity item : items) {
            if (player.level().isClientSide || !item.isAlive()) continue;
            InventoryUtils.insertItem((Container)inventoryDynamic, (ItemStack)item.getItem(), (boolean)false);
            item.discard();
        }
        ModuleHelper.handleItemCollection(player, host, EnergyUtils.getStorage((ItemStack)stack), inventoryDynamic);
        return true;
    }

    public static float blockStrength(BlockState state, Player player, Level world, BlockPos pos) {
        float hardness = state.getDestroySpeed((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!CommonHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    default public Pair<BlockPos, BlockPos> getMiningArea(BlockPos pos, Player player, int breakRadius, int breakDepth) {
        BlockHitResult traceResult = RayTracer.retrace((Player)player);
        if (traceResult.getType() == HitResult.Type.MISS) {
            return new Pair((Object)pos, (Object)pos);
        }
        int sideHit = traceResult.getDirection().get3DDataValue();
        int xMax = breakRadius;
        int xMin = breakRadius;
        int yMax = breakRadius;
        int yMin = breakRadius;
        int zMax = breakRadius;
        int zMin = breakRadius;
        int yOffset = 0;
        switch (sideHit) {
            case 0: {
                yMax = breakDepth;
                yMin = 0;
                zMax = breakRadius;
                break;
            }
            case 1: {
                yMin = breakDepth;
                yMax = 0;
                zMax = breakRadius;
                break;
            }
            case 2: {
                xMax = breakRadius;
                zMin = 0;
                zMax = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 3: {
                xMax = breakRadius;
                zMax = 0;
                zMin = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 4: {
                xMax = breakDepth;
                xMin = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
                break;
            }
            case 5: {
                xMin = breakDepth;
                xMax = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
            }
        }
        if (breakRadius == 0) {
            yOffset = 0;
        }
        return new Pair((Object)pos.offset(-xMin, yOffset - yMin, -zMin), (Object)pos.offset(xMax, yOffset + yMax, zMax));
    }

    default public void breakAOEBlock(ItemStack stack, Level world, BlockPos pos, Player player, float refStrength, InventoryDynamic inventory, boolean breakFX) {
        if (world.isEmptyBlock(pos)) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        FluidState fluidState = world.getFluidState(pos);
        Block block = state.getBlock();
        if (!this.isCorrectToolForDrops(stack, state)) {
            return;
        }
        float strength = IModularMiningTool.blockStrength(state, player, world, pos);
        if (!CommonHooks.isCorrectToolForDrops((BlockState)state, (Player)player) || refStrength / strength > 10.0f) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int xp = CommonHooks.onBlockBreakEvent((Level)world, (GameType)serverPlayer.gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
            if (xp == -1) {
                ServerPlayer mpPlayer = (ServerPlayer)player;
                mpPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
                return;
            }
            if (player.getAbilities().instabuild) {
                if (block.onDestroyedByPlayer(state, world, pos, player, false, fluidState)) {
                    block.destroy((LevelAccessor)world, pos, state);
                }
            } else {
                stack.mineBlock(world, state, pos, player);
                BlockToStackHelper.breakAndCollectWithPlayer((Level)world, (BlockPos)pos, (InventoryDynamic)inventory, (Player)player, (int)xp);
                this.extractEnergy(player, stack, EquipCfg.energyHarvest);
            }
        } else {
            if (block.onDestroyedByPlayer(state, world, pos, player, true, fluidState)) {
                block.destroy((LevelAccessor)world, pos, state);
            }
            stack.mineBlock(world, state, pos, player);
            if (Minecraft.getInstance().hitResult instanceof BlockHitResult) {
                Minecraft.getInstance().getConnection().send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, ((BlockHitResult)Minecraft.getInstance().hitResult).getDirection()));
            }
        }
    }
}

