/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class ModularHoe
extends HoeItem
implements IModularTieredItem,
IDraconicMelee,
IModularEnergyItem {
    private final TechLevel techLevel;
    private final DETier itemTier;

    public ModularHoe(DETier tier, TechProperties props) {
        super((Tier)tier, 0, 0.0f, (Item.Properties)props);
        this.techLevel = props.getTechLevel();
        this.itemTier = (DETier)this.getTier();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DETier getItemTier() {
        return this.itemTier;
    }

    @Override
    public double getSwingSpeedMultiplier() {
        return EquipCfg.hoeSwingSpeedMultiplier;
    }

    @Override
    public double getDamageMultiplier() {
        return EquipCfg.hoeDamageMultiplier;
    }

    @Override
    public ModuleHost createHostCapForRegistration(ItemStack stack) {
        ModuleHost host = IModularTieredItem.super.createHostCapForRegistration(stack);
        if (host instanceof ModuleHostImpl) {
            ModuleHostImpl provider = (ModuleHostImpl)host;
            provider.addPropertyBuilder(props -> {
                AOEData aoe = host.getModuleData(ModuleTypes.AOE);
                if (aoe != null) {
                    props.add(new IntegerProperty("tool_aoe", aoe.aoe()).range(0, aoe.aoe()).setFormatter(ConfigProperty.IntegerFormatter.AOE));
                }
            });
        }
        return host;
    }

    @Override
    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "hoe", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.TOOL_HOE);
        return host;
    }

    @Override
    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack stack, Supplier<ModuleHost> hostSupplier) {
        return new ModularOPStorage(hostSupplier, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @Override
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return IModularTieredItem.super.getDestroySpeed(stack, state);
    }

    @Override
    public float getBaseEfficiency() {
        return this.getTier().getSpeed();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean canBeHurtBy(DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
        assert (host != null);
        int aoe = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe();
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasInt("tool_aoe")) {
            aoe = ((PropertyProvider)((Object)host)).getInt("tool_aoe").getValue();
        }
        Level level = context.getLevel();
        if (!this.attemptTillOp(context) && !level.getBlockState(context.getClickedPos()).is(Blocks.FARMLAND)) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        if (player == null || player.isShiftKeyDown()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos origin = context.getClickedPos();
        int aoe_range = aoe;
        BlockToStackHelper.startItemCapture();
        for (BlockPos aoePos : BlockPos.betweenClosed((BlockPos)origin.offset(-aoe_range, 0, -aoe_range), (BlockPos)origin.offset(aoe_range, 0, aoe_range))) {
            boolean up2OK;
            boolean canceled;
            boolean lowerBlockOk;
            if (aoePos.equals((Object)origin)) continue;
            BlockState aoeState = level.getBlockState(aoePos);
            boolean airOrReplaceable = level.isEmptyBlock(aoePos) || aoeState.is(BlockTags.REPLACEABLE);
            boolean bl = lowerBlockOk = level.getBlockState(aoePos.below()).isFaceSturdy((BlockGetter)level, aoePos.below(), Direction.UP, SupportType.CENTER) || level.getBlockState(aoePos.below()).is(Blocks.FARMLAND);
            if (airOrReplaceable && lowerBlockOk && (player.getAbilities().instabuild || player.getInventory().contains(new ItemStack((ItemLike)Items.DIRT))) && !(canceled = EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)aoePos), (Direction)Direction.UP)) && (player.getAbilities().instabuild || this.consumeItem(Items.DIRT, player.getInventory()))) {
                level.setBlockAndUpdate(aoePos, Blocks.DIRT.defaultBlockState());
            }
            boolean canDropAbove = level.getBlockState(aoePos.above()).is(Blocks.DIRT) || level.getBlockState(aoePos.above()).is(Blocks.GRASS_BLOCK) || level.getBlockState(aoePos.above()).is(Blocks.FARMLAND);
            boolean canRemoveAbove = canDropAbove || level.getBlockState(aoePos.above()).is(BlockTags.REPLACEABLE);
            boolean bl2 = up2OK = level.isEmptyBlock(aoePos.above().above()) || level.getBlockState(aoePos.above().above()).is(BlockTags.REPLACEABLE);
            if (!level.isEmptyBlock(aoePos.above()) && canRemoveAbove && up2OK) {
                if (!level.isClientSide && canDropAbove) {
                    level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)Blocks.DIRT)));
                }
                level.removeBlock(aoePos.above(), false);
            }
            this.attemptTillOp(ModularHoe.updateContext(context, aoePos));
        }
        Set drops = BlockToStackHelper.collectAndEndCapture();
        if (!level.isClientSide) {
            for (ItemStack drop : drops) {
                ItemUtils.dropItem((ItemStack)drop, (Level)level, (Vector3)Vector3.fromEntityCenter((Entity)player));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean attemptTillOp(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(blockpos = context.getClickedPos()).getToolModifiedState(context, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)ModularHoe.changeIntoState((BlockState)toolModifiedState));
        if (pair == null) {
            return false;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.getPlayer();
            level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                consumer.accept(context);
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, p_150845_ -> p_150845_.broadcastBreakEvent(context.getHand()));
                }
            }
            return true;
        }
        return false;
    }

    public boolean consumeItem(Item target, Inventory inventory) {
        for (ItemStack item : inventory.items) {
            if (item.isEmpty() || !item.is(target)) continue;
            item.shrink(1);
            inventory.setChanged();
            return true;
        }
        return false;
    }

    private static UseOnContext updateContext(UseOnContext context, BlockPos newPos) {
        BlockPos pos = context.getClickedPos();
        Vec3 newLocation = context.getClickLocation().add((double)(newPos.getX() - pos.getX()), (double)(newPos.getY() - pos.getY()), (double)(newPos.getZ() - pos.getZ()));
        return new UseOnContext(context.getLevel(), context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(newLocation, context.getClickedFace(), newPos, context.isInside()));
    }
}

