/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;

public abstract class ConfigProperty
implements INBTSerializable<CompoundTag> {
    private String name;
    private Supplier<Component> displayName;
    private Supplier<Component> toolTip;
    private boolean showOnHud = true;
    private String modid = "draconicevolution";
    private UUID uniqueName = null;

    public ConfigProperty(String name) {
        this.name = name;
    }

    public ConfigProperty(String name, Component displayName) {
        this.name = name;
        this.displayName = () -> displayName;
    }

    public void setDisplayName(Supplier<Component> displayName) {
        this.displayName = displayName;
    }

    public void setToolTip(Supplier<Component> toolTip) {
        this.toolTip = toolTip;
    }

    public Component getDisplayName() {
        return this.displayName == null ? Component.translatable((String)("item_prop.draconicevolution." + this.name)) : this.displayName.get();
    }

    public Component getToolTip() {
        return this.toolTip == null ? Component.translatable((String)("item_prop.draconicevolution." + this.name + ".info")) : this.toolTip.get();
    }

    public abstract String getDisplayValue();

    public String getName() {
        return this.uniqueName == null ? this.name : this.uniqueName.toString();
    }

    public void generateUnique() {
        this.uniqueName = UUID.randomUUID();
    }

    public UUID getUniqueName() {
        return this.uniqueName;
    }

    public abstract void onValueChanged(ItemStack var1);

    public abstract void validateValue();

    public abstract Type getType();

    public boolean showOnHud() {
        return this.showOnHud;
    }

    public void setShowOnHud(boolean showOnHud) {
        this.showOnHud = showOnHud;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("hud", this.showOnHud);
        if (this.uniqueName != null) {
            nbt.putUUID("uni_name", this.uniqueName);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.showOnHud = nbt.getBoolean("hud");
        if (nbt.hasUUID("uni_name")) {
            this.uniqueName = nbt.getUUID("uni_name");
        }
    }

    @Deprecated
    public void serializeMCData(MCDataOutput output) {
        output.writeBoolean(this.showOnHud);
    }

    @Deprecated
    public void deSerializeMCData(MCDataInput input) {
        this.showOnHud = input.readBoolean();
    }

    public abstract void loadData(PropertyData var1, ItemStack var2);

    public static enum DecimalFormatter {
        RAW_0(e -> String.valueOf(e.intValue())),
        RAW_1(e -> String.format("%.1f", e)),
        RAW_2(e -> String.format("%.2f", e)),
        RAW_3(e -> String.format("%.3f", e)),
        RAW_4(e -> String.format("%.4f", e)),
        PERCENT_0(e -> String.format("%.0f%%", e * 100.0)),
        PERCENT_1(e -> String.format("%.1f%%", e * 100.0)),
        PERCENT_2(e -> String.format("%.2f%%", e * 100.0)),
        PLUS_PERCENT_0(e -> String.format("+%.0f%%", e * 100.0)),
        PLUS_PERCENT_1(e -> String.format("+%.1f%%", e * 100.0)),
        PLUS_PERCENT_2(e -> String.format("+%.2f%%", e * 100.0)),
        AOE_0(e -> String.format("%.0fx%.0f", 1.0 + e * 2.0, 1.0 + e * 2.0)),
        AOE_1(e -> String.format("%.1fx%.1f", 1.0 + e * 2.0, 1.0 + e * 2.0)),
        AOE_2(e -> String.format("%.2fx%.2f", 1.0 + e * 2.0, 1.0 + e * 2.0));

        private Function<Double, String> formatter;

        private DecimalFormatter(Function<Double, String> formatter) {
            this.formatter = formatter;
        }

        public String format(double value) {
            return this.formatter.apply(value);
        }

        public static DecimalFormatter getSafe(int index) {
            return index >= 0 && index < DecimalFormatter.values().length ? DecimalFormatter.values()[index] : RAW_1;
        }
    }

    public static enum IntegerFormatter {
        RAW(String::valueOf),
        AOE(e -> String.format("%sx%s", 1 + e * 2, 1 + e * 2));

        private Function<Integer, String> formatter;

        private IntegerFormatter(Function<Integer, String> formatter) {
            this.formatter = formatter;
        }

        public String format(int value) {
            return this.formatter.apply(value);
        }

        public static IntegerFormatter getSafe(int index) {
            return index >= 0 && index < IntegerFormatter.values().length ? IntegerFormatter.values()[index] : RAW;
        }
    }

    public static enum BooleanFormatter {
        TRUE_FALSE(e -> I18n.get((String)("gui.draconicevolution.boolean_property." + (e != false ? "true" : "false")), (Object[])new Object[0])),
        ENABLED_DISABLED(e -> I18n.get((String)("gui.draconicevolution.boolean_property." + (e != false ? "enabled" : "disabled")), (Object[])new Object[0])),
        ACTIVE_INACTIVE(e -> I18n.get((String)("gui.draconicevolution.boolean_property." + (e != false ? "active" : "inactive")), (Object[])new Object[0])),
        YES_NO(e -> I18n.get((String)("gui.draconicevolution.boolean_property." + (e != false ? "yes" : "no")), (Object[])new Object[0]));

        private Function<Boolean, String> formatter;

        private BooleanFormatter(Function<Boolean, String> formatter) {
            this.formatter = formatter;
        }

        public String format(boolean value) {
            return this.formatter.apply(value);
        }

        public static BooleanFormatter getSafe(int index) {
            return index >= 0 && index < BooleanFormatter.values().length ? BooleanFormatter.values()[index] : TRUE_FALSE;
        }
    }

    public static enum Type {
        BOOLEAN,
        INTEGER,
        DECIMAL,
        ENUM;


        public static Type getSafe(int index) {
            return index >= 0 && index < Type.values().length ? Type.values()[index] : BOOLEAN;
        }
    }
}

