/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class EnumProperty<T extends Enum<T>>
extends ConfigProperty {
    private T value;
    private Function<T, String> displayFormatter = String::valueOf;
    private BiConsumer<ItemStack, EnumProperty<T>> changeListener = null;
    private List<T> allowedValues;

    public EnumProperty(String name, T defaultValue) {
        super(name);
        this.value = defaultValue;
        this.allowedValues = Arrays.asList((Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants());
    }

    public EnumProperty(String name, Component displayName, T defaultValue) {
        super(name, displayName);
        this.value = defaultValue;
        this.allowedValues = Arrays.asList((Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants());
    }

    public EnumProperty<T> setAllowedValues(List<T> allowedValues) {
        this.allowedValues = allowedValues;
        this.validateValue();
        return this;
    }

    public EnumProperty<T> setAllowedValues(T ... allowedValues) {
        this.allowedValues = Arrays.asList(allowedValues);
        this.validateValue();
        return this;
    }

    public List<T> getAllowedValues() {
        return this.allowedValues;
    }

    public Map<Integer, String> generateValueDisplayMap() {
        return this.allowedValues.stream().collect(Collectors.toMap(Enum::ordinal, e -> this.displayFormatter.apply((Enum)e)));
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public String getDisplayValue() {
        return this.displayFormatter.apply(this.getValue());
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
        if (!this.allowedValues.contains(this.value) && !this.allowedValues.isEmpty()) {
            this.value = (Enum)this.allowedValues.get(0);
        }
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.ENUM;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.run();
    }

    public void setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.accept((ItemStack)stack);
    }

    public void setChangeListener(BiConsumer<ItemStack, EnumProperty<T>> changeListener) {
        this.changeListener = changeListener;
    }

    public void setValueFormatter(Function<T, String> displayFormatter) {
        this.displayFormatter = displayFormatter;
    }

    public Function<T, String> getDisplayFormatter() {
        return this.displayFormatter;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.putByte("value", (byte)((Enum)this.value).ordinal());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        try {
            Enum newValue;
            if (nbt.contains("value") && this.allowedValues.contains(newValue = ((Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants())[nbt.getByte("value")])) {
                this.value = newValue;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.deserializeNBT(nbt);
    }

    @Override
    public void serializeMCData(MCDataOutput output) {
        super.serializeMCData(output);
        output.writeEnum(this.value);
    }

    @Override
    public void deSerializeMCData(MCDataInput input) {
        super.deSerializeMCData(input);
        Enum newValue = input.readEnum(((Enum)this.value).getDeclaringClass());
        if (this.allowedValues.contains(newValue)) {
            this.value = newValue;
        }
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        try {
            Enum newValue = ((Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants())[data.enumValueIndex];
            if (this.getAllowedValues().contains(newValue)) {
                this.value = newValue;
                this.onValueChanged(stack);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

