/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PropertyProviderImpl
implements PropertyProvider {
    private UUID identity = null;
    private String providerName;
    private Map<String, ConfigProperty> propertyMap = new HashMap<String, ConfigProperty>();

    public PropertyProviderImpl(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public UUID getIdentity() {
        if (this.identity == null) {
            this.regenIdentity();
        }
        return this.identity;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void regenIdentity() {
        this.identity = UUID.randomUUID();
    }

    @Override
    public Collection<ConfigProperty> getProperties() {
        return this.propertyMap.values();
    }

    @Override
    @Nullable
    public ConfigProperty getProperty(String propertyID) {
        return this.propertyMap.get(propertyID);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("identity", this.getIdentity());
        CompoundTag properties = new CompoundTag();
        this.propertyMap.forEach((name, property) -> properties.put(name, (Tag)property.serializeNBT()));
        nbt.put("properties", (Tag)properties);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.hasUUID("identity")) {
            this.identity = nbt.getUUID("identity");
        }
        CompoundTag properties = nbt.getCompound("properties");
        this.propertyMap.forEach((name, property) -> property.deserializeNBT(properties.getCompound(name)));
    }
}

