/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiItemStack;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiScrolling;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.geometry.Align;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiDialogBase;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.client.ModuleTextures;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class FilteredModuleEntity<T extends ModuleData<T>>
extends ModuleEntity<T> {
    protected BooleanProperty filterEnabled;
    protected IntObjectMap<ItemStack> filterStacks = new IntObjectHashMap();
    protected IntObjectMap<TagKey<Item>> filterTags = new IntObjectHashMap();
    protected final int slotsCount;

    public FilteredModuleEntity(Module<T> module, int slotsCount) {
        super(module);
        this.slotsCount = slotsCount;
        this.savePropertiesToItem = true;
    }

    protected void addEnabledProperty(String moduleName, boolean includeFilter) {
        this.filterEnabled = new BooleanProperty(moduleName + ".enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
        this.addProperty(this.filterEnabled);
        if (includeFilter) {
            Function<Boolean, Component> nameGen = trim -> {
                MutableComponent component = Component.translatable((String)("item_prop.draconicevolution." + moduleName + ".enabled"));
                boolean first = true;
                for (int i = 0; i < this.slotsCount; ++i) {
                    String append = null;
                    if (this.filterTags.containsKey(i)) {
                        append = ((TagKey)this.filterTags.get(i)).location().toString();
                    } else if (this.filterStacks.containsKey(i)) {
                        append = ((ItemStack)this.filterStacks.get(i)).getHoverName().getString();
                    }
                    if (append == null) continue;
                    if (trim.booleanValue()) {
                        int trimLen = Math.min(18, 32 - component.getString().length());
                        if (trimLen <= 0) break;
                        append = Utils.trimString((String)append, (int)trimLen, (String)"...");
                    }
                    if (first) {
                        component.append(": ");
                        first = false;
                    } else {
                        component.append(", ");
                    }
                    component.append((Component)Component.literal((String)append).withStyle(ChatFormatting.GRAY));
                }
                return component;
            };
            this.filterEnabled.setDisplayName(() -> (Component)nameGen.apply(true));
            this.filterEnabled.setToolTip(() -> (Component)nameGen.apply(false));
        }
    }

    protected abstract List<Slot> layoutSlots(int var1, int var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract Material getSlotOverlay();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        if (this.slotsCount == 0) {
            super.renderModule(parent, render, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
            return;
        }
        float dist = (float)Utils.distToRect((double)x, (double)y, (double)width, (double)height, (double)mouseX, (double)mouseY);
        float alpha = dist <= 10.0f ? dist / 10.0f : 1.0f;
        render.pose().pushPose();
        List<Slot> slots = this.layoutSlots(x, y, width, height);
        if (alpha < 1.0f) {
            Material slotTex = BCGuiTextures.getThemed((String)"slot");
            Material overlayTex = this.getSlotOverlay();
            for (Slot slot : slots) {
                render.texRect(slotTex, slot.x, slot.y, slot.size, slot.size);
                if (overlayTex == null || this.filterStacks.containsKey(slot.index)) continue;
                render.texRect(overlayTex, slot.x, slot.y, slot.size, slot.size);
            }
            render.pose().translate(0.0f, 0.0f, 100.0f);
            for (Slot slot : slots) {
                ItemStack stack = (ItemStack)this.filterStacks.getOrDefault((Object)slot.index, (Object)ItemStack.EMPTY);
                if (this.filterTags.containsKey(slot.index)) {
                    ArrayList matchingItems = FastStream.of((Iterable)BuiltInRegistries.ITEM.getTagOrEmpty((TagKey)this.filterTags.get(slot.index))).map(Holder::value).toList();
                    stack = new ItemStack((ItemLike)matchingItems.get(TimeKeeper.getClientTick() / 10 % matchingItems.size()));
                }
                double itemX = slot.x + slot.size / 16.0;
                double itemY = slot.y + slot.size / 16.0;
                double itemSize = slot.size - slot.size / 16.0 * 2.0;
                if (!stack.isEmpty()) {
                    render.renderItem(stack, itemX, itemY, itemSize);
                }
                if (!GuiRender.isInRect((double)slot.x, (double)slot.y, (double)slot.size, (double)slot.size, (double)mouseX, (double)mouseY)) continue;
                render.pose().translate(0.0f, 0.0f, 100.0f);
                render.rect(itemX, itemY, itemSize, itemSize, -2130706433);
                render.pose().translate(0.0f, 0.0f, -100.0f);
            }
            render.pose().translate(0.0f, 0.0f, 100.0f);
        } else if (renderStack) {
            render.pose().translate(0.0f, 0.0f, 200.0f);
        }
        if (alpha > 0.0f) {
            int bgColour = this.getModuleColour(this.module) & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            render.rect((double)x, (double)y, (double)width, (double)height, bgColour);
            render.borderRect((double)x, (double)y, (double)width, (double)height, 1.0, bgColour, GuiRender.mixColours((int)bgColour, (int)0x20202000, (boolean)true));
            Material texture = ModuleTextures.get(this.module);
            TextureAtlasSprite sprite = texture.sprite();
            float ar = (float)sprite.contents().width() / (float)sprite.contents().height();
            float iar = (float)sprite.contents().height() / (float)sprite.contents().width();
            if (iar * (float)width <= (float)height) {
                double h = (float)width * iar;
                render.texRect(texture, (double)x, (double)y + (double)height / 2.0 - h / 2.0, (double)width, h, 1.0f, 1.0f, 1.0f, alpha);
            } else {
                double w = (float)height * ar;
                render.texRect(texture, (double)x + (double)width / 2.0 - w / 2.0, (double)y, w, (double)height, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderModuleOverlay(GuiElement<?> parent, ModuleContext context, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, float partialTicks, int hoverTicks) {
        if (this.slotsCount == 0) {
            return super.renderModuleOverlay(parent, context, render, x, y, width, height, mouseX, mouseY, partialTicks, hoverTicks);
        }
        if (Screen.hasShiftDown()) {
            if (hoverTicks <= 10) {
                return false;
            }
            Minecraft mc = Minecraft.getInstance();
            Item item = this.getModule().getItem();
            ItemStack stack = new ItemStack((ItemLike)item);
            this.writeToItemStack(stack, context);
            List list = stack.getTooltipLines((Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            render.componentTooltip(list, (double)((int)mouseX), (double)((int)mouseY));
            return true;
        }
        if (hoverTicks <= 5) {
            return false;
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(Component.translatable((String)"module.draconicevolution.filtered_module.filter_slot").withStyle(ChatFormatting.YELLOW));
        int slotX = MathHelper.clip((int)((int)((mouseX - (double)x) / (double)width * 3.0)), (int)0, (int)2);
        int slotY = MathHelper.clip((int)((int)((mouseY - (double)y) / (double)height * 3.0)), (int)0, (int)2);
        int index = slotX + slotY * 3;
        ItemStack filter = (ItemStack)this.filterStacks.getOrDefault((Object)index, (Object)ItemStack.EMPTY);
        TagKey tag = (TagKey)this.filterTags.get(index);
        if (tag != null) {
            list.add(Component.translatable((String)"module.draconicevolution.filtered_module.filter_tag").withStyle(ChatFormatting.GRAY).append(": ").append((Component)Component.literal((String)tag.location().toString()).withStyle(ChatFormatting.GOLD)));
        } else if (!filter.isEmpty()) {
            Component name = filter.getHoverName();
            list.add(Component.translatable((String)"module.draconicevolution.filtered_module.filter_item").withStyle(ChatFormatting.GRAY).append(": ").append((Component)(name instanceof MutableComponent ? ((MutableComponent)name).withStyle(ChatFormatting.GOLD) : name)));
        }
        list.add(Component.translatable((String)"module.draconicevolution.filtered_module.set_item_filter").withStyle(ChatFormatting.DARK_GRAY));
        list.add(Component.translatable((String)"module.draconicevolution.filtered_module.configure_slot").withStyle(ChatFormatting.DARK_GRAY));
        list.add(Component.translatable((String)"module.draconicevolution.filtered_module.clear_slot").withStyle(ChatFormatting.DARK_GRAY));
        render.componentTooltip(list, (double)((int)mouseX), (double)((int)mouseY));
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean clientModuleClicked(GuiElement<?> parent, Player player, int x, int y, int width, int height, double mouseX, double mouseY, int button) {
        if (this.slotsCount == 0) {
            return false;
        }
        List<Slot> slots = this.layoutSlots(x, y, width, height);
        Slot slot = slots.stream().filter(e -> e.isInSlot(mouseX, mouseY)).findAny().orElse(null);
        if (slot == null) {
            return false;
        }
        int index = slot.index;
        ItemStack carrying = player.containerMenu.getCarried();
        if (button == 1 && Screen.hasShiftDown()) {
            this.filterStacks.remove(index);
            this.filterTags.remove(index);
            this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
            return true;
        }
        if (button == 1) {
            this.displayTagDialog(parent, index);
            return true;
        }
        if (carrying.isEmpty()) {
            return false;
        }
        ItemStack newFilter = carrying.copy();
        newFilter.setCount(1);
        this.filterStacks.put(index, (Object)newFilter);
        this.filterTags.remove(index);
        this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void displayTagDialog(GuiElement<?> parent, int index) {
        GuiDialogBase dialog = new GuiDialogBase(parent);
        dialog.setCloseOnOutsideClick(true);
        dialog.addMoveHandle(20);
        dialog.enableCursors(true);
        Constraints.size((ConstrainedGeometry)dialog, (double)152.0, (double)150.0);
        dialog.placeCenter();
        GuiElement root = dialog.getContentElement();
        root.setOpaque(true);
        root.jeiExclude();
        Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)root, () -> BCGuiTextures.getThemed((String)"background_dynamic")), (ConstrainedGeometry)root);
        GuiText heading = ((GuiText)((GuiText)new GuiText((GuiParent)root, (Component)Component.translatable((String)"module.draconicevolution.filtered_module.filter_by_tag")).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.WIDTH), (double)-10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).setTextColour(GuiToolkit.Palette.BG::text).setShadow(() -> BCConfig.darkMode).setAlignment(Align.CENTER);
        Constraints.placeInside((ConstrainedGeometry)heading, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)5.0);
        GuiRectangle fieldBg = (GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)root).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.WIDTH), (double)-10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        fieldBg.rectangle(() -> GuiToolkit.Palette.Ctrl.fill((boolean)fieldBg.isMouseOver()), () -> GuiToolkit.Palette.Ctrl.accentLight((boolean)false));
        GuiTextField textField = new GuiTextField((GuiParent)fieldBg).setMaxLength(512).setTextColor(GuiToolkit.Palette.Ctrl::text).setShadow(false).setSuggestionShadow(false).setSuggestion((Component)Component.translatable((String)"module.draconicevolution.filtered_module.filter_example"));
        Constraints.bind((ConstrainedGeometry)textField, (ConstrainedGeometry)fieldBg, (double)0.0, (double)4.0, (double)0.0, (double)4.0);
        Constraints.placeOutside((ConstrainedGeometry)fieldBg, (ConstrainedGeometry)heading, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        GuiText matchingLabel = ((GuiText)((GuiText)new GuiText((GuiParent)root, (Component)Component.translatable((String)"module.draconicevolution.filtered_module.matching")).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.WIDTH), (double)-10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).setTextColour(GuiToolkit.Palette.BG::text).setShadow(() -> BCConfig.darkMode).setAlignment(Align.CENTER);
        Constraints.placeOutside((ConstrainedGeometry)matchingLabel, (ConstrainedGeometry)fieldBg, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)4.0);
        GuiRectangle matchContainer = ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)root).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.WIDTH), (double)-10.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)matchingLabel.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-5.0))).shadedRect(GuiToolkit.Palette.Slot::accentDark, GuiToolkit.Palette.Slot::accentLight, GuiToolkit.Palette.Slot::fill);
        GuiSlider.ScrollBar scrollBar = GuiSlider.vanillaScrollBar((GuiElement)matchContainer, (Axis)Axis.Y);
        scrollBar.container().shadedRect(() -> 0, () -> 0, () -> scrollBar.container().isMouseOver() ? 0x30FFFFFF : 0);
        ((GuiRectangle)((GuiRectangle)((GuiRectangle)scrollBar.container().constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)matchContainer.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)matchContainer.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)matchContainer.get(GeoParam.RIGHT)));
        GuiScrolling scrolling = (GuiScrolling)((GuiScrolling)((GuiScrolling)((GuiScrolling)new GuiScrolling((GuiParent)matchContainer).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)matchContainer.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)scrollBar.container().get(GeoParam.LEFT), (double)0.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)matchContainer.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)matchContainer.get(GeoParam.BOTTOM), (double)-2.0));
        scrolling.installContainerElement(new GuiElement((GuiParent)scrolling));
        ((GuiElement)((GuiElement)scrolling.getContentElement().constrain(GeoParam.WIDTH, null)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)scrolling.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)scrolling.get(GeoParam.RIGHT)));
        scrollBar.slider().setSliderState(scrolling.scrollState(Axis.Y));
        scrollBar.slider().setScrollableElement((GuiElement)scrolling);
        ArrayList tagOps = new ArrayList();
        ItemStack filterStack = (ItemStack)this.filterStacks.getOrDefault((Object)index, (Object)ItemStack.EMPTY);
        if (!filterStack.isEmpty()) {
            tagOps.addAll(filterStack.getTags().toList());
        }
        if (!tagOps.isEmpty()) {
            GuiButton fromItemButton = new GuiButton((GuiParent)root);
            Constraints.size((ConstrainedGeometry)fromItemButton, (double)12.0, (double)12.0);
            Constraints.placeOutside((ConstrainedGeometry)fromItemButton, (ConstrainedGeometry)matchContainer, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-12.0, (double)-1.0);
            Constraints.bind((ConstrainedGeometry)((ConstrainedGeometry)new GuiItemStack((GuiParent)fromItemButton, filterStack).setTooltip(new Component[]{Component.translatable((String)"module.draconicevolution.filtered_module.select_from_item")})), (ConstrainedGeometry)fromItemButton);
            fromItemButton.onPress(() -> {
                GuiElement content = scrolling.getContentElement();
                content.getChildren().forEach(arg_0 -> ((GuiElement)content).removeChild(arg_0));
                scrolling.scrollState(Axis.Y).setPos(0.0);
                matchingLabel.setText((Component)Component.translatable((String)"module.draconicevolution.filtered_module.select_or_enter"));
                int yOffset = 0;
                for (TagKey tag : tagOps) {
                    GuiButton button = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiButton.flatColourButton((GuiParent)content, () -> Component.literal((String)tag.location().toString()), GuiToolkit.Palette.Ctrl::fill).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)content.get(GeoParam.TOP), (double)yOffset))).setTooltip(new Component[]{Component.literal((String)tag.location().toString())});
                    button.getLabel().setTrim(true);
                    button.onPress(() -> {
                        this.filterTags.remove(index);
                        textField.setValue(tag.location().toString());
                    });
                    yOffset += 13;
                }
            });
        }
        textField.setTextState(TextState.simpleState((String)"", s -> {
            ResourceLocation location = ResourceLocation.tryParse((String)s);
            TagKey key = (TagKey)this.filterTags.get(index);
            if (s.isEmpty() && key == null) {
                return;
            }
            GuiElement content = scrolling.getContentElement();
            if (location == null && this.filterTags.containsKey(index)) {
                this.filterTags.remove(index);
                this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
                return;
            }
            if (location == null || key != null && location.equals((Object)key.location()) && !content.getChildren().isEmpty()) {
                return;
            }
            key = ItemTags.create((ResourceLocation)location);
            content.getChildren().forEach(arg_0 -> ((GuiElement)content).removeChild(arg_0));
            scrolling.scrollState(Axis.Y).setPos(0.0);
            matchingLabel.setText((Component)Component.translatable((String)"module.draconicevolution.filtered_module.matching"));
            ArrayList matchingItems = FastStream.of((Iterable)BuiltInRegistries.ITEM.getTagOrEmpty(key)).map(Holder::value).toList();
            if (matchingItems.isEmpty()) {
                this.filterTags.remove(index);
                this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
                return;
            }
            for (int i = 0; i < matchingItems.size(); ++i) {
                Item item = (Item)matchingItems.get(i);
                GuiItemStack icon = new GuiItemStack((GuiParent)content, new ItemStack((ItemLike)item));
                Constraints.size((ConstrainedGeometry)icon, (double)18.0, (double)18.0);
                Constraints.placeInside((ConstrainedGeometry)icon, (ConstrainedGeometry)content, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)(i % 7 * 19), (double)((double)(i / 7) * 19.0));
            }
            this.filterTags.put(index, (Object)key);
            this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
        }));
        textField.setEnterPressed(() -> ((GuiDialogBase)dialog).close());
        if (this.filterTags.containsKey(index)) {
            textField.setValue(((TagKey)this.filterTags.get(index)).location().toString());
        }
    }

    @Override
    public void handleClientMessage(MCDataInput input) {
        this.readExtraData(input.readCompoundNBT());
    }

    public boolean testStack(ItemStack stack) {
        if (!this.isEnabled()) {
            return false;
        }
        for (int i = 0; i < this.slotsCount; ++i) {
            Item item;
            TagKey key;
            if (!(this.filterTags.containsKey(i) ? stack.is(key = (TagKey)this.filterTags.get(i)) : this.filterStacks.containsKey(i) && stack.is(item = ((ItemStack)this.filterStacks.get(i)).getItem()))) continue;
            return true;
        }
        return false;
    }

    public Predicate<ItemStack> createFilterTest() {
        if (!this.isEnabled()) {
            return e -> false;
        }
        Predicate<ItemStack> filterTest = null;
        for (int i = 0; i < this.slotsCount; ++i) {
            Predicate<ItemStack> slotTest;
            if (this.filterTags.containsKey(i)) {
                TagKey key = (TagKey)this.filterTags.get(i);
                slotTest = e -> e.is(key);
            } else {
                if (!this.filterStacks.containsKey(i)) continue;
                Item item = ((ItemStack)this.filterStacks.get(i)).getItem();
                slotTest = e -> e.is(item);
            }
            filterTest = filterTest == null ? slotTest : filterTest.or(slotTest);
        }
        return filterTest == null ? e -> false : filterTest;
    }

    public boolean isEmpty() {
        return this.slotsCount == 0 || this.filterStacks.isEmpty() && this.filterTags.isEmpty();
    }

    public boolean isEnabled() {
        return this.filterEnabled == null || this.filterEnabled.getValue();
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        super.writeExtraData(nbt);
        if (this.slotsCount == 0) {
            return nbt;
        }
        ListTag itemList = new ListTag();
        this.filterStacks.forEach((slot, stack) -> {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("slot", (byte)slot.intValue());
            ((ItemStack)this.filterStacks.get(slot)).save(compoundtag);
            itemList.add((Object)compoundtag);
        });
        nbt.put("items", (Tag)itemList);
        ListTag tagList = new ListTag();
        this.filterTags.forEach((slot, key) -> {
            CompoundTag tag = new CompoundTag();
            tag.putByte("slot", (byte)slot.intValue());
            tag.putString("key", key.location().toString());
            tagList.add((Object)tag);
        });
        nbt.put("tags", (Tag)tagList);
        return nbt;
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        super.readExtraData(nbt);
        if (this.slotsCount == 0) {
            return;
        }
        this.filterStacks.clear();
        this.filterTags.clear();
        ListTag itemList = nbt.getList("items", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            CompoundTag compoundtag = itemList.getCompound(i);
            byte slot = compoundtag.getByte("slot");
            if (slot < 0 || slot >= this.slotsCount) continue;
            this.filterStacks.put((int)slot, (Object)ItemStack.of((CompoundTag)compoundtag));
        }
        ListTag tagList = nbt.getList("tags", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag = tagList.getCompound(i);
            byte slot = tag.getByte("slot");
            TagKey key = ItemTags.create((ResourceLocation)new ResourceLocation(tag.getString("key")));
            if (slot < 0 || slot >= this.slotsCount) continue;
            this.filterTags.put((int)slot, (Object)key);
        }
    }

    protected record Slot(int index, double x, double y, double size) {
        public boolean isInSlot(double testX, double textY) {
            return GuiRender.isInRect((double)this.x, (double)this.y, (double)this.size, (double)this.size, (double)testX, (double)textY);
        }
    }
}

