/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.data.TreeHarvestData;
import com.brandon3055.draconicevolution.api.modules.entities.logic.ForestHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.entities.logic.IHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.entities.logic.TreeHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.lib.EntityOverridesItemUse;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class TreeHarvestEntity
extends ModuleEntity<TreeHarvestData>
implements EntityOverridesItemUse {
    private IHarvestHandler activeHandler = null;
    private InventoryDynamic itemBuffer = new InventoryDynamic();
    private BooleanProperty harvestLeaves = new BooleanProperty("tree_harvest_mod.leaves", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
    private IntegerProperty harvestRange;

    public TreeHarvestEntity(Module<TreeHarvestData> module) {
        super(module);
        this.addProperty(this.harvestLeaves);
        this.harvestRange = new IntegerProperty("tree_harvest_mod.range", module.getData().range()).setFormatter(ConfigProperty.IntegerFormatter.RAW).range(0, module.getData().range());
        this.addProperty(this.harvestRange);
    }

    private void useTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity;
        if (this.activeHandler == null || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack stack = event.getItem();
        IOPStorage storage = (IOPStorage)stack.getCapability(CapabilityOP.ITEM);
        if (storage == null) {
            return;
        }
        this.activeHandler.tick(player.level(), player, stack, storage, this.itemBuffer);
        if (this.itemBuffer.getStacks().size() > 8) {
            this.dropContents((Entity)player, stack);
        }
    }

    private void endUse(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity;
        if (this.activeHandler != null && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.activeHandler.stop(player.level(), player);
        }
        this.activeHandler = null;
        this.dropContents((Entity)event.getEntity(), event.getItem());
    }

    private void dropContents(Entity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!this.itemBuffer.isEmpty()) {
                ModuleHelper.handleItemCollection((Player)serverPlayer, this.host, EnergyUtils.getStorage((ItemStack)stack), this.itemBuffer);
                this.itemBuffer.clearContent();
            }
        }
    }

    @Override
    public void onEntityUseItem(LivingEntityUseItemEvent useEvent) {
        ICancellableEvent cancellable;
        if (useEvent instanceof ICancellableEvent && (cancellable = (ICancellableEvent)useEvent).isCanceled()) {
            return;
        }
        if (useEvent instanceof LivingEntityUseItemEvent.Start) {
            LivingEntityUseItemEvent.Start event = (LivingEntityUseItemEvent.Start)useEvent;
            event.setDuration(72000);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Tick) {
            LivingEntityUseItemEvent.Tick event = (LivingEntityUseItemEvent.Tick)useEvent;
            this.useTick(event);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Stop || useEvent instanceof LivingEntityUseItemEvent.Finish) {
            this.endUse(useEvent);
        }
    }

    @Override
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.isCanceled()) {
            return;
        }
        TreeHarvestData data = (TreeHarvestData)this.getModule().getData();
        if (this.activeHandler == null) {
            if (data.range() <= 0) {
                return;
            }
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                this.activeHandler = new ForestHarvestHandler(data.speed(), this.harvestRange.getValue(), this.harvestLeaves.getValue());
                this.activeHandler.start(event.getPos(), event.getLevel(), player2);
            }
        } else {
            return;
        }
        event.setCanceled(true);
        event.getEntity().startUsingItem(event.getHand());
    }

    @Override
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        TreeHarvestData data = (TreeHarvestData)this.getModule().getData();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.activeHandler = new TreeHarvestHandler(data.speed(), event.getHitVec().getDirection(), this.harvestLeaves.getValue());
            this.activeHandler.start(event.getPos(), event.getLevel(), player2);
        }
        event.setCanceled(true);
        event.getEntity().startUsingItem(event.getHand());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHostHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"module.draconicevolution.tree_harvest.single").withStyle(ChatFormatting.DARK_GRAY));
            if (((TreeHarvestData)this.getModule().getData()).range() > 0) {
                tooltip.add((Component)Component.translatable((String)"module.draconicevolution.tree_harvest.area").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modifyFirstPersonUsingPose(RenderHandEvent event, boolean leftHand) {
        PoseStack poseStack = event.getPoseStack();
        LocalPlayer player = Minecraft.getInstance().player;
        int handOffset = !leftHand ? 1 : -1;
        poseStack.translate((float)handOffset * -0.2785682f, 0.18344387f, 0.15731531f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-13.935f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)handOffset * 35.3f));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)handOffset * -9.785f));
        float drawTime = 72000.0f - ((float)player.getUseItemRemainingTicks() - event.getPartialTick() + 1.0f);
        float charge = drawTime / 20.0f;
        charge = (charge * charge + charge * 2.0f) / 3.0f;
        if (charge > 1.0f) {
            charge = 1.0f;
        }
        if (charge > 0.1f) {
            float f15 = Mth.sin((float)((drawTime - 0.1f) * 1.3f));
            float f18 = charge - 0.1f;
            float animOffset = f15 * f18;
            poseStack.translate(animOffset * 0.0f, animOffset * 0.004f, animOffset * 0.0f);
        }
        poseStack.translate(charge * 0.0f, charge * 0.0f, charge * 0.04f);
        poseStack.scale(1.0f, 1.0f, 1.0f + charge * 0.2f);
        poseStack.mulPose(Axis.YN.rotationDegrees((float)handOffset * 45.0f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modifyPlayerModelPose(Player player, PlayerModel<?> model, boolean leftHand) {
        if (!leftHand) {
            model.rightArm.yRot = -0.1f + model.head.yRot;
            model.leftArm.yRot = 0.1f + model.head.yRot + 0.4f;
            model.rightArm.xRot = -1.5707964f + model.head.xRot;
            model.leftArm.xRot = -1.5707964f + model.head.xRot;
        } else {
            model.rightArm.yRot = -0.1f + model.head.yRot - 0.4f;
            model.leftArm.yRot = 0.1f + model.head.yRot;
            model.rightArm.xRot = -1.5707964f + model.head.xRot;
            model.leftArm.xRot = -1.5707964f + model.head.xRot;
        }
        model.leftPants.copyFrom(model.leftLeg);
        model.rightPants.copyFrom(model.rightLeg);
        model.leftSleeve.copyFrom(model.leftArm);
        model.rightSleeve.copyFrom(model.rightArm);
        model.jacket.copyFrom(model.body);
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        this.itemBuffer.writeToNBT(nbt);
        return super.writeExtraData(nbt);
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        this.itemBuffer.readFromNBT(nbt);
        super.readExtraData(nbt);
    }
}

