/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.init.DEModules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ModuleHostImpl
implements ModuleHost,
PropertyProvider {
    private static final Logger LOGGER = LogManager.getLogger(ModuleHostImpl.class);
    private final int gridWidth;
    private final int gridHeight;
    private UUID identity = null;
    private final String providerName;
    private final boolean deleteInvalidModules;
    private final TechLevel techLevel;
    private final List<ModuleEntity<?>> moduleEntities = new ArrayList();
    private final Set<ModuleType<?>> additionalTypeList = new HashSet();
    private final Set<ModuleType<?>> typeBlackList = new HashSet();
    private final Set<ModuleCategory> categories = new HashSet<ModuleCategory>();
    private final List<ConfigProperty> providedProperties = new ArrayList<ConfigProperty>();
    private final Map<String, ConfigProperty> propertyMap = new LinkedHashMap<String, ConfigProperty>();
    private final Map<ModuleType<?>, Consumer<?>> propertyValidators = new HashMap();
    private final Map<ModuleType<?>, ModuleData<?>> moduleDataCache = new HashMap();
    private Consumer<List<ConfigProperty>> propertyBuilder;
    private BiFunction<ModuleEntity<?>, List<Component>, Boolean> removeCheck = null;

    public ModuleHostImpl(TechLevel techLevel, int gridWidth, int gridHeight, String providerName, boolean deleteInvalidModules, ModuleCategory ... categories) {
        this.techLevel = techLevel;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.providerName = providerName;
        this.deleteInvalidModules = deleteInvalidModules;
        this.categories.addAll(Arrays.asList(categories));
    }

    public void setRemoveCheck(BiFunction<ModuleEntity<?>, List<Component>, Boolean> removeCheck) {
        this.removeCheck = removeCheck;
    }

    @Override
    public Stream<Module<?>> getModules() {
        return this.getModuleEntities().stream().map(ModuleEntity::getModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModuleEntity<?>> getModuleEntities() {
        List<ModuleEntity<?>> list = this.moduleEntities;
        synchronized (list) {
            return Collections.unmodifiableList(this.moduleEntities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModule(ModuleEntity<?> entity, ModuleContext context) {
        List<ModuleEntity<?>> list = this.moduleEntities;
        synchronized (list) {
            this.moduleEntities.add(entity);
        }
        entity.setHost(this);
        this.clearCaches();
        entity.onInstalled(context);
        this.gatherProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModule(ModuleEntity<?> entity, ModuleContext context) {
        List<ModuleEntity<?>> list = this.moduleEntities;
        synchronized (list) {
            this.moduleEntities.remove(entity);
        }
        this.clearCaches();
        entity.onRemoved(context);
        this.gatherProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferModules(ModuleHostImpl source) {
        if (this.getGridWidth() >= source.getGridWidth() && this.getGridHeight() >= source.getGridHeight()) {
            List<ModuleEntity<?>> list = this.moduleEntities;
            synchronized (list) {
                this.moduleEntities.addAll(source.getModuleEntities());
                source.moduleEntities.clear();
                this.moduleEntities.forEach(moduleEntity -> moduleEntity.setHost(this));
            }
            this.clearCaches();
            this.gatherProperties();
        } else {
            LOGGER.warn("Cant transfer modules to smaller grid");
        }
    }

    @Override
    public Collection<ModuleCategory> getModuleCategories() {
        return this.categories;
    }

    public ModuleHostImpl addCategories(ModuleCategory ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    @Override
    public Collection<ModuleType<?>> getAdditionalTypes() {
        return this.additionalTypeList;
    }

    @Override
    public Collection<ModuleType<?>> getTypeBlackList() {
        return this.typeBlackList;
    }

    public ModuleHostImpl addAdditionalType(ModuleType<?> type) {
        this.additionalTypeList.add(type);
        return this;
    }

    public ModuleHostImpl blackListType(ModuleType<?> type) {
        this.typeBlackList.add(type);
        return this;
    }

    @Override
    public TechLevel getHostTechLevel() {
        return this.techLevel;
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public void handleTick(ModuleContext context) {
        this.getModuleEntities().forEach(e -> e.tick(context));
    }

    @Override
    @Nullable
    public <T extends ModuleData<T>> T getModuleData(ModuleType<T> moduleType) {
        return (T)this.moduleDataCache.computeIfAbsent(moduleType, x$0 -> ModuleHost.super.getModuleData(x$0));
    }

    @Override
    public boolean checkRemoveModule(ModuleEntity<?> module, List<Component> reason) {
        return this.removeCheck == null || this.removeCheck.apply(module, reason) != false;
    }

    private void clearCaches() {
        this.moduleDataCache.clear();
        this.getModuleEntities().forEach(ModuleEntity::clearCaches);
    }

    public void addPropertyBuilder(Consumer<List<ConfigProperty>> propertyBuilder) {
        Consumer<List<ConfigProperty>> builder = this.propertyBuilder;
        this.propertyBuilder = builder == null ? propertyBuilder : builder.andThen(propertyBuilder);
        this.gatherProperties();
    }

    @Override
    public UUID getIdentity() {
        if (this.identity == null) {
            this.regenIdentity();
        }
        return this.identity;
    }

    @Override
    public void regenIdentity() {
        this.identity = UUID.randomUUID();
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public Collection<ConfigProperty> getProperties() {
        return this.propertyMap.values();
    }

    @Override
    @Nullable
    public ConfigProperty getProperty(String propertyID) {
        return this.propertyMap.get(propertyID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherProperties() {
        List<ModuleEntity<?>> list = this.moduleEntities;
        synchronized (list) {
            ArrayList gathered = new ArrayList();
            if (this.propertyBuilder != null) {
                this.propertyBuilder.accept(gathered);
            }
            Set<ModuleType> installedTypes = this.getInstalledTypes().collect(Collectors.toSet());
            this.propertyValidators.entrySet().removeIf(e -> !installedTypes.contains(e.getKey()));
            installedTypes.forEach(type -> {
                HashMap<ConfigProperty, Consumer> map = new HashMap<ConfigProperty, Consumer>();
                type.getTypeProperties((ModuleData)SneakyUtils.unsafeCast(this.getModuleData((ModuleType)type)), (Map)SneakyUtils.unsafeCast(map));
                gathered.addAll(map.keySet());
                if (this.propertyValidators.containsKey(type)) {
                    this.propertyValidators.get(type).accept(SneakyUtils.unsafeCast(this.getModuleData((ModuleType)type)));
                } else {
                    map.forEach((property, consumer) -> {
                        if (consumer != null) {
                            this.propertyValidators.put((ModuleType<?>)type, (Consumer<?>)consumer);
                        }
                    });
                }
            });
            Set gatheredNames = gathered.stream().map(ConfigProperty::getName).collect(Collectors.toSet());
            this.providedProperties.removeIf(e -> !gatheredNames.contains(e.getName()));
            Set installedNames = this.providedProperties.stream().map(ConfigProperty::getName).collect(Collectors.toSet());
            this.providedProperties.addAll(gathered.stream().filter(e -> !installedNames.contains(e.getName())).toList());
            this.propertyMap.clear();
            this.providedProperties.forEach(e -> this.propertyMap.put(e.getName(), (ConfigProperty)e));
            this.getModuleEntities().forEach(e -> e.getEntityProperties().forEach(p -> {
                if (this.propertyMap.containsKey(p.getName())) {
                    p.generateUnique();
                }
                this.propertyMap.put(p.getName(), (ConfigProperty)p);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag modules = new ListTag();
        List<ModuleEntity<?>> list = this.moduleEntities;
        synchronized (list) {
            for (ModuleEntity<?> entity : this.moduleEntities) {
                CompoundTag entityNBT = new CompoundTag();
                entityNBT.putString("id", DEModules.REGISTRY.getKey(entity.module).toString());
                entity.writeToNBT(entityNBT);
                modules.add((Object)entityNBT);
            }
        }
        nbt.put("modules", (Tag)modules);
        nbt.putUUID("identity", this.getIdentity());
        CompoundTag properties = new CompoundTag();
        this.providedProperties.forEach(e -> properties.put(e.getName(), (Tag)e.serializeNBT()));
        nbt.put("properties", (Tag)properties);
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeNBT(CompoundTag nbt) {
        List<ModuleEntity<?>> list = this.moduleEntities;
        synchronized (list) {
            this.clearCaches();
            this.moduleEntities.clear();
            ListTag modules = nbt.getList("modules", 10);
            modules.stream().map(inbt -> (CompoundTag)inbt).forEach(compound -> {
                ResourceLocation id = new ResourceLocation(compound.getString("id"));
                Module module = (Module)ModuleRegistry.getRegistry().get(id);
                if (module == null) {
                    LOGGER.warn("Failed to load unregistered module: " + id + " Skipping...");
                } else {
                    ModuleEntity<?> entity = module.createEntity();
                    entity.readFromNBT((CompoundTag)compound);
                    if (this.deleteInvalidModules && !entity.isPosValid(this.gridWidth, this.gridHeight)) {
                        LOGGER.warn("Deleting module from invalid grid position: " + entity.toString());
                    } else {
                        this.moduleEntities.add(entity);
                        entity.setHost(this);
                    }
                }
            });
            this.gatherProperties();
            if (nbt.hasUUID("identity")) {
                this.identity = nbt.getUUID("identity");
            }
            CompoundTag properties = nbt.getCompound("properties");
            this.providedProperties.forEach(e -> e.deserializeNBT(properties.getCompound(e.getName())));
        }
    }
}

