/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.raytracer.SubHitBlockHitResult;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class TilePlacedItem
extends TileBCore
implements IInteractTile {
    public static int MAX_STACKS = 4;
    public final ManagedByte stackCount = (ManagedByte)this.register((IManagedData)new ManagedByte("stack_count", 1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool toolMode = (ManagedBool)this.register((IManagedData)new ManagedBool("tool_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte[] rotation = new ManagedByte[MAX_STACKS];
    public final ManagedBool[] isBlock = new ManagedBool[MAX_STACKS];
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, MAX_STACKS);

    public TilePlacedItem(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_PLACED_ITEM.get(), pos, state);
        for (int i = 0; i < MAX_STACKS; ++i) {
            this.rotation[i] = (ManagedByte)this.register((IManagedData)new ManagedByte("rotation_" + i, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
            this.isBlock[i] = (ManagedBool)this.register((IManagedData)new ManagedBool("is_block_" + i, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        }
        this.capManager.setInternalManaged("inventory", Capabilities.ItemHandler.BLOCK, (INBTSerializable)this.itemHandler).saveBoth().syncTile();
        this.itemHandler.setContentsChangeListener(e -> this.updatePlacedItem());
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TilePlacedItem.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_PLACED_ITEM, (BlockCapability)Capabilities.ItemHandler.BLOCK);
    }

    private void updatePlacedItem() {
        List<ItemStack> stacks = this.getStacksInOrder();
        this.stackCount.set(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            this.isBlock[i].set(stacks.get(i).getItem() instanceof BlockItem);
        }
        if (stacks.size() == 1) {
            ItemStack stack = stacks.get(0);
            this.toolMode.set(stack.getItem() instanceof TieredItem || stack.isDamageableItem());
        } else {
            this.toolMode.set(false);
        }
        this.tick();
    }

    public List<ItemStack> getStacksInOrder() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            stacks.add(this.itemHandler.getStackInSlot(i));
        }
        return stacks;
    }

    public ItemStack extractStackAtIndex(int index) {
        int current = 0;
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (index == current) {
                this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
                return stack;
            }
            ++current;
        }
        return ItemStack.EMPTY;
    }

    public boolean[] getBlockArray() {
        boolean[] bools = new boolean[MAX_STACKS];
        for (int i = 0; i < MAX_STACKS; ++i) {
            bools[i] = this.isBlock[i].get();
        }
        return bools;
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult clientHit) {
        if (player.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        List<ItemStack> stacks = this.getStacksInOrder();
        BlockHitResult hit = RayTracer.retrace((Player)player);
        if (!(hit instanceof SubHitBlockHitResult)) {
            return InteractionResult.PASS;
        }
        int index = ((SubHitBlockHitResult)hit).subHit - 1;
        ItemStack held = player.getItemInHand(hand);
        if (!held.isEmpty() && held.getItem() == DEContent.CRYSTAL_BINDER.get() && this.getStacksInOrder().size() == 1) {
            this.toolMode.invert();
            this.tick();
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            if (index >= 0 && index < this.rotation.length) {
                this.rotation[index].inc();
                BCoreNetwork.sendSound((Level)this.level, (BlockPos)this.worldPosition, (SoundEvent)SoundEvents.ITEM_FRAME_ROTATE_ITEM, (SoundSource)SoundSource.PLAYERS, (float)1.0f, (float)(0.9f + this.level.random.nextFloat() * 0.2f), (boolean)false);
                this.tick();
            }
            return InteractionResult.SUCCESS;
        }
        if (index == -1) {
            this.onBroken(player, player.getOnPos().above(), true);
            this.level.removeBlock(this.getBlockPos(), false);
            return InteractionResult.SUCCESS;
        }
        if (index < stacks.size()) {
            ItemStack stack = this.extractStackAtIndex(index);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)stack);
            if (stacks.size() == 1) {
                this.level.removeBlock(this.getBlockPos(), false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockAttack(BlockState state, Player player) {
        if (!player.isShiftKeyDown()) {
            return;
        }
        List<ItemStack> stacks = this.getStacksInOrder();
        if (stacks.size() == 1 && !(stacks.get(0).getItem() instanceof BlockItem)) {
            this.toolMode.invert();
            BCoreNetwork.sendSound((Level)this.level, (BlockPos)this.worldPosition, (SoundEvent)SoundEvents.ITEM_FRAME_ROTATE_ITEM, (SoundSource)SoundSource.PLAYERS, (float)1.0f, (float)(0.9f + this.level.random.nextFloat() * 0.2f), (boolean)false);
            this.tick();
        } else {
            HitResult hit = player.pick(4.0, 0.0f, false);
            if (hit instanceof SubHitBlockHitResult && hit.getType() == HitResult.Type.BLOCK && ((SubHitBlockHitResult)hit).subHit > 0 && ((SubHitBlockHitResult)hit).subHit - 1 < this.rotation.length) {
                this.rotation[((SubHitBlockHitResult)hit).subHit - 1].dec();
                BCoreNetwork.sendSound((Level)this.level, (BlockPos)this.worldPosition, (SoundEvent)SoundEvents.ITEM_FRAME_ROTATE_ITEM, (SoundSource)SoundSource.PLAYERS, (float)1.0f, (float)(0.9f + this.level.random.nextFloat() * 0.2f), (boolean)false);
                this.tick();
            }
        }
    }

    public void onBroken(Player player, BlockPos dropPos, boolean noPickupDelay) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!player.getAbilities().instabuild) {
                TilePlacedItem.popResource(this.level, dropPos, this.itemHandler.getStackInSlot(i), noPickupDelay);
            }
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public static void popResource(Level world, BlockPos pos, ItemStack stack, boolean noPickupDelay) {
        if (!world.isClientSide && !stack.isEmpty() && world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !world.restoringBlockSnapshots) {
            double d0 = (double)(world.random.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(world.random.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(world.random.nextFloat() * 0.5f) + 0.25;
            ItemEntity itementity = new ItemEntity(world, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, stack);
            if (noPickupDelay) {
                itementity.setNoPickUpDelay();
            } else {
                itementity.setDefaultPickUpDelay();
            }
            world.addFreshEntity((Entity)itementity);
        }
    }

    public boolean saveToItem() {
        return false;
    }
}

