/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.draconicevolution.client.render.particle.BlinkParticle;
import com.brandon3055.draconicevolution.client.render.particle.CustomFlameParticle;
import com.brandon3055.draconicevolution.client.render.particle.GuardianBeamParticle;
import com.brandon3055.draconicevolution.client.render.particle.GuardianCloudParticle;
import com.brandon3055.draconicevolution.client.render.particle.GuardianProjectileParticle;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergy;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyBasic;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyCoreFX;
import com.brandon3055.draconicevolution.client.render.particle.ParticleLineIndicator;
import com.brandon3055.draconicevolution.client.render.particle.SparkParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DEParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"draconicevolution");
    public static final DeferredHolder<ParticleType<?>, IntParticleType> FLAME = PARTICLE_TYPES.register("flame", () -> new IntParticleType(false));
    public static final DeferredHolder<ParticleType<?>, IntParticleType> LINE_INDICATOR = PARTICLE_TYPES.register("line_indicator", () -> new IntParticleType(false));
    public static final DeferredHolder<ParticleType<?>, IntParticleType> ENERGY = PARTICLE_TYPES.register("energy", () -> new IntParticleType(false));
    public static final DeferredHolder<ParticleType<?>, IntParticleType> ENERGY_BASIC = PARTICLE_TYPES.register("energy_basic", () -> new IntParticleType(false));
    public static final DeferredHolder<ParticleType<?>, IntParticleType> ENERGY_CORE = PARTICLE_TYPES.register("energy_core", () -> new IntParticleType(false));
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> GUARDIAN_PROJECTILE = PARTICLE_TYPES.register("guardian_projectile", () -> new SimpleParticleType(false));
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> BLINK = PARTICLE_TYPES.register("blink", () -> new SimpleParticleType(false));
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> GUARDIAN_CLOUD = PARTICLE_TYPES.register("guardian_cloud", () -> new SimpleParticleType(false));
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> GUARDIAN_BEAM = PARTICLE_TYPES.register("guardian_beam", () -> new SimpleParticleType(false));
    public static final DeferredHolder<ParticleType<?>, IntParticleType> SPARK = PARTICLE_TYPES.register("spark", () -> new IntParticleType(false));

    public static void init(IEventBus modBus) {
        PARTICLE_TYPES.register(modBus);
        modBus.addListener(DEParticles::registerFactories);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)FLAME.get(), CustomFlameParticle.Factory::new);
        event.registerSpriteSet((ParticleType)LINE_INDICATOR.get(), ParticleLineIndicator.Factory::new);
        event.registerSpriteSet((ParticleType)ENERGY.get(), ParticleEnergy.Factory::new);
        event.registerSpriteSet((ParticleType)ENERGY_BASIC.get(), ParticleEnergyBasic.Factory::new);
        event.registerSpriteSet((ParticleType)ENERGY_CORE.get(), ParticleEnergyCoreFX.Factory::new);
        event.registerSpriteSet((ParticleType)GUARDIAN_PROJECTILE.get(), GuardianProjectileParticle.Factory::new);
        event.registerSpriteSet((ParticleType)BLINK.get(), BlinkParticle.Factory::new);
        event.registerSpriteSet((ParticleType)GUARDIAN_CLOUD.get(), GuardianCloudParticle.Factory::new);
        event.registerSpriteSet((ParticleType)GUARDIAN_BEAM.get(), GuardianBeamParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SPARK.get(), SparkParticle.Factory::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Particle addParticleDirect(Level world, Particle particle) {
        if (world instanceof ClientLevel) {
            Minecraft mc = Minecraft.getInstance();
            Camera activerenderinfo = mc.gameRenderer.getMainCamera();
            if (mc != null && activerenderinfo.isInitialized() && mc.particleEngine != null) {
                mc.particleEngine.add(particle);
                return particle;
            }
        }
        return null;
    }
}

