/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import codechicken.lib.gui.modular.sprite.Material;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.client.atlas.MultiModAtlasHolder;
import com.brandon3055.draconicevolution.init.DEModules;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public class ModuleTextures {
    private static final MultiModAtlasHolder ATLAS_HOLDER = new MultiModAtlasHolder("draconicevolution", "textures/atlas/module.png", "module", DEModules.MODULE_PROVIDING_MODS);
    private static final Map<String, Material> MATERIAL_CACHE = new HashMap<String, Material>();

    public static MultiModAtlasHolder getAtlasHolder() {
        return ATLAS_HOLDER;
    }

    protected static Material get(ResourceLocation texture) {
        return MATERIAL_CACHE.computeIfAbsent(texture.getNamespace() + ":" + texture.getPath(), e -> ModuleTextures.getUncached(texture));
    }

    protected static Material getUncached(ResourceLocation texture) {
        return new Material(ATLAS_HOLDER.atlasLocation(), new ResourceLocation(texture.getNamespace(), "module/" + texture.getPath()), ATLAS_HOLDER::getSprite);
    }

    public static Material get(Module<?> module) {
        return ModuleTextures.get(Objects.requireNonNull(DEModules.REGISTRY.getKey(module)));
    }
}

