/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.EnumProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.inventory.ConfigurableItemMenu;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;

public class PropertyData {
    public final ConfigProperty.Type type;
    public final UUID providerID;
    public final String providerName;
    private String propName;
    protected UUID propUniqueName;
    public Component toolTip;
    public Component displayName;
    public Runnable changeListener;
    public boolean isGlobal = false;
    private boolean isPropertyAvailable = false;
    public boolean isProviderAvailable = false;
    public int integerValue = 0;
    public double decimalValue = 0.0;
    public String displayValue = "value";
    public boolean booleanValue = false;
    public double minValue = 0.0;
    public double maxValue = 1.0;
    public ConfigProperty.BooleanFormatter booleanFormatter = ConfigProperty.BooleanFormatter.TRUE_FALSE;
    public ConfigProperty.IntegerFormatter integerFormatter = ConfigProperty.IntegerFormatter.RAW;
    public ConfigProperty.DecimalFormatter decimalFormatter = ConfigProperty.DecimalFormatter.RAW_1;
    public int enumValueIndex = 0;
    public List<Integer> enumValueOptions;
    public Map<Integer, String> enumDisplayValues;

    public PropertyData(PropertyProvider provider, ConfigProperty property, boolean pullValue) {
        this(provider.getIdentity(), provider.getProviderName(), property.getType());
        this.displayName = property.getDisplayName();
        this.toolTip = property.getToolTip();
        if (property.getUniqueName() != null) {
            this.propUniqueName = property.getUniqueName();
        } else {
            this.propName = property.getName();
        }
        this.isProviderAvailable = true;
        this.pullData(property, pullValue);
    }

    public PropertyData(UUID providerID, String providerName, ConfigProperty.Type type) {
        this.providerID = providerID;
        this.providerName = providerName;
        this.type = type;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void pullData(ConfigProperty property, boolean pullValue) {
        boolean bl = this.isPropertyAvailable = property != null;
        if (this.isPropertyAvailable) {
            TranslatableContents tra;
            ComponentContents componentContents;
            this.displayName = property.getDisplayName();
            this.toolTip = property.getToolTip();
            if (this.toolTip != null && (componentContents = this.toolTip.getContents()) instanceof TranslatableContents && (tra = (TranslatableContents)componentContents).getKey().equals(this.toolTip.getString())) {
                this.toolTip = null;
            }
            this.displayValue = property.getDisplayValue();
            switch (property.getType()) {
                case BOOLEAN: {
                    ConfigProperty prop = (BooleanProperty)property;
                    this.booleanFormatter = ((BooleanProperty)prop).getFormatter();
                    if (!pullValue) break;
                    this.booleanValue = ((BooleanProperty)prop).getValue();
                    break;
                }
                case INTEGER: {
                    ConfigProperty prop = (IntegerProperty)property;
                    this.integerFormatter = ((IntegerProperty)prop).getFormatter();
                    this.minValue = ((IntegerProperty)prop).getMin();
                    this.maxValue = ((IntegerProperty)prop).getMax();
                    if (!pullValue) break;
                    this.integerValue = ((IntegerProperty)prop).getValue();
                    break;
                }
                case DECIMAL: {
                    ConfigProperty prop = (DecimalProperty)property;
                    this.decimalFormatter = ((DecimalProperty)prop).getFormatter();
                    this.minValue = ((DecimalProperty)prop).getMin();
                    this.maxValue = ((DecimalProperty)prop).getMax();
                    if (!pullValue) break;
                    this.decimalValue = ((DecimalProperty)prop).getValue();
                    break;
                }
                case ENUM: {
                    ConfigProperty prop = (EnumProperty)property;
                    this.enumValueOptions = ((EnumProperty)prop).getAllowedValues().stream().map(Enum::ordinal).collect(Collectors.toList());
                    this.enumDisplayValues = ((EnumProperty)prop).generateValueDisplayMap();
                    if (!pullValue) break;
                    this.enumValueIndex = ((Enum)((EnumProperty)prop).getValue()).ordinal();
                }
            }
        }
        this.updateDisplayValue();
    }

    public String getPropertyName() {
        return this.propUniqueName == null ? this.propName : this.propUniqueName.toString();
    }

    public void pullData(ConfigurableItemMenu container, boolean pullValue) {
        PropertyProvider provider = container.findProvider(this.providerID);
        boolean bl = this.isProviderAvailable = provider != null;
        if (this.isProviderAvailable) {
            this.pullData(provider.getProperty(this.getPropertyName()), pullValue);
        }
    }

    public void updateDisplayValue() {
        switch (this.type) {
            case BOOLEAN: {
                if (this.booleanFormatter == null) break;
                this.displayValue = this.booleanFormatter.format(this.booleanValue);
                break;
            }
            case INTEGER: {
                if (this.integerFormatter == null) break;
                this.displayValue = this.integerFormatter.format(this.integerValue);
                break;
            }
            case DECIMAL: {
                if (this.decimalFormatter == null) break;
                this.displayValue = this.decimalFormatter.format(this.decimalValue);
                break;
            }
            case ENUM: {
                if (this.enumDisplayValues == null) break;
                this.displayValue = this.enumDisplayValues.getOrDefault(this.enumValueIndex, "[Error]");
            }
        }
    }

    public void updateBooleanValue(boolean newValue) {
        if (this.type == ConfigProperty.Type.BOOLEAN) {
            this.booleanValue = newValue;
            this.updateDisplayValue();
            this.onValueChanged();
        }
    }

    public void toggleBooleanValue() {
        this.updateBooleanValue(!this.booleanValue);
    }

    public void updateEnumValue(int newIndex) {
        if (this.type == ConfigProperty.Type.ENUM && this.enumValueOptions.contains(newIndex)) {
            this.enumValueIndex = newIndex;
            this.updateDisplayValue();
            this.onValueChanged();
        }
    }

    public void updateNumberValue(double value, boolean isFinalValue) {
        if (this.type == ConfigProperty.Type.INTEGER) {
            this.integerValue = (int)Math.round(value);
        } else if (this.type == ConfigProperty.Type.DECIMAL) {
            this.decimalValue = value;
        } else {
            return;
        }
        this.updateDisplayValue();
        if (isFinalValue) {
            this.onValueChanged();
        }
    }

    public void increment(int dir) {
        if (this.type == ConfigProperty.Type.INTEGER) {
            int inc = (int)(Math.max(1.0, this.getInc(this.maxValue - this.minValue)) * (double)dir * (double)(Screen.hasShiftDown() ? 2 : 1));
            this.integerValue = (int)MathHelper.clip((double)(this.integerValue + inc), (double)this.minValue, (double)this.maxValue);
        } else if (this.type == ConfigProperty.Type.DECIMAL) {
            double inc = this.getInc(this.maxValue - this.minValue) * (double)dir * (double)(Screen.hasShiftDown() ? 2 : 1);
            this.decimalValue = MathHelper.clip((double)(this.decimalValue + inc), (double)this.minValue, (double)this.maxValue);
        } else if (this.type == ConfigProperty.Type.ENUM && this.enumValueOptions != null && this.enumValueOptions.contains(this.enumValueIndex)) {
            int index = this.enumValueOptions.indexOf(this.enumValueIndex);
            int newIndex = Math.floorMod(index + dir, this.enumValueOptions.size());
            this.enumValueIndex = this.enumValueOptions.get(newIndex);
        } else {
            return;
        }
        this.updateDisplayValue();
        this.onValueChanged();
    }

    private double getInc(double range) {
        if (range <= 1.0) {
            return 0.1;
        }
        if (range <= 5.0) {
            return 0.5;
        }
        if (range <= 10.0) {
            return 1.0;
        }
        if (range <= 20.0) {
            return 2.0;
        }
        if (range <= 50.0) {
            return 5.0;
        }
        return 10.0;
    }

    public void onValueChanged() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    public void toggleGlobal() {
        this.isGlobal = !this.isGlobal;
    }

    public String getEnumDisplayName(int enumIndex) {
        return this.enumDisplayValues != null && this.enumDisplayValues.containsKey(enumIndex) ? this.enumDisplayValues.get(enumIndex) : ChatFormatting.RED + "[Error]";
    }

    public void sendToServer() {
        DraconicNetwork.sendPropertyData(this);
    }

    public ConfigProperty getPropIfApplicable(PropertyProvider provider) {
        if (provider.getProviderName().equals(this.providerName) && (this.isGlobal || provider.getIdentity().equals(this.providerID))) {
            return provider.getProperty(this.getPropertyName());
        }
        return null;
    }

    public boolean doesDataMatch(ConfigProperty prop) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigProperty.Type.BOOLEAN -> {
                if (prop instanceof BooleanProperty && ((BooleanProperty)prop).getValue() == this.booleanValue) {
                    yield true;
                }
                yield false;
            }
            case ConfigProperty.Type.INTEGER -> {
                if (prop instanceof IntegerProperty && ((IntegerProperty)prop).getValue() == this.integerValue) {
                    yield true;
                }
                yield false;
            }
            case ConfigProperty.Type.DECIMAL -> {
                if (prop instanceof DecimalProperty && ((DecimalProperty)prop).getValue() == this.decimalValue) {
                    yield true;
                }
                yield false;
            }
            case ConfigProperty.Type.ENUM -> prop instanceof EnumProperty && ((Enum)((EnumProperty)prop).getValue()).ordinal() == this.enumValueIndex;
        };
    }

    public boolean isPropertyAvailable() {
        return this.isPropertyAvailable && this.isProviderAvailable;
    }

    public PropertyData copy() {
        PropertyData copy = new PropertyData(this.providerID, this.providerName, this.type);
        copy.propName = this.propName;
        copy.propUniqueName = this.propUniqueName;
        copy.toolTip = this.toolTip;
        copy.displayName = this.displayName;
        copy.changeListener = this.changeListener;
        copy.isGlobal = this.isGlobal;
        copy.isPropertyAvailable = this.isPropertyAvailable;
        copy.isProviderAvailable = this.isProviderAvailable;
        copy.integerValue = this.integerValue;
        copy.decimalValue = this.decimalValue;
        copy.displayValue = this.displayValue;
        copy.booleanValue = this.booleanValue;
        copy.minValue = this.minValue;
        copy.maxValue = this.maxValue;
        copy.booleanFormatter = this.booleanFormatter;
        copy.integerFormatter = this.integerFormatter;
        copy.decimalFormatter = this.decimalFormatter;
        copy.enumValueIndex = this.enumValueIndex;
        if (this.enumValueOptions != null && this.enumDisplayValues != null) {
            copy.enumValueOptions = new ArrayList<Integer>(this.enumValueOptions);
            copy.enumDisplayValues = new HashMap<Integer, String>(this.enumDisplayValues);
        }
        return copy;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.putByte("type", (byte)this.type.ordinal());
        nbt.putUUID("prov_id", this.providerID);
        nbt.putString("prov_name", this.providerName);
        if (this.propUniqueName != null) {
            nbt.putUUID("prop_name", this.propUniqueName);
        } else {
            nbt.putString("prop_name", this.propName);
        }
        nbt.putString("tooltip", Component.Serializer.toJson((Component)this.toolTip));
        nbt.putString("display_name", Component.Serializer.toJson((Component)this.displayName));
        nbt.putString("display_value", this.displayValue);
        nbt.putBoolean("global", this.isGlobal);
        switch (this.type) {
            case BOOLEAN: {
                nbt.putBoolean("value", this.booleanValue);
                nbt.putByte("formatter", (byte)this.booleanFormatter.ordinal());
                break;
            }
            case INTEGER: {
                nbt.putInt("value", this.integerValue);
                nbt.putByte("formatter", (byte)this.integerFormatter.ordinal());
                nbt.putInt("min", (int)this.minValue);
                nbt.putInt("max", (int)this.maxValue);
                break;
            }
            case DECIMAL: {
                nbt.putDouble("value", this.decimalValue);
                nbt.putByte("formatter", (byte)this.decimalFormatter.ordinal());
                nbt.putDouble("min", this.minValue);
                nbt.putDouble("max", this.maxValue);
                break;
            }
            case ENUM: {
                nbt.putInt("value", this.enumValueIndex);
                if (this.enumValueOptions != null) {
                    nbt.put("names", (Tag)this.enumValueOptions.stream().map(IntTag::valueOf).collect(Collectors.toCollection(ListTag::new)));
                }
                if (this.enumDisplayValues == null) break;
                CompoundTag nameValues = new CompoundTag();
                this.enumDisplayValues.forEach((key, value) -> nameValues.putString(String.valueOf(key), value));
                nbt.put("name_values", (Tag)nameValues);
            }
        }
        return nbt;
    }

    @Nullable
    public static PropertyData deserialize(CompoundTag nbt) {
        if (!(nbt.hasUUID("prov_id") && nbt.contains("prov_name") && (nbt.contains("prop_name") || nbt.hasUUID("prop_name")) && nbt.contains("type"))) {
            return null;
        }
        PropertyData data = new PropertyData(nbt.getUUID("prov_id"), nbt.getString("prov_name"), ConfigProperty.Type.getSafe(nbt.getByte("type")));
        if (nbt.hasUUID("prop_name")) {
            data.propUniqueName = nbt.getUUID("prop_name");
        } else {
            data.propName = nbt.getString("prop_name");
        }
        try {
            data.toolTip = Component.Serializer.fromJsonLenient((String)nbt.getString("tooltip"));
        }
        catch (JsonParseException ignored) {
            data.toolTip = Component.literal((String)nbt.getString("tooltip"));
        }
        try {
            data.displayName = Component.Serializer.fromJsonLenient((String)nbt.getString("display_name"));
        }
        catch (JsonParseException ignored) {
            data.displayName = Component.literal((String)nbt.getString("display_name"));
        }
        data.displayValue = nbt.getString("display_value");
        data.isGlobal = nbt.getBoolean("global");
        switch (data.type) {
            case BOOLEAN: {
                data.booleanValue = nbt.getBoolean("value");
                data.booleanFormatter = ConfigProperty.BooleanFormatter.getSafe(nbt.getByte("formatter"));
                break;
            }
            case INTEGER: {
                data.integerValue = nbt.getInt("value");
                data.integerFormatter = ConfigProperty.IntegerFormatter.getSafe(nbt.getByte("formatter"));
                data.minValue = nbt.getInt("min");
                data.maxValue = nbt.getInt("max");
                break;
            }
            case DECIMAL: {
                data.decimalValue = nbt.getDouble("value");
                data.decimalFormatter = ConfigProperty.DecimalFormatter.getSafe(nbt.getByte("formatter"));
                data.minValue = nbt.getDouble("min");
                data.maxValue = nbt.getDouble("max");
                break;
            }
            case ENUM: {
                data.enumValueIndex = nbt.getInt("value");
                if (nbt.contains("names")) {
                    data.enumValueOptions = nbt.getList("names", 3).stream().map(inbt -> ((IntTag)inbt).getAsInt()).collect(Collectors.toList());
                }
                if (!nbt.contains("name_values")) break;
                CompoundTag nameValues = nbt.getCompound("name_values");
                data.enumDisplayValues = nameValues.getAllKeys().stream().collect(Collectors.toMap(Utils::parseInt, arg_0 -> ((CompoundTag)nameValues).getString(arg_0)));
            }
        }
        return data;
    }

    public void write(MCDataOutput output) {
        output.writeEnum((Enum)this.type);
        output.writeBoolean(this.isGlobal);
        if (!this.isGlobal) {
            output.writeUUID(this.providerID);
        }
        output.writeString(this.providerName);
        output.writeBoolean(this.propUniqueName != null);
        if (this.propUniqueName != null) {
            output.writeUUID(this.propUniqueName);
        } else {
            output.writeString(this.propName);
        }
        switch (this.type) {
            case BOOLEAN: {
                output.writeBoolean(this.booleanValue);
                break;
            }
            case INTEGER: {
                output.writeVarInt(this.integerValue);
                break;
            }
            case DECIMAL: {
                output.writeDouble(this.decimalValue);
                break;
            }
            case ENUM: {
                output.writeVarInt(this.enumValueIndex);
            }
        }
    }

    public static PropertyData read(MCDataInput input) {
        ConfigProperty.Type type = (ConfigProperty.Type)input.readEnum(ConfigProperty.Type.class);
        boolean isGlobal = input.readBoolean();
        UUID provID = isGlobal ? null : input.readUUID();
        String provName = input.readString();
        PropertyData data = new PropertyData(provID, provName, type);
        if (input.readBoolean()) {
            data.propUniqueName = input.readUUID();
        } else {
            data.propName = input.readString();
        }
        data.isGlobal = isGlobal;
        switch (type) {
            case BOOLEAN: {
                data.booleanValue = input.readBoolean();
                break;
            }
            case INTEGER: {
                data.integerValue = input.readVarInt();
                break;
            }
            case DECIMAL: {
                data.decimalValue = input.readDouble();
                break;
            }
            case ENUM: {
                data.enumValueIndex = input.readVarInt();
            }
        }
        return data;
    }
}

