/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.DelayedExecutor;
import com.brandon3055.draconicevolution.api.energy.ICrystalBinder;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.RegisterGuiOverlaysEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.TickEvent;
import org.joml.Vector4f;

@Deprecated
public class ClientEventHandler {
    public static FloatBuffer winPos = FloatBuffer.allocate(3);
    public static volatile int elapsedTicks;
    public static boolean playerHoldingWrench;
    public static Minecraft mc;
    private static Random rand;
    public static BlockPos explosionPos;
    public static double explosionAnimation;
    public static int explosionTime;
    public static boolean explosionRetreating;
    public static final RenderType explosionFlashType;
    public static final Matrix4 MODELVIEW;
    public static final Matrix4 PROJECTION;

    public static void init(IEventBus modBus) {
        mc = Minecraft.getInstance();
        modBus.addListener(EventPriority.LOW, ClientEventHandler::registerOverlays);
        modBus.addListener(ClientEventHandler::addPackFinders);
        NeoForge.EVENT_BUS.addListener(ClientEventHandler::tickEnd);
    }

    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById("draconicevolution").getFile().findResource(new String[]{"2d_item_models"});
            Pack pack = Pack.readMetaAndCreate((String)"builtin/2d_item_models", (Component)Component.literal((String)"Draconic Evolution 2D"), (boolean)false, (Pack.ResourcesSupplier)BuiltInPackSource.fromName(path -> new PathPackResources(path, resourcePath, true)), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.BUILT_IN);
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }

    private static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll(new ResourceLocation("draconicevolution", "explosion_overlay"), (gui, graphics, partialTick, screenWidth, screenHeight) -> {
            if (explosionPos != null) {
                ClientEventHandler.updateExplosionAnimation(mc, GuiRender.convert((GuiGraphics)graphics), mc.getWindow(), mc.getFrameTime());
            }
        });
    }

    public static void tickEnd(TickEvent.ClientTickEvent event) {
        LocalPlayer player;
        if (event.phase != TickEvent.Phase.END || event.type != TickEvent.Type.CLIENT || event.side != LogicalSide.CLIENT) {
            return;
        }
        ++elapsedTicks;
        if (explosionPos != null) {
            ClientEventHandler.updateExplosion();
        }
        if ((player = Minecraft.getInstance().player) != null) {
            playerHoldingWrench = !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem() instanceof ICrystalBinder || !player.getOffhandItem().isEmpty() && player.getOffhandItem().getItem() instanceof ICrystalBinder;
        }
    }

    public static void triggerExplosionEffect(BlockPos pos, boolean reload) {
        explosionPos = pos;
        explosionRetreating = false;
        explosionAnimation = 0.0;
        explosionTime = 0;
        if (reload) {
            ProcessHandlerClient.addProcess((IProcess)new DelayedExecutor(13, new Object[0]){

                public void execute(Object[] args) {
                    Minecraft.getInstance().levelRenderer.allChanged();
                }
            });
        }
    }

    private static void updateExplosion() {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        ++explosionTime;
        if (!explosionRetreating) {
            if ((explosionAnimation += 0.05) >= 1.0) {
                explosionAnimation = 1.0;
                explosionRetreating = true;
            }
        } else {
            if (explosionAnimation <= 0.0) {
                explosionAnimation = 0.0;
                explosionPos = null;
                return;
            }
            explosionAnimation -= 0.01;
        }
    }

    private static void updateExplosionAnimation(Minecraft mc, GuiRender render, Window window, float partialTick) {
        MultiBufferSource.BufferSource buffers = RenderUtils.getGuiBuffers();
        if (explosionRetreating) {
            float alpha = explosionAnimation <= 0.0 ? 0.0f : (explosionRetreating ? (float)explosionAnimation - partialTick * 0.01f : (float)explosionAnimation + partialTick * 0.05f);
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            render.rect(0.0, 0.0, (double)window.getGuiScaledWidth(), (double)window.getGuiScaledHeight(), 0xFFFFFF | (int)(alpha * 255.0f) << 24);
            RenderUtils.endBatch((MultiBufferSource)buffers);
        } else {
            Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
            Vector3 targetPos = Vector3.fromBlockPosCenter((BlockPos)explosionPos);
            targetPos.subtract(camPos.x, camPos.y, camPos.z);
            Vector3 winPos = ClientEventHandler.gluProject(targetPos, MODELVIEW, PROJECTION);
            boolean behind = winPos.z > 1.0;
            float screenX = behind ? -1.0f : (float)winPos.x / (float)window.getScreenWidth();
            float screenY = behind ? -1.0f : (float)winPos.y / (float)window.getScreenHeight();
            DEShaders.explosionFlashScreenPos.glUniform2f(screenX, screenY);
            DEShaders.explosionFlashIntensity.glUniform1f((float)explosionAnimation);
            DEShaders.explosionFlashScreenSize.glUniform2f((float)window.getScreenWidth(), (float)window.getScreenHeight());
            render.rect(explosionFlashType, 0.0, 0.0, (double)window.getGuiScaledWidth(), (double)window.getGuiScaledHeight(), -1);
            RenderUtils.endBatch((MultiBufferSource)buffers);
        }
    }

    private static Vector3 gluProject(Vector3 obj, Matrix4 modelMatrix, Matrix4 projMatrix) {
        Vector4f o = new Vector4f((float)obj.x, (float)obj.y, (float)obj.z, 1.0f);
        ClientEventHandler.multMatrix(modelMatrix, o);
        ClientEventHandler.multMatrix(projMatrix, o);
        if (o.w() == 0.0f) {
            return Vector3.ZERO.copy();
        }
        o.w = 1.0f / o.w() * 0.5f;
        o.x = o.x() * o.w() + 0.5f;
        o.y = o.y() * o.w() + 0.5f;
        o.z = o.z() * o.w() + 0.5f;
        Vector3 winPos = new Vector3();
        winPos.z = o.z();
        winPos.x = o.x() * (float)GlStateManager.Viewport.width();
        winPos.y = o.y() * (float)GlStateManager.Viewport.height();
        return winPos;
    }

    private static void multMatrix(Matrix4 mat, Vector4f vec) {
        double x = mat.m00 * (double)vec.x() + mat.m01 * (double)vec.y() + mat.m02 * (double)vec.z() + mat.m03 * (double)vec.w();
        double y = mat.m10 * (double)vec.x() + mat.m11 * (double)vec.y() + mat.m12 * (double)vec.z() + mat.m13 * (double)vec.w();
        double z = mat.m20 * (double)vec.x() + mat.m21 * (double)vec.y() + mat.m22 * (double)vec.z() + mat.m23 * (double)vec.w();
        double w = mat.m30 * (double)vec.x() + mat.m31 * (double)vec.y() + mat.m32 * (double)vec.z() + mat.m33 * (double)vec.w();
        vec.set((float)x, (float)y, (float)z, (float)w);
    }

    static {
        playerHoldingWrench = false;
        rand = new Random();
        explosionPos = null;
        explosionAnimation = 0.0;
        explosionTime = 0;
        explosionRetreating = false;
        explosionFlashType = RenderType.create((String)"draconicevolution:explosion_flash", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> DEShaders.explosionFlashShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
        MODELVIEW = new Matrix4();
        PROJECTION = new Matrix4();
    }
}

