/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class ExplosionFX
extends Particle {
    public static CCModel model;
    public static CCModel model_inv;
    public CoreEffect coreEffect;
    private LinkedList<EffectPart> effectParts = new LinkedList();
    private static final Random rand;
    private static final RenderStateShard.DepthTestStateShard DISABLE_DEPTH;
    public static RenderType EXPLOSION_TYPE;
    public static RenderType FOG_TYPE;
    private final Vector3 pos;
    public final int radius;
    private static final ParticleRenderType FX_HANDLER;

    public ExplosionFX(ClientLevel worldIn, Vector3 pos, int radius) {
        super(worldIn, pos.x, pos.y, pos.z);
        this.pos = pos;
        this.radius = radius;
        this.lifetime = 240;
        this.coreEffect = new CoreEffect(0.0);
    }

    public boolean shouldCull() {
        return false;
    }

    public void tick() {
        if (this.effectParts.size() > 0) {
            Iterator i = this.effectParts.iterator();
            while (i.hasNext()) {
                EffectPart part = (EffectPart)i.next();
                if (part.isDead()) {
                    i.remove();
                    continue;
                }
                part.update();
            }
        }
        this.coreEffect.update();
        if (this.age > this.lifetime) {
            this.remove();
        }
        if (this.age == 0) {
            this.coreEffect = new CoreEffect(0.0);
            ClientEventHandler.triggerExplosionEffect(this.pos.pos(), true);
        } else if (this.age == 3 || this.age == 8 || this.age == 13) {
            this.effectParts.addFirst(new LeadingWave(this.age));
        } else if (this.age > 30 && this.age <= 35) {
            this.effectParts.addFirst(new BlastWave(this.age - 30));
        }
        if (this.age == 10) {
            this.level.playLocalSound(this.x, this.y, this.z, (SoundEvent)DESounds.FUSION_EXPLOSION.get(), SoundSource.PLAYERS, 100.0f, 0.9f, false);
        }
        ++this.age;
    }

    public void render(VertexConsumer b, Camera renderInfo, float partialTicks) {
        Vec3 viewVec = renderInfo.getPosition();
        Vector3 pos = new Vector3(this.x - viewVec.x, this.y - viewVec.y, this.z - viewVec.z);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = 240;
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer buffer = buffers.getBuffer(FOG_TYPE);
        ccrs.bind(buffer, DefaultVertexFormat.POSITION_COLOR);
        float ttl = 1.0f - ((float)this.age + partialTicks) / (float)this.lifetime;
        ttl = Math.min(1.0f, ttl * 5.0f);
        double od = 1200.0;
        double id = (double)this.radius / 100.0;
        ccrs.baseColour = 0xFFFFFF00 | MathHelper.clip((int)((int)(255.0f * (0.15f * ttl * Math.min(1.0f, (float)this.lifetime / 25.0f)))), (int)0, (int)255);
        for (double i = 0.0; i < 16.0; i += 1.0) {
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(od, id * i, od));
            model.render(ccrs, new IVertexOperation[]{mat});
            od += id * i;
        }
        buffers.endBatch();
        ccrs.baseColour = -1;
        if (!this.coreEffect.isDead()) {
            this.coreEffect.render(pos, ccrs, buffers, partialTicks);
        }
        for (EffectPart part : this.effectParts) {
            part.render(pos, ccrs, buffers, partialTicks);
        }
        ccrs.reset();
    }

    public ParticleRenderType getRenderType() {
        return FX_HANDLER;
    }

    static {
        rand = new Random();
        DISABLE_DEPTH = new RenderStateShard.DepthTestStateShard("none", 519){

            public void setupRenderState() {
                RenderSystem.disableDepthTest();
            }
        };
        EXPLOSION_TYPE = RenderType.create((String)"draconicevolution:explosion_shader", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setShaderState(new RenderStateShard.ShaderStateShard(() -> DEShaders.explosionShader)).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).setDepthTestState(DISABLE_DEPTH).createCompositeState(false));
        FOG_TYPE = RenderType.create((String)"draconicevolution:explosion_fog", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/reactor/reactor_core.obj")).quads().ignoreMtl().parse();
        model = CCModel.combine(map.values());
        model_inv = model.backfacedCopy();
        FX_HANDLER = new FXHandler();
    }

    private class CoreEffect
    extends EffectPart {
        public CoreEffect(double scale) {
            super(scale);
            this.maxAge = 60;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vector3 pos, CCRenderState ccrs, MultiBufferSource.BufferSource buffers, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (double)ExplosionFX.this.radius / 6.0 * (double)ttl * 2.0;
            float a = (float)this.age + partialTicks;
            VertexConsumer buffer = buffers.getBuffer(EXPLOSION_TYPE);
            ccrs.bind(buffer, DefaultVertexFormat.POSITION_TEX);
            DEShaders.explosionTime.glUniform1f(((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            DEShaders.explosionScale.glUniform1f(a > 35.0f ? (a - 35.0f) / 20.0f * 2.0f : 0.0f);
            DEShaders.explosionAlpha.glUniform1f(a > 50.0f ? 1.0f - (a - 50.0f) / 10.0f : 1.0f);
            DEShaders.explosionType.glUniform1i(0);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, scale / 2.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            buffers.endBatch();
        }
    }

    private static abstract class EffectPart {
        private boolean isDead = false;
        protected int age = 0;
        protected int maxAge = 0;
        public double scale;
        public int randOffset;

        public EffectPart(double scale) {
            this.scale = scale;
            this.randOffset = rand.nextInt(3265324);
        }

        public abstract void update();

        public abstract void render(Vector3 var1, CCRenderState var2, MultiBufferSource.BufferSource var3, float var4);

        public void setDead() {
            this.isDead = true;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }

    private class LeadingWave
    extends EffectPart {
        public LeadingWave(double scale) {
            super(scale);
            this.maxAge = 40 + (int)scale;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vector3 pos, CCRenderState ccrs, MultiBufferSource.BufferSource buffers, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            VertexConsumer buffer = buffers.getBuffer(EXPLOSION_TYPE);
            ccrs.bind(buffer, DefaultVertexFormat.POSITION_TEX);
            DEShaders.explosionTime.glUniform1f(((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            DEShaders.explosionScale.glUniform1f(ttl * 3.0f);
            DEShaders.explosionAlpha.glUniform1f(1.0f - ttl);
            DEShaders.explosionType.glUniform1i(2);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, 1.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            buffers.endBatch();
        }
    }

    private class BlastWave
    extends EffectPart {
        public BlastWave(double scale) {
            super(scale);
            this.maxAge = 150 + (int)(scale * 5.0);
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vector3 pos, CCRenderState ccrs, MultiBufferSource.BufferSource buffers, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            double vScale = (double)ExplosionFX.this.radius / 5.0 * (double)ttl * this.scale;
            float a = (float)this.age + partialTicks;
            VertexConsumer buffer = buffers.getBuffer(EXPLOSION_TYPE);
            ccrs.bind(buffer, DefaultVertexFormat.POSITION_TEX);
            DEShaders.explosionTime.glUniform1f(((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            DEShaders.explosionScale.glUniform1f(ttl);
            DEShaders.explosionAlpha.glUniform1f(a < 40.0f ? (a - 20.0f) / 20.0f : 1.0f - ttl);
            DEShaders.explosionType.glUniform1i(1);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, vScale, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            buffers.endBatch();
        }
    }

    public static class FXHandler
    implements ParticleRenderType {
        public void begin(BufferBuilder builder, TextureManager p_217600_2_) {
        }

        public void end(Tesselator tessellator) {
        }
    }
}

