/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.shader.ToolShader;
import com.brandon3055.draconicevolution.items.equipment.ModularBow;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderModularBow
extends ToolRenderBase {
    private static final float[][] STRING_BASE_COLORS = new float[][]{{0.1f, 0.5f, 0.8f, 1.0f}, {0.55f, 0.25f, 0.65f, 1.0f}, {0.7f, 0.4f, 0.2f, 1.0f}, {0.55f, 0.2f, 0.1f, 0.2f}};
    private static final RenderType bowStringType = RenderType.create((String)"shaderStringType", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.BOW_STRING_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/item/equipment/bow_string.png"), true, false)).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.WriteMaskStateShard.COLOR_WRITE).createCompositeState(false));
    private final ToolRenderBase.ToolPart basePart;
    private final ToolRenderBase.ToolPart materialPart;
    private final ToolRenderBase.ToolPart gemPart;
    @Nullable
    protected LivingEntity entity;
    @Nullable
    protected ClientLevel world;
    private final ItemOverrides overrideList = new ItemOverrides(){

        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int i) {
            RenderModularBow.this.entity = entity;
            RenderModularBow.this.world = world == null ? (entity == null ? null : (ClientLevel)entity.level()) : null;
            return originalModel;
        }
    };

    public RenderModularBow(TechLevel techLevel) {
        super(techLevel, "bow");
        Map model = new OBJParser(new ResourceLocation("draconicevolution", "models/item/equipment/bow.obj")).ignoreMtl().parse();
        this.basePart = this.basePart(((CCModel)model.get("bow_handle")).backfacedCopy());
        this.materialPart = this.materialPart(((CCModel)model.get("bow_arm")).backfacedCopy());
        this.gemPart = this.gemPart(((CCModel)model.get("bow_gem")).backfacedCopy());
    }

    public ItemOverrides getOverrides() {
        return this.overrideList;
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemDisplayContext context, Matrix4 mat, MultiBufferSource buffers, boolean gui) {
        this.transform(mat, 0.46, 0.54, 0.5, gui ? 0.9 : 1.125);
        double drawAngle = this.getDrawAngle(stack, Minecraft.getInstance().getDeltaFrameTime());
        this.basePart.render(context, buffers, mat);
        Matrix4 bottomMat = mat.copy();
        bottomMat.rotate(3.1415926535897403, Vector3.Y_POS);
        this.materialPart.render(context, buffers, mat);
        this.materialPart.render(context, buffers, bottomMat);
        boolean hasPower = this.isCreative(this.entity) || stack.getCapability(DECapabilities.Host.ITEM) != null && ModularBow.calculateShotEnergy(stack) <= EnergyUtils.getEnergyStored((ItemStack)stack);
        this.drawStrings(ccrs, context, mat, bottomMat, buffers, drawAngle, hasPower);
    }

    private void drawStrings(CCRenderState ccrs, ItemDisplayContext context, Matrix4 topMat, Matrix4 bottomMat, MultiBufferSource buffers, double drawAngle, boolean isCharged) {
        this.glUniformStringBaseColor(DEShaders.BOW_STRING_SHADER);
        TransformingVertexConsumer builder = new TransformingVertexConsumer(buffers.getBuffer(bowStringType), (Transformation)topMat);
        double crystalX = 0.12508;
        double crystalY = 0.6784399999999999;
        double A = 90.0 - drawAngle;
        double c = crystalY * (Math.sin(drawAngle * 0.017453292519943) / Math.sin(A * 0.017453292519943));
        if (isCharged) {
            this.renderBeam((VertexConsumer)builder, new Vector3(0.0, -crystalX, crystalY), new Vector3(0.0, -(crystalX + c), 0.0), ccrs.brightness);
            this.renderBeam((VertexConsumer)builder, new Vector3(0.0, -crystalX, -crystalY), new Vector3(0.0, -(crystalX + c), 0.0), ccrs.brightness);
        }
        if (drawAngle > 0.0) {
            Matrix4 arrowMat = topMat.copy();
            arrowMat.translate(0.055, 0.325 - c, 0.0);
            arrowMat.rotate(1.5707963267948701, Vector3.Z_POS);
            this.renderArrow(arrowMat, buffers, ccrs.brightness);
        }
        topMat = topMat.copy().apply(new Rotation(drawAngle * 0.017453292519943, 1.0, 0.0, 0.0).at(new Vector3(0.0, -crystalX, -crystalY)));
        bottomMat = bottomMat.copy().apply(new Rotation(drawAngle * 0.017453292519943, 1.0, 0.0, 0.0).at(new Vector3(0.0, -crystalX, -crystalY)));
        this.gemPart.render(context, buffers, topMat);
        this.gemPart.render(context, buffers, bottomMat);
    }

    private void renderBeam(VertexConsumer buffer, Vector3 source, Vector3 target, int packedLight) {
        double scale = 0.03;
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply(scale);
        planeB.multiply(scale);
        planeC.multiply(scale);
        planeD.multiply(scale);
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, packedLight);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, packedLight);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, packedLight);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferShaderQuad(buffer, p1, p2, p3, p4, packedLight);
    }

    private void bufferShaderQuad(VertexConsumer buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, int packedLight) {
        Vector3 diff1 = p2.copy().subtract(p1);
        Vector3 diff2 = p4.copy().subtract(p1);
        Vector3 norm = diff1.crossProduct(diff2).normalize();
        this.bufferVertex(buffer, p1.x, p1.y, p1.z, 0.0f, 0.0f, (float)norm.x, (float)norm.y, (float)norm.z, packedLight);
        this.bufferVertex(buffer, p2.x, p2.y, p2.z, 0.0f, 1.0f, (float)norm.x, (float)norm.y, (float)norm.z, packedLight);
        this.bufferVertex(buffer, p4.x, p4.y, p4.z, 1.0f, 1.0f, (float)norm.x, (float)norm.y, (float)norm.z, packedLight);
        this.bufferVertex(buffer, p3.x, p3.y, p3.z, 1.0f, 0.0f, (float)norm.x, (float)norm.y, (float)norm.z, packedLight);
    }

    private void renderArrow(Matrix4 mat, MultiBufferSource getter, int packedLight) {
        mat.scale((double)0.05625f, (double)0.05625f, (double)0.05625f);
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(RenderType.entityCutout((ResourceLocation)TippableArrowRenderer.NORMAL_ARROW_LOCATION)), (Transformation)mat);
        this.bufferVertex((VertexConsumer)builder, -7.0, -2.0, -2.0, 0.0f, 0.15625f, -1.0f, 0.0f, 0.0f, packedLight);
        this.bufferVertex((VertexConsumer)builder, -7.0, -2.0, 2.0, 0.15625f, 0.15625f, -1.0f, 0.0f, 0.0f, packedLight);
        this.bufferVertex((VertexConsumer)builder, -7.0, 2.0, 2.0, 0.15625f, 0.3125f, -1.0f, 0.0f, 0.0f, packedLight);
        this.bufferVertex((VertexConsumer)builder, -7.0, 2.0, -2.0, 0.0f, 0.3125f, -1.0f, 0.0f, 0.0f, packedLight);
        this.bufferVertex((VertexConsumer)builder, -7.0, 2.0, -2.0, 0.0f, 0.15625f, 1.0f, 0.0f, 0.0f, packedLight);
        this.bufferVertex((VertexConsumer)builder, -7.0, 2.0, 2.0, 0.15625f, 0.15625f, 1.0f, 0.0f, 0.0f, packedLight);
        this.bufferVertex((VertexConsumer)builder, -7.0, -2.0, 2.0, 0.15625f, 0.3125f, 1.0f, 0.0f, 0.0f, packedLight);
        this.bufferVertex((VertexConsumer)builder, -7.0, -2.0, -2.0, 0.0f, 0.3125f, 1.0f, 0.0f, 0.0f, packedLight);
        for (int j = 0; j < 4; ++j) {
            mat.rotate(1.5707963267948701, Vector3.X_POS);
            this.bufferVertex((VertexConsumer)builder, -8.5, -2.0, 0.0, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, packedLight);
            this.bufferVertex((VertexConsumer)builder, 8.5, -2.0, 0.0, 0.5f, 0.0f, 0.0f, 1.0f, 0.0f, packedLight);
            this.bufferVertex((VertexConsumer)builder, 8.5, 2.0, 0.0, 0.5f, 0.15625f, 0.0f, 1.0f, 0.0f, packedLight);
            this.bufferVertex((VertexConsumer)builder, -8.5, 2.0, 0.0, 0.0f, 0.15625f, 0.0f, 1.0f, 0.0f, packedLight);
        }
    }

    public void bufferVertex(VertexConsumer builder, double x, double y, double z, float u, float v, float normX, float normZ, float normY, int light) {
        builder.vertex(x, y, z).color(255, 255, 255, 255).uv(u, v).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(normX, normY, normZ).endVertex();
    }

    @Override
    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BOW;
    }

    private void glUniformStringBaseColor(ToolShader shader) {
        float[] color = STRING_BASE_COLORS[this.techLevel.index];
        shader.getBaseColorUniform().glUniform4f(color[0], color[1], color[2], color[3]);
    }

    private double getDrawAngle(ItemStack stack, float partialTicks) {
        if (this.entity != null && this.entity.getUseItem() == stack) {
            float maxCount = (float)this.entity.getTicksUsingItem() - partialTicks;
            return Math.max(0.0f, ModularBow.getPowerForTime((int)maxCount, stack) * 45.0f);
        }
        return 0.0;
    }

    private boolean isCreative(LivingEntity entity) {
        return entity instanceof Player && ((Player)entity).getAbilities().instabuild;
    }

    public static float torad(double degrees) {
        return (float)(degrees * 0.017453292519943);
    }

    public static class BOW_CHAOTIC
    extends RenderModularBow {
        public BOW_CHAOTIC() {
            super(TechLevel.CHAOTIC);
        }
    }

    public static class BOW_DRACONIC
    extends RenderModularBow {
        public BOW_DRACONIC() {
            super(TechLevel.DRACONIC);
        }
    }

    public static class BOW_WYVERN
    extends RenderModularBow {
        public BOW_WYVERN() {
            super(TechLevel.WYVERN);
        }
    }
}

