/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.math.MathHelper;
import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.render.modelfx.StaffModelEffect;
import com.brandon3055.draconicevolution.items.equipment.ModularStaff;
import com.google.common.collect.ImmutableMap;
import com.mojang.math.Transformation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderModularStaff
extends ToolRenderBase {
    private static final StaffModelEffect effectRenderer = new StaffModelEffect();
    private static final PerspectiveModelState TRANSFORMATION;
    private final ToolRenderBase.ToolPart baseGuiPart;
    private final ToolRenderBase.ToolPart materialGuiPart;
    private final ToolRenderBase.ToolPart traceGuiPart;
    private final ToolRenderBase.ToolPart bladeGuiPart;
    private final ToolRenderBase.ToolPart gemGuiPart;
    private final ToolRenderBase.ToolPart basePart;
    private final ToolRenderBase.ToolPart materialPart;
    private final ToolRenderBase.ToolPart tracePart;
    private final ToolRenderBase.ToolPart bladePart;
    private final ToolRenderBase.ToolPart gemPart;
    @Nullable
    protected LivingEntity entity;
    @Nullable
    protected ClientLevel world;
    private final ItemOverrides overrideList = new ItemOverrides(){

        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int light) {
            RenderModularStaff.this.entity = entity;
            RenderModularStaff.this.world = world == null ? (entity == null ? null : (ClientLevel)entity.level()) : null;
            return originalModel;
        }
    };

    public RenderModularStaff(TechLevel techLevel) {
        super(techLevel, "staff");
        Map guiModel = new OBJParser(new ResourceLocation("draconicevolution", "models/item/equipment/staff_gui.obj")).ignoreMtl().parse();
        this.baseGuiPart = this.basePart(CCModel.combine(Arrays.asList((CCModel)guiModel.get("handle"), (CCModel)guiModel.get("head_connection"))).backfacedCopy());
        this.materialGuiPart = this.materialPart(((CCModel)guiModel.get("head")).backfacedCopy());
        this.traceGuiPart = this.tracePart((CCModel)guiModel.get("trace"));
        this.bladeGuiPart = this.bladePart(((CCModel)guiModel.get("blade")).backfacedCopy());
        this.gemGuiPart = this.gemPart(((CCModel)guiModel.get("focus_gem")).backfacedCopy());
        Map model = new OBJParser(new ResourceLocation("draconicevolution", "models/item/equipment/staff.obj")).ignoreMtl().parse();
        this.basePart = this.basePart(CCModel.combine(Arrays.asList((CCModel)model.get("handle"), (CCModel)model.get("head_connection"), (CCModel)model.get("cage_connection"))).backfacedCopy());
        this.materialPart = this.materialPart(CCModel.combine(Arrays.asList((CCModel)model.get("head"), (CCModel)model.get("crystal_cage"))).backfacedCopy());
        this.tracePart = this.tracePart((CCModel)model.get("trace"));
        this.bladePart = this.bladePart(((CCModel)model.get("blade")).backfacedCopy());
        this.gemPart = this.gemPart(CCModel.combine(Arrays.asList((CCModel)model.get("focus_gem"), (CCModel)model.get("energy_crystal"))).backfacedCopy());
    }

    public ItemOverrides getOverrides() {
        return this.overrideList;
    }

    @Override
    @Nullable
    public PerspectiveModelState getModelState() {
        return TRANSFORMATION;
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemDisplayContext transform, Matrix4 mat, MultiBufferSource buffers, boolean gui) {
        float flair = 0.0f;
        if (this.entity != null && this.entity.getMainHandItem() == stack) {
            flair = MathHelper.interpolate((float)this.entity.oAttackAnim, (float)this.entity.attackAnim, (float)Minecraft.getInstance().getFrameTime());
            flair = MathHelper.clip((float)(flair * 5.0f), (float)0.0f, (float)1.0f);
        }
        this.handleArmPose(stack, transform, mat);
        if (gui) {
            this.transform(mat, 0.19, 0.19, 0.5, 1.1);
            this.baseGuiPart.render(transform, buffers, mat);
            this.materialGuiPart.render(transform, buffers, mat);
            this.traceGuiPart.render(transform, buffers, mat);
            this.bladeGuiPart.render(transform, buffers, mat);
            this.gemGuiPart.render(transform, buffers, mat);
            return;
        }
        if (transform == ItemDisplayContext.FIXED || transform == ItemDisplayContext.GROUND || transform == ItemDisplayContext.NONE) {
            this.transform(mat, 0.6, 0.6, 0.5, 0.75);
        } else {
            this.transform(mat, 0.27, 0.27, 0.5, 1.125);
            if (transform == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transform == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                mat.rotate(-0.7853981633974351, Vector3.Z_NEG);
            } else {
                mat.rotate(0.7853981633974351, Vector3.Z_NEG);
            }
        }
        this.basePart.render(transform, buffers, mat);
        this.materialPart.render(transform, buffers, mat);
        this.tracePart.render(transform, buffers, mat, flair);
        this.bladePart.render(transform, buffers, mat, flair);
        this.gemPart.render(transform, buffers, mat, flair);
        RenderUtils.endBatch((MultiBufferSource)buffers);
        Minecraft mc = Minecraft.getInstance();
        mat.rotate((double)RenderModularStaff.torad(90.0), Vector3.X_NEG);
        mat.translate(-0.5, 0.1, -0.5);
        effectRenderer.renderEffect(mat, buffers, mc.getFrameTime(), this.techLevel);
    }

    private void handleArmPose(ItemStack stack, ItemDisplayContext transform, Matrix4 mat) {
        if (this.isThirdPerson(transform)) {
            if (transform == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                mat.rotate((double)RenderModularStaff.torad(-15.0), new Vector3(-0.5, 0.5, 0.0));
            } else {
                mat.rotate((double)RenderModularStaff.torad(15.0), new Vector3(-0.5, 0.5, 0.0));
            }
            if (this.entity != null) {
                double anim = this.entity.attackAnim;
                mat.translate(0.125 * anim, 0.125 * anim, 0.0);
                mat.rotate((double)RenderModularStaff.torad(-20.0) * anim, Vector3.Z_POS);
            }
        }
    }

    private boolean isThirdPerson(ItemDisplayContext transform) {
        return transform == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transform == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    public static void doMixinStuff(LivingEntity entity, PlayerModel<?> model) {
        ItemStack mainHand = entity.getMainHandItem();
        ItemStack offHand = entity.getOffhandItem();
        boolean rightHanded = entity.getMainArm() == HumanoidArm.RIGHT;
        boolean hasMain = mainHand.getItem() instanceof ModularStaff;
        boolean hasOff = offHand.getItem() instanceof ModularStaff;
        if (hasMain) {
            if (hasMain) {
                RenderModularStaff.setStaffPose(entity, model.rightArm, model.leftArm, model.body, model.head, !rightHanded, !hasOff);
            }
            model.leftPants.copyFrom(model.leftLeg);
            model.rightPants.copyFrom(model.rightLeg);
            model.leftSleeve.copyFrom(model.leftArm);
            model.rightSleeve.copyFrom(model.rightArm);
            model.jacket.copyFrom(model.body);
        }
    }

    public static void setStaffPose(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, boolean lefthand, boolean bothHands) {
        if (lefthand) {
            leftArm.yRot = head.yRot + RenderModularStaff.torad(15.0);
            leftArm.xRot = head.xRot - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.attackAnim);
            if (bothHands) {
                rightArm.xRot = head.xRot - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.attackAnim);
                rightArm.yRot = head.yRot - RenderModularStaff.torad(45.0);
            }
        } else {
            rightArm.yRot = head.yRot - RenderModularStaff.torad(15.0);
            rightArm.xRot = head.xRot - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.attackAnim);
            if (bothHands) {
                leftArm.xRot = head.xRot - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.attackAnim);
                leftArm.yRot = head.yRot + RenderModularStaff.torad(45.0);
            }
        }
    }

    public static float torad(double degrees) {
        return (float)(degrees * 0.017453292519943);
    }

    static {
        HashMap<ItemDisplayContext, Transformation> map = new HashMap<ItemDisplayContext, Transformation>();
        map.put(ItemDisplayContext.GROUND, TransformUtils.create((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f));
        map.put(ItemDisplayContext.FIXED, TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)180.0f, (float)0.0f, (float)1.0f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, TransformUtils.create((float)0.0f, (float)1.5f, (float)-6.5f, (float)0.0f, (float)90.0f, (float)-15.0f, (float)0.85f));
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.create((float)0.0f, (float)1.5f, (float)-6.5f, (float)0.0f, (float)-90.0f, (float)15.0f, (float)0.85f));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, TransformUtils.create((float)1.13f, (float)3.2f, (float)1.13f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)0.68f));
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.create((float)1.13f, (float)3.2f, (float)1.13f, (float)0.0f, (float)-90.0f, (float)45.0f, (float)0.68f));
        TRANSFORMATION = new PerspectiveModelState((Map)ImmutableMap.copyOf(map));
    }

    public static class STAFF_CHAOTIC
    extends RenderModularStaff {
        public STAFF_CHAOTIC() {
            super(TechLevel.CHAOTIC);
        }
    }

    public static class STAFF_DRACONIC
    extends RenderModularStaff {
        public STAFF_DRACONIC() {
            super(TechLevel.DRACONIC);
        }
    }
}

