/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.modelfx;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.client.render.modelfx.ModelEffect;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class StaffModelEffect
extends ModelEffect {
    private static final RenderType renderType = RenderType.create((String)"modelEffectType", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.POSITION_COLOR_TEX_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/particle/white_orb.png"), false, false)).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));

    @Override
    public RenderType getRenderType() {
        return renderType;
    }

    @Override
    protected void doRender(VertexConsumer builder, float partialTicks, TechLevel techLevel) {
        boolean idle = false;
        float time = (float)TimeKeeper.getClientTick() + partialTicks;
        Color color = techLevel == TechLevel.CHAOTIC ? new Color(16720387) : new Color(16729091);
        this.drawFeedInParticles(builder, 16, time, idle, color);
    }

    private void drawFeedInParticles(VertexConsumer builder, int pCount, float time, boolean idle, Color color) {
        double gemHeight = 0.0;
        double minY = -0.15625;
        double maxY = 0.34375;
        for (int ci = 0; ci < pCount; ++ci) {
            StaffModelEffect.setRandSeed(ci * 8);
            float lifeTime = 10.0f + StaffModelEffect.nextFloat() * 15.0f;
            float offsetTime = time + StaffModelEffect.nextFloat() * lifeTime;
            float age = offsetTime % lifeTime / lifeTime;
            age *= age;
            StaffModelEffect.setRandSeed((int)(offsetTime / lifeTime) + (int)(StaffModelEffect.nextFloat() * 128.0f));
            double pos = -0.25 + (double)StaffModelEffect.nextFloat() * 1.25;
            double y = minY + pos * (maxY - minY);
            double z = 0.125f * (float)((double)StaffModelEffect.nextFloat() > 0.5 ? -1 : 1);
            if (pos < 0.0) {
                z *= 1.0 - pos / -0.25;
            }
            float scale = idle ? 0.0078125f + (0.5f - Math.abs(age - 0.5f)) * 0.03125f : 0.0078125f + age * 0.03125f;
            z *= 1.0 - (double)age;
            double targetY = (double)age * gemHeight - gemHeight / 2.0;
            y = MathHelper.interpolate((double)y, (double)targetY, (double)age);
            float r = color.getRed();
            float g = color.getGreen();
            float b = color.getBlue();
            this.drawParticle(builder, 0.0, y, z, scale, r / 255.0f, g / 255.0f, b / 255.0f, 1.0f);
        }
    }
}

