/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class GuardianChargeParticle
extends SingleQuadParticle {
    private Vector3 startPos;
    private Vector3 endPos;
    private double angularPos;
    private PhaseManager phaseManager;
    public TextureAtlasSprite sprite = AtlasTextureHelper.ORB_PARTICLE;

    public GuardianChargeParticle(ClientLevel world, Vector3 startPos, Vector3 endPos, double angularPos, int life, PhaseManager phaseManager) {
        super(world, startPos.x, startPos.y, startPos.z);
        this.startPos = startPos;
        this.endPos = endPos;
        this.angularPos = angularPos;
        this.phaseManager = phaseManager;
        this.lifetime = life * 4;
        this.setColor(0.75f, 0.0f, 0.0f);
        this.scale(5.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!(this.phaseManager.getCurrentPhase() instanceof ChargeUpPhase)) {
            this.alpha = (float)((double)this.alpha - 0.1);
        }
        if (this.age++ >= this.lifetime || this.alpha <= 0.0f) {
            this.remove();
        }
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        Quaternionf quaternion;
        if ((float)this.age + partialTicks > (float)this.lifetime) {
            return;
        }
        Vec3 vector3d = camera.getPosition();
        float anim = ((float)this.age + partialTicks) / (float)this.lifetime;
        Vector3 pos = MathUtils.interpolateVec3((Vector3)this.startPos, (Vector3)this.endPos, (double)anim);
        float radius = anim * 2.0f + Mth.sin((float)(anim * (float)Math.PI)) * 5.0f;
        float x = (float)(pos.x - vector3d.x()) + Mth.sin((float)((float)(this.angularPos * Math.PI * 2.0) + anim)) * radius;
        float y = (float)(pos.y - vector3d.y());
        float z = (float)(pos.z - vector3d.z()) + Mth.cos((float)((float)(this.angularPos * Math.PI * 2.0) + anim)) * radius;
        if (this.roll == 0.0f) {
            quaternion = camera.rotation();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.rotation());
            float f3 = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
            quaternion.mul((Quaternionfc)Axis.ZP.rotation(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.getQuadSize(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(x, y, z);
        }
        float uMin = this.getU0();
        float uMax = this.getU1();
        float vMin = this.getV0();
        float vMax = this.getV1();
        int j = 240;
        buffer.vertex((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).uv(uMax, vMax).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
        buffer.vertex((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).uv(uMax, vMin).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
        buffer.vertex((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).uv(uMin, vMin).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
        buffer.vertex((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).uv(uMin, vMax).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
    }

    public ParticleRenderType getRenderType() {
        return AtlasTextureHelper.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected float getU0() {
        return this.sprite.getU0();
    }

    protected float getU1() {
        return this.sprite.getU1();
    }

    protected float getV0() {
        return this.sprite.getV0();
    }

    protected float getV1() {
        return this.sprite.getV1();
    }
}

