/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class ParticleEnergy
extends TextureSheetParticle {
    public Vec3D targetPos;
    private final SpriteSet spriteSet;

    public ParticleEnergy(ClientLevel world, double xPos, double yPos, double zPos, Vec3D targetPos, SpriteSet spriteSet) {
        super(world, xPos, yPos, zPos);
        this.targetPos = targetPos;
        this.spriteSet = spriteSet;
        this.setSprite(spriteSet.get(world.random));
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.setSprite(this.spriteSet.get(this.level.random));
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.x, this.y, this.z), (Vec3D)this.targetPos);
        double speed = 0.5;
        this.xd = dir.x * speed;
        this.yd = dir.y * speed;
        this.zd = dir.z * speed;
        this.move(this.xd, this.yd, this.zd);
        if (this.age++ > this.lifetime || Utils.getDistance((double)this.x, (double)this.y, (double)this.z, (double)this.targetPos.x, (double)this.targetPos.y, (double)this.targetPos.z) < 0.5) {
            this.remove();
        }
    }

    public static class Factory
    implements ParticleProvider<IntParticleType.IntParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet p_i50823_1_) {
            this.spriteSet = p_i50823_1_;
        }

        public Particle createParticle(IntParticleType.IntParticleData data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleEnergy particleEnergy = new ParticleEnergy(world, x, y, z, new Vec3D(xSpeed, ySpeed, zSpeed), this.spriteSet);
            if (data.get().length >= 3) {
                particleEnergy.setColor((float)data.get()[0] / 255.0f, (float)data.get()[1] / 255.0f, (float)data.get()[2] / 255.0f);
            }
            if (data.get().length >= 4) {
                particleEnergy.scale((float)data.get()[3] / 100.0f);
            }
            return particleEnergy;
        }
    }
}

