/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class ParticleEnergyCoreFX
extends TextureSheetParticle {
    public static final ParticleRenderType PARTICLE_NO_DEPTH_NO_LIGHT = new ParticleRenderType(){

        public void begin(BufferBuilder builder, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public void end(Tesselator tesselator) {
            tesselator.end();
        }

        public String toString() {
            return "PARTICLE_NO_DEPTH_NO_LIGHT";
        }
    };
    public Vec3D targetPos;
    public boolean toCore = false;
    public int startRotation = 0;
    private Direction.Axis direction;
    public boolean isLargeStabilizer = false;
    private final SpriteSet spriteSet;

    public ParticleEnergyCoreFX(ClientLevel world, double xPos, double yPos, double zPos, Vec3D targetPos, SpriteSet spriteSet) {
        super(world, xPos, yPos, zPos);
        this.targetPos = targetPos;
        this.spriteSet = spriteSet;
        this.setSprite(spriteSet.get(world.random));
        this.hasPhysics = false;
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(xPos, yPos, zPos), (Vec3D)targetPos);
        this.direction = Direction.getNearest((float)((float)dir.x), (float)((float)dir.y), (float)((float)dir.z)).getAxis();
        this.lifetime = 40;
    }

    public ParticleRenderType getRenderType() {
        return PARTICLE_NO_DEPTH_NO_LIGHT;
    }

    protected int getLightColor(float p_107249_) {
        return 255;
    }

    public void tick() {
        BCProfiler.TICK.start("core_fx_update");
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        Vec3D tPos = this.targetPos.copy();
        this.setSprite(this.spriteSet.get(this.level.random));
        if (this.toCore) {
            double d;
            double rotation = ClientEventHandler.elapsedTicks;
            double offsetX = Math.sin(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double offsetY = Math.cos(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double d2 = d = this.isLargeStabilizer ? 1.8 : 0.2;
            if (this.direction == Direction.Axis.Z) {
                tPos.add(offsetX * d, offsetY * d, 0.0);
            } else if (this.direction == Direction.Axis.Y) {
                tPos.add(offsetX * d, 0.0, offsetY * d);
            } else if (this.direction == Direction.Axis.X) {
                tPos.add(0.0, offsetY * d, offsetX * d);
            }
        }
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.x, this.y, this.z), (Vec3D)tPos);
        double speed = this.toCore ? 0.5 : 0.25;
        this.xd = dir.x * speed;
        this.yd = dir.y * speed;
        this.zd = dir.z * speed;
        this.move(this.xd, this.yd, this.zd);
        if (this.age++ > this.lifetime || Utils.getDistanceSq((double)this.x, (double)this.y, (double)this.z, (double)tPos.x, (double)tPos.y, (double)tPos.z) < 0.01) {
            this.remove();
        }
        BCProfiler.TICK.stop();
    }

    public static class Factory
    implements ParticleProvider<IntParticleType.IntParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet p_i50823_1_) {
            this.spriteSet = p_i50823_1_;
        }

        public Particle createParticle(IntParticleType.IntParticleData data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleEnergyCoreFX particle = new ParticleEnergyCoreFX(world, x, y, z, new Vec3D(xSpeed, ySpeed, zSpeed), this.spriteSet);
            particle.toCore = data.get().length >= 1 && data.get()[0] == 1;
            particle.startRotation = data.get().length >= 2 ? data.get()[1] : 0;
            particle.isLargeStabilizer = data.get().length >= 3 && data.get()[2] == 1;
            particle.scale(particle.isLargeStabilizer ? 2.0f : 1.0f);
            return particle;
        }
    }
}

