/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyCoreFX;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class SparkParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    public float sparkSize = 0.5f;
    public float baseSize = 1.0f;

    public SparkParticle(ClientLevel level, double xPos, double yPos, double zPos, double xVel, double yVel, double zVel, SpriteSet spriteSet) {
        super(level, xPos, yPos, zPos);
        this.spriteSet = spriteSet;
        this.setSprite(spriteSet.get(this.random));
        this.xd = (-0.5 + this.random.nextDouble()) * xVel;
        this.yd = (-0.5 + this.random.nextDouble()) * yVel;
        this.zd = (-0.5 + this.random.nextDouble()) * zVel;
        this.lifetime = 10 + level.random.nextInt(10);
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        return ParticleEnergyCoreFX.PARTICLE_NO_DEPTH_NO_LIGHT;
    }

    public void tick() {
        super.tick();
        this.setSprite(this.spriteSet.get(this.random));
        int ttd = this.lifetime - this.age;
        if (ttd < 10) {
            this.quadSize = (float)ttd / 10.0f * this.baseSize;
        }
        if (ttd <= 1) {
            this.quadSize = this.sparkSize;
        }
    }

    public static class Factory
    implements ParticleProvider<IntParticleType.IntParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet set) {
            this.spriteSet = set;
        }

        public Particle createParticle(IntParticleType.IntParticleData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            int params = data.get().length;
            if (params >= 3) {
                particle.setColor((float)data.get()[0] / 255.0f, (float)data.get()[1] / 255.0f, (float)data.get()[2] / 255.0f);
                params -= 3;
            }
            if (params >= 1) {
                particle.baseSize = (float)data.get()[3] / 1000.0f;
                particle.quadSize = particle.baseSize;
                --params;
            }
            if (params >= 1) {
                particle.sparkSize = (float)data.get()[4] / 1000.0f;
                --params;
            }
            if (params >= 1) {
                particle.lifetime = data.get()[5];
                --params;
            }
            if (params >= 1) {
                int max = data.get()[6];
                particle.lifetime += max > 0 ? level.random.nextInt(max) : 0;
                --params;
            }
            if (params >= 1) {
                particle.gravity = (float)data.get()[7] / 1000.0f;
                --params;
            }
            if (params >= 1) {
                particle.friction = (float)data.get()[8] / 1000.0f;
                --params;
            }
            if (params >= 1) {
                particle.setParticleSpeed(xSpeed, ySpeed, zSpeed);
            }
            return particle;
        }
    }
}

